/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.colony4cc.peripheral;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IAssignsCitizen;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import nz.co.mirality.colony4cc.Colony4CC;
import nz.co.mirality.colony4cc.Constants;
import nz.co.mirality.colony4cc.LuaConversion;
import nz.co.mirality.colony4cc.Registry;
import nz.co.mirality.colony4cc.data.LuaDoc;
import nz.co.mirality.colony4cc.network.Colony4CCPacketHandler;
import nz.co.mirality.colony4cc.network.SAddBuildingOverlayPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColonyPeripheral
implements IPeripheral {
    protected boolean passedSecurityCheck = true;

    public abstract Level getWorld();

    public abstract BlockPos getPos();

    public abstract boolean equals(@Nullable IPeripheral var1);

    public abstract Object getTarget();

    @Nullable
    protected abstract IItemHandler getInventory(@Nullable Direction var1);

    @NotNull
    public String getType() {
        return "colony";
    }

    @Nullable
    private IColony getColony() {
        Level world = this.getWorld();
        if (world == null) {
            return null;
        }
        IMinecoloniesAPI api = IMinecoloniesAPI.getInstance();
        IColonyManager colonies = api.getColonyManager();
        return colonies.getColonyByPosFromWorld(world, this.getPos());
    }

    protected void securityCheck(Entity entity) {
        IColony colony;
        if (entity instanceof Player && (colony = this.getColony()) != null) {
            this.passedSecurityCheck = colony.getPermissions().hasPermission((Player)entity, Action.ACCESS_HUTS);
            return;
        }
        this.passedSecurityCheck = false;
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=1, order=1)
    public final boolean isValid() {
        return this.passedSecurityCheck && this.getColony() != null;
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=1, order=2, args="table pos", returns="boolean")
    public final Object[] isWithin(@Nullable Map<?, ?> pos) {
        Optional<BlockPos> p = ColonyPeripheral.toBlockPos(pos);
        if (p.isEmpty()) {
            return new Object[]{null, "expected coordinates"};
        }
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        return new Object[]{colony.isCoordInColony(this.getWorld(), p.get())};
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=2, order=1)
    public final Object[] getInfo() {
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        ColonyPeripheral.protectPut("getInfo", data, "id", () -> colony.getID());
        ColonyPeripheral.protectPut("getInfo", data, "name", () -> colony.getName());
        ColonyPeripheral.protectPut("getInfo", data, "active", () -> colony.isActive());
        ColonyPeripheral.protectPut("getInfo", data, "location", () -> GlobalPos.m_122643_((ResourceKey)colony.getDimension(), (BlockPos)colony.getCenter()));
        ColonyPeripheral.protectPut("getInfo", data, "style", () -> colony.getStructurePack());
        ColonyPeripheral.protectPut("getInfo", data, "happiness", () -> colony.getOverallHappiness());
        ColonyPeripheral.protectPut("getInfo", data, "raid", () -> colony.isColonyUnderAttack());
        ColonyPeripheral.protectPut("getInfo", data, "citizens", () -> colony.getCitizenManager().getCurrentCitizenCount());
        ColonyPeripheral.protectPut("getInfo", data, "maxCitizens", () -> colony.getCitizenManager().getMaxCitizens());
        return new Object[]{LuaConversion.convert(data)};
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=3, order=1)
    public final Object[] getBuildings() {
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        IRegisteredStructureManager manager = colony.getBuildingManager();
        ArrayList<HashMap<Object, Object>> buildingData = new ArrayList<HashMap<Object, Object>>();
        for (Map.Entry entry : manager.getBuildings().entrySet()) {
            IBuilding building = (IBuilding)entry.getValue();
            HashMap<Object, Object> footprintData = new HashMap<Object, Object>();
            ColonyPeripheral.protectPut("getBuildings.footprint", footprintData, "corner1", () -> building.getCorners().m_14418_());
            ColonyPeripheral.protectPut("getBuildings.footprint", footprintData, "corner2", () -> building.getCorners().m_14419_());
            ColonyPeripheral.protectPut("getBuildings.footprint", footprintData, "rotation", () -> building.getRotation());
            ColonyPeripheral.protectPut("getBuildings.footprint", footprintData, "mirror", () -> building.isMirrored());
            ArrayList citizensData = new ArrayList();
            int maxInhabitants = 0;
            for (IAssignsCitizen module : building.getModules(IAssignsCitizen.class)) {
                maxInhabitants += module.getModuleMax();
                for (ICitizenData citizen : module.getAssignedCitizen()) {
                    HashMap<Object, Object> citizenData = new HashMap<Object, Object>();
                    ColonyPeripheral.protectPut("getBuildings.citizen", citizenData, "id", () -> citizen.getId());
                    ColonyPeripheral.protectPut("getBuildings.citizen", citizenData, "name", () -> citizen.getName());
                    citizensData.add(citizenData);
                }
            }
            for (int i = citizensData.size(); i < maxInhabitants; ++i) {
                citizensData.add(new HashMap());
            }
            HashMap<Object, Object> data = new HashMap<Object, Object>();
            data.put("location", entry.getKey());
            ColonyPeripheral.protectPut("getBuildings", data, "type", () -> building.getSchematicName());
            ColonyPeripheral.protectPut("getBuildings", data, "style", () -> building.getStructurePack());
            ColonyPeripheral.protectPut("getBuildings", data, "level", () -> building.getBuildingLevel());
            ColonyPeripheral.protectPut("getBuildings", data, "maxLevel", () -> building.getMaxBuildingLevel());
            ColonyPeripheral.protectPut("getBuildings", data, "claimRadius", () -> building.getClaimRadius(building.getBuildingLevel()));
            ColonyPeripheral.protectPut("getBuildings", data, "name", () -> building.getCustomName());
            ColonyPeripheral.protectPut("getBuildings", data, "built", () -> building.isBuilt());
            ColonyPeripheral.protectPut("getBuildings", data, "wip", () -> building.hasWorkOrder());
            ColonyPeripheral.protectPut("getBuildings", data, "priority", () -> building.getPickUpPriority());
            data.put("footprint", footprintData);
            data.put("citizens", citizensData);
            ColonyPeripheral.protectPut("getBuildings", data, "storageBlocks", () -> building.getContainers().size());
            ColonyPeripheral.protectPut("getBuildings", data, "storageSlots", () -> ColonyPeripheral.calculateStorageSlots(building));
            ColonyPeripheral.protectPut("getBuildings", data, "guarded", () -> manager.hasGuardBuildingNear(building));
            buildingData.add(data);
        }
        return new Object[]{LuaConversion.convert(buildingData)};
    }

    private static int calculateStorageSlots(@NotNull IBuilding building) {
        LazyOptional capability = building.getCapability(ForgeCapabilities.ITEM_HANDLER);
        IItemHandler handler = capability.resolve().orElse(null);
        if (handler != null) {
            return handler.getSlots();
        }
        return 0;
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=4, order=1)
    public final Object[] getCitizens() {
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        ArrayList<HashMap<Object, Object>> citizensData = new ArrayList<HashMap<Object, Object>>();
        for (ICitizenData citizen : colony.getCitizenManager().getCitizens()) {
            HashMap<Object, Object> data = new HashMap<Object, Object>();
            ColonyPeripheral.protectPut("getCitizens", data, "id", () -> citizen.getId());
            ColonyPeripheral.protectPut("getCitizens", data, "name", () -> citizen.getName());
            ColonyPeripheral.protectPut("getCitizens", data, "location", () -> citizen.getLastPosition());
            ColonyPeripheral.protectPut("getCitizens", data, "bed", () -> citizen.getHomeBuilding() == null ? null : citizen.getBedPos());
            ColonyPeripheral.protectPut("getCitizens", data, "job", () -> ColonyPeripheral.JobInfo(citizen.getJob()));
            ColonyPeripheral.protectPut("getCitizens", data, "home", () -> ColonyPeripheral.BuildingInfo(citizen.getHomeBuilding()));
            ColonyPeripheral.protectPut("getCitizens", data, "work", () -> ColonyPeripheral.BuildingInfo(citizen.getWorkBuilding()));
            ColonyPeripheral.protectPut("getCitizens", data, "status", () -> ColonyPeripheral.StatusInfo(citizen.getStatus()));
            ColonyPeripheral.protectPut("getCitizens", data, "age", () -> citizen.isChild() ? "child" : "adult");
            ColonyPeripheral.protectPut("getCitizens", data, "sex", () -> citizen.isFemale() ? "female" : "male");
            ColonyPeripheral.protectPut("getCitizens", data, "saturation", () -> citizen.getSaturation());
            ColonyPeripheral.protectPut("getCitizens", data, "happiness", () -> citizen.getCitizenHappinessHandler().getHappiness(colony, citizen));
            citizen.getEntity().ifPresent(entity -> {
                data.put("health", Float.valueOf(entity.m_21223_()));
                data.put("max_health", entity.m_21133_(Attributes.f_22276_));
                data.put("armor", entity.m_21133_(Attributes.f_22284_));
                data.put("toughness", entity.m_21133_(Attributes.f_22285_));
            });
            try {
                HashMap skillsData = new HashMap();
                for (Map.Entry entry : citizen.getCitizenSkillHandler().getSkills().entrySet()) {
                    HashMap<String, Object> skillData = new HashMap<String, Object>();
                    skillData.put("level", ((Tuple)entry.getValue()).m_14418_());
                    skillData.put("xp", ((Tuple)entry.getValue()).m_14419_());
                    skillsData.put(((Skill)entry.getKey()).name(), skillData);
                }
                data.put("skills", skillsData);
            }
            catch (Exception ex) {
                Colony4CC.LOGGER.error(String.format("Error reading skills from citizen %d in colony %d: %s", citizen.getId(), colony.getID(), ex.getMessage()), (Throwable)ex);
            }
            citizensData.add(data);
        }
        return new Object[]{LuaConversion.convert(citizensData)};
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=4, order=2)
    public final Object[] getVisitors() {
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        ArrayList<HashMap<Object, Object>> visitorsData = new ArrayList<HashMap<Object, Object>>();
        for (ICivilianData civilian : colony.getVisitorManager().getCivilianDataMap().values()) {
            if (!(civilian instanceof IVisitorData)) continue;
            IVisitorData visitor = (IVisitorData)civilian;
            HashMap<Object, Object> data = new HashMap<Object, Object>();
            ColonyPeripheral.protectPut("getVisitors", data, "id", () -> visitor.getId());
            ColonyPeripheral.protectPut("getVisitors", data, "name", () -> visitor.getName());
            ColonyPeripheral.protectPut("getVisitors", data, "location", () -> visitor.getLastPosition());
            ColonyPeripheral.protectPut("getVisitors", data, "chair", () -> visitor.getSittingPosition());
            ColonyPeripheral.protectPut("getVisitors", data, "age", () -> visitor.isChild() ? "child" : "adult");
            ColonyPeripheral.protectPut("getVisitors", data, "sex", () -> visitor.isFemale() ? "female" : "male");
            ColonyPeripheral.protectPut("getVisitors", data, "saturation", () -> visitor.getSaturation());
            ColonyPeripheral.protectPut("getVisitors", data, "happiness", () -> visitor.getCitizenHappinessHandler().getHappiness(colony, (ICitizenData)visitor));
            ColonyPeripheral.protectPut("getVisitors", data, "cost", () -> visitor.getRecruitCost());
            try {
                HashMap skillsData = new HashMap();
                for (Map.Entry entry : visitor.getCitizenSkillHandler().getSkills().entrySet()) {
                    HashMap<String, Object> skillData = new HashMap<String, Object>();
                    skillData.put("level", ((Tuple)entry.getValue()).m_14418_());
                    skillData.put("xp", ((Tuple)entry.getValue()).m_14419_());
                    skillsData.put(((Skill)entry.getKey()).name(), skillData);
                }
                data.put("skills", skillsData);
            }
            catch (Exception ex) {
                Colony4CC.LOGGER.error(String.format("Error reading skills from visitor %d in colony %d: %s", visitor.getId(), colony.getID(), ex.getMessage()), (Throwable)ex);
            }
            visitorsData.add(data);
        }
        return new Object[]{LuaConversion.convert(visitorsData)};
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=4, order=3)
    public final Object[] getPlayers() {
        Map<Object, Object> visitors;
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        IPermissions permissions = colony.getPermissions();
        Set officersPresent = colony.getMessagePlayerEntities().stream().map(Entity::m_20148_).collect(Collectors.toSet());
        try {
            visitors = ((Colony)colony).getVisitingPlayers().stream().collect(Collectors.toMap(Entity::m_20148_, Function.identity()));
        }
        catch (Exception ex) {
            visitors = new HashMap();
        }
        ArrayList<HashMap<Object, Object>> players = new ArrayList<HashMap<Object, Object>>();
        for (Object player : permissions.getPlayers().values()) {
            boolean isVisitor = visitors.containsKey(player.getID());
            visitors.remove(player.getID());
            HashMap<Object, Object> playerData = new HashMap<Object, Object>();
            ColonyPeripheral.protectPut("getPlayers.players", playerData, "name", () -> ColonyPeripheral.lambda$getPlayers$49((ColonyPlayer)player));
            ColonyPeripheral.protectPut("getPlayers.players", playerData, "rank", () -> ColonyPeripheral.lambda$getPlayers$50((ColonyPlayer)player));
            if (officersPresent.contains(player.getID())) {
                playerData.put("present", true);
            } else {
                playerData.put("present", isVisitor);
            }
            players.add(playerData);
        }
        for (Object player : visitors.values()) {
            HashMap<Object, Object> playerData = new HashMap<Object, Object>();
            ColonyPeripheral.protectPut("getPlayers.players", playerData, "name", () -> ColonyPeripheral.lambda$getPlayers$51((Player)player));
            playerData.put("present", true);
            players.add(playerData);
        }
        ArrayList<HashMap<Object, Object>> ranks = new ArrayList<HashMap<Object, Object>>();
        for (Rank rank : permissions.getRanks().values()) {
            HashMap<Object, Object> rankData = new HashMap<Object, Object>();
            ColonyPeripheral.protectPut("getPlayers.ranks", rankData, "name", () -> rank.getName());
            ColonyPeripheral.protectPut("getPlayers.ranks", rankData, "hostile", () -> rank.isHostile());
            ArrayList<Object> permission = new ArrayList<Object>();
            for (Action action : Action.values()) {
                if (!permissions.hasPermission(rank, action)) continue;
                permission.add(ColonyPeripheral.ActionInfo(action));
            }
            rankData.put("permissions", permission);
            ranks.add(rankData);
        }
        HashMap<String, ArrayList<HashMap<Object, Object>>> data = new HashMap<String, ArrayList<HashMap<Object, Object>>>();
        data.put("players", players);
        data.put("ranks", ranks);
        return new Object[]{LuaConversion.convert(data)};
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=5, order=1)
    public final Object[] getWorkOrders() {
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        ArrayList<CompoundTag> worksData = new ArrayList<CompoundTag>();
        for (IWorkOrder workOrder : colony.getWorkManager().getWorkOrders().values()) {
            CompoundTag nbt = new CompoundTag();
            workOrder.write(nbt);
            worksData.add(nbt);
        }
        return new Object[]{LuaConversion.convert(worksData)};
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=5, order=2, args="number id")
    public final Object[] getWorkOrderResources(int id) {
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        IWorkOrder workOrder = colony.getWorkManager().getWorkOrder(id);
        if (workOrder == null) {
            return new Object[]{null, "no work order"};
        }
        if (!workOrder.isClaimed()) {
            return new Object[]{null, "not claimed"};
        }
        return this.getBuilderResources(workOrder.getClaimedBy());
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=5, order=3, args="table pos")
    public final Object[] getBuilderResources(@Nullable Map<?, ?> pos) {
        return ColonyPeripheral.toBlockPos(pos).map(this::getBuilderResources).orElseGet(() -> new Object[]{null, "expected coordinates"});
    }

    private Object[] getBuilderResources(BlockPos pos) {
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        IBuilding building = colony.getBuildingManager().getBuilding(pos);
        if (!(building instanceof AbstractBuildingStructureBuilder)) {
            return new Object[]{null, "not builder"};
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        building.serializeToView(buffer);
        buffer.release();
        ArrayList resources = new ArrayList(((AbstractBuildingStructureBuilder)building).getNeededResources().values());
        resources.sort(new BuildingBuilderResource.ResourceComparator(new BuildingBuilderResource.RessourceAvailability[0]));
        ArrayList<HashMap<Object, Object>> result = new ArrayList<HashMap<Object, Object>>();
        for (BuildingBuilderResource resource : resources) {
            HashMap<Object, Object> data = new HashMap<Object, Object>();
            BuildingBuilderResource resourceCopy = new BuildingBuilderResource(resource.getItemStack(), resource.getAmount(), resource.getAvailable());
            resourceCopy.setAmountInDelivery(resource.getAmountInDelivery());
            ItemStack stack = resourceCopy.getItemStack().m_41777_();
            stack.m_41764_(resourceCopy.getAmount());
            data.put("item", stack);
            ColonyPeripheral.protectPut("getBuilderResources", data, "available", () -> resourceCopy.getAvailable());
            ColonyPeripheral.protectPut("getBuilderResources", data, "delivering", () -> resourceCopy.getAmountInDelivery());
            ColonyPeripheral.protectPut("getBuilderResources", data, "status", () -> resourceCopy.getAvailabilityStatus().toString());
            result.add(data);
        }
        return new Object[]{LuaConversion.convert(result)};
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=5, order=5)
    public final Object[] getRequests() {
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        IRequestManager manager = colony.getRequestManager();
        if (manager == null) {
            return new Object[]{null, "no request system"};
        }
        IPlayerRequestResolver player = manager.getPlayerResolver();
        IRetryingRequestResolver retrying = manager.getRetryingRequestResolver();
        HashSet tokens = new HashSet();
        tokens.addAll(player.getAllAssignedRequests());
        tokens.addAll(retrying.getAllAssignedRequests());
        List<IRequest> requests = tokens.stream().map(token -> manager.getRequestForToken(token)).filter(r -> r != null && r.getRequest() instanceof IDeliverable).distinct().toList();
        ArrayList<HashMap<Object, Object>> result = new ArrayList<HashMap<Object, Object>>();
        for (IRequest request : requests) {
            IDeliverable deliverable = (IDeliverable)request.getRequest();
            HashMap<Object, Object> data = new HashMap<Object, Object>();
            ColonyPeripheral.protectPut("getRequests", data, "name", () -> ChatFormatting.m_126649_((String)request.getShortDisplayString().getString()));
            ColonyPeripheral.protectPut("getRequests", data, "desc", () -> ChatFormatting.m_126649_((String)request.getLongDisplayString().getString()));
            ColonyPeripheral.protectPut("getRequests", data, "state", () -> request.getState().toString());
            ColonyPeripheral.protectPut("getRequests", data, "count", () -> deliverable.getCount());
            ColonyPeripheral.protectPut("getRequests", data, "minCount", () -> deliverable.getMinimumCount());
            ColonyPeripheral.protectPut("getRequests", data, "items", () -> request.getDisplayStacks());
            ColonyPeripheral.protectPut("getRequests", data, "target", () -> request.getRequester().getRequesterDisplayName(manager, request).getString());
            result.add(data);
        }
        return new Object[]{LuaConversion.convert(result)};
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=6, order=1)
    public final Object[] getResearch() {
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        IGlobalResearchTree tree = IGlobalResearchTree.getInstance();
        ILocalResearchTree colonyTree = colony.getResearchManager().getResearchTree();
        HashMap<ResourceLocation, List<Object>> result = new HashMap<ResourceLocation, List<Object>>();
        for (ResourceLocation branch : tree.getBranches()) {
            result.put(branch, this.getResearch(branch, tree.getPrimaryResearch(branch), tree, colonyTree));
        }
        return new Object[]{LuaConversion.convert(result)};
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=7, order=1, args="number id, [string/number direction = \\\"up\\\"]", returns="boolean")
    public final Object[] highlightWorker(IArguments args) throws LuaException {
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        int workerId = args.getInt(0);
        Direction side = ColonyPeripheral.getDirection(args, 1);
        ICitizenData civilian = colony.getCitizenManager().getCivilian(workerId);
        if (civilian == null) {
            return new Object[]{null, "no worker"};
        }
        AbstractEntityCitizen entity = civilian.getEntity().orElse(null);
        if (entity == null) {
            return new Object[]{null, "worker unloaded"};
        }
        int costMultiplier = Colony4CC.CONFIG.getHighlightWorkerCostMultiplier();
        if (costMultiplier > 0 && !this.hasResearch(colony, Constants.RESEARCH_FREE_WORKER_HIGHLIGHT)) {
            IItemHandler handler = this.getInventory(side);
            if (handler == null) {
                return new Object[]{null, "no inventory"};
            }
            if (!this.consumeFuel(handler, ModItems.scrollHighLight, costMultiplier)) {
                return new Object[]{null, "no fuel"};
            }
        }
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2400));
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 2400));
        return new Object[]{true};
    }

    @LuaFunction(mainThread=true)
    @LuaDoc(group=7, order=2, args="table pos, [table options], [string/number direction = \\\"up\\\"]", returns="boolean")
    public final Object[] highlightBuilding(IArguments args) throws LuaException {
        BoundingBox box;
        boolean fill;
        IBuilding building;
        IColony colony = this.getColony();
        if (colony == null || !this.passedSecurityCheck) {
            return new Object[]{null, "no colony"};
        }
        BlockPos pos = ColonyPeripheral.toBlockPos(args.getTable(0)).orElse(null);
        Map options = args.optTable(1, new HashMap());
        Direction side = ColonyPeripheral.getDirection(args, 2);
        IBuilding iBuilding = building = pos == null ? null : colony.getBuildingManager().getBuilding(pos);
        if (building == null) {
            return new Object[]{null, "no building"};
        }
        ArrayList<SAddBuildingOverlayPacket.Overlay> overlays = new ArrayList<SAddBuildingOverlayPacket.Overlay>();
        if (options.containsKey("hut")) {
            fill = !options.get("hut").equals("frame");
            BoundingBox box2 = new BoundingBox(pos);
            overlays.add(new SAddBuildingOverlayPacket.Overlay(box2, 0xFF0000, fill, true));
        }
        if (options.containsKey("footprint")) {
            fill = !options.get("footprint").equals("frame");
            Tuple corners = building.getCorners();
            box = BoundingBox.m_162375_((Vec3i)((Vec3i)corners.m_14418_()), (Vec3i)((Vec3i)corners.m_14419_()));
            overlays.add(new SAddBuildingOverlayPacket.Overlay(box, 255, fill, false));
        }
        if (options.containsKey("claim")) {
            fill = !options.get("claim").equals("frame");
            int claimRadius = building.getClaimRadius(building.getBuildingLevel());
            box = ColonyPeripheral.createChunkRadiusBox(pos, claimRadius);
            overlays.add(new SAddBuildingOverlayPacket.Overlay(box, 65280, fill, false));
        }
        ServerPlayer player = null;
        if (options.containsKey("player")) {
            if (options.get("player") instanceof String) {
                player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_((String)options.get("player"));
            }
            if (player == null) {
                return new Object[]{null, "player not found"};
            }
        }
        int cost = overlays.size();
        int costMultiplier = Colony4CC.CONFIG.getHighlightBuildingCostMultiplier();
        if (cost > 0 && costMultiplier > 0 && !this.hasResearch(colony, Constants.RESEARCH_FREE_BUILDING_HIGHLIGHT)) {
            IItemHandler handler = this.getInventory(side);
            if (handler == null) {
                return new Object[]{null, "no inventory"};
            }
            if (!this.consumeFuel(handler, (Item)Registry.ModItems.RGB_CHARGE.get(), cost * costMultiplier)) {
                return new Object[]{null, "no fuel"};
            }
        }
        SAddBuildingOverlayPacket packet = new SAddBuildingOverlayPacket(colony.getWorld().m_46472_().m_135782_(), pos, overlays);
        if (player != null) {
            ServerPlayer finalPlayer = player;
            Colony4CCPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> finalPlayer), (Object)packet);
        } else {
            Colony4CCPacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)packet);
        }
        return new Object[]{true};
    }

    @NotNull
    private List<Object> getResearch(@NotNull ResourceLocation branch, @Nullable List<ResourceLocation> names, @NotNull IGlobalResearchTree tree, @NotNull ILocalResearchTree colonyTree) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (names != null && this.passedSecurityCheck) {
            for (ResourceLocation name : names) {
                IGlobalResearch research = tree.getResearch(branch, name);
                if (research == null) continue;
                ILocalResearch colonyResearch = colonyTree.getResearch(branch, name);
                HashMap<Object, Object> data = new HashMap<Object, Object>();
                data.put("id", name);
                ColonyPeripheral.protectPut("getResearch", data, "name", () -> research.getName());
                ColonyPeripheral.protectPut("getResearch", data, "effects", () -> research.getEffects().stream().map(effect -> effect.getDesc()).collect(Collectors.toList()));
                ColonyPeripheral.protectPut("getResearch", data, "status", () -> (colonyResearch == null ? ResearchState.NOT_STARTED : colonyResearch.getState()).toString());
                List<Object> children = this.getResearch(branch, research.getChildren(), tree, colonyTree);
                if (!children.isEmpty()) {
                    data.put("children", children);
                }
                result.add(data);
            }
        }
        return result;
    }

    private boolean hasResearch(@NotNull IColony colony, @NotNull ResourceLocation effectId) {
        return colony.getResearchManager().getResearchEffects().getEffectStrength(effectId) > 0.0;
    }

    private static Optional<BlockPos> toBlockPos(@Nullable Map<?, ?> table) {
        if (!(table != null && table.containsKey("x") && table.containsKey("y") && table.containsKey("z"))) {
            return Optional.empty();
        }
        int x = ((Number)table.get("x")).intValue();
        int y = ((Number)table.get("y")).intValue();
        int z = ((Number)table.get("z")).intValue();
        return Optional.of(new BlockPos(x, y, z));
    }

    private static BoundingBox createChunkRadiusBox(BlockPos pos, int chunkRadius) {
        int blockRadius = chunkRadius * 16;
        ChunkPos chunk = new ChunkPos(pos);
        int x1 = chunk.m_45604_() - blockRadius;
        int y1 = (pos.m_123342_() & 0xFFFFFFF0) - blockRadius;
        int z1 = chunk.m_45605_() - blockRadius;
        int x2 = chunk.m_45608_() + blockRadius;
        int y2 = (pos.m_123342_() | 0xF) + blockRadius;
        int z2 = chunk.m_45609_() + blockRadius;
        return new BoundingBox(x1, y1, z1, x2, y2, z2);
    }

    @Nullable
    private static Direction getDirection(@NotNull IArguments args, int index) throws LuaException {
        Object directionArg = args.get(index);
        if (directionArg instanceof String) {
            return (Direction)args.getEnum(index, Direction.class);
        }
        if (directionArg != null) {
            return Direction.m_122376_((int)args.getInt(index));
        }
        return null;
    }

    protected boolean consumeFuel(@NotNull IItemHandler handler, @NotNull Item fuel, int count) {
        int max = handler.getSlots();
        for (int slot = 0; slot < max; ++slot) {
            ItemStack result;
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.m_41619_() || !stack.m_41720_().equals(fuel) || (result = handler.extractItem(slot, count, false)).m_41619_()) continue;
            if (result.m_41613_() < count) {
                handler.insertItem(slot, result, false);
                continue;
            }
            return true;
        }
        return false;
    }

    private static Object JobInfo(IJob<?> job) {
        if (job == null) {
            return null;
        }
        return LanguageHandler.translateKey((String)job.getJobRegistryEntry().getTranslationKey());
    }

    private static Object BuildingInfo(@Nullable IBuilding building) {
        if (building == null) {
            return null;
        }
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        ColonyPeripheral.protectPut("BuildingInfo", data, "location", () -> building.getPosition());
        ColonyPeripheral.protectPut("BuildingInfo", data, "type", () -> building.getSchematicName());
        ColonyPeripheral.protectPut("BuildingInfo", data, "level", () -> building.getBuildingLevel());
        return data;
    }

    private static Object StatusInfo(@Nullable VisibleCitizenStatus status) {
        if (status == null) {
            return "Idle";
        }
        return Component.m_237115_((String)status.getTranslationKey()).getString();
    }

    private static Object ActionInfo(@NotNull Action action) {
        String name = action.toString().toLowerCase(Locale.US);
        String desc = LanguageHandler.format((String)("com.minecolonies.coremod.permission." + name), (Object[])new Object[0]);
        return desc.contains("com.minecolonies.coremod.permission.") ? name : desc;
    }

    private static void protectPut(@NotNull String context, @NotNull Map<Object, Object> data, @NotNull String key, @NotNull Supplier<Object> valueProvider) {
        try {
            data.put(key, valueProvider.get());
        }
        catch (Throwable ex) {
            Colony4CC.LOGGER.error("Error generating " + key + " in " + context, ex);
        }
    }

    private static /* synthetic */ Object lambda$getPlayers$51(Player player) {
        return player.m_7755_();
    }

    private static /* synthetic */ Object lambda$getPlayers$50(ColonyPlayer player) {
        return player.getRank().getName();
    }

    private static /* synthetic */ Object lambda$getPlayers$49(ColonyPlayer player) {
        return player.getName();
    }
}

