/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.colony4cc.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import dan200.computercraft.api.lua.LuaFunction;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.common.data.ExistingFileHelper;
import nz.co.mirality.colony4cc.Colony4CC;
import nz.co.mirality.colony4cc.data.LuaDoc;
import nz.co.mirality.colony4cc.peripheral.ColonyPeripheral;
import org.jetbrains.annotations.NotNull;

public class LuaHelpProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final ExistingFileHelper existingFileHelper;

    public LuaHelpProvider(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        this.packOutput = packOutput;
        this.existingFileHelper = existingFileHelper;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        return this.generateHelp(cache, "colony/", "colony", ColonyPeripheral.class);
    }

    @NotNull
    public String m_6055_() {
        return "LuaHelp";
    }

    private CompletableFuture<?> generateHelp(@NotNull CachedOutput cache, @NotNull String prefix, @NotNull String name, @NotNull Class<?> klass) {
        return CompletableFuture.runAsync(() -> {
            try {
                ResourceLocation location = new ResourceLocation("computercraft", prefix + name);
                PackOutput.PathProvider pathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "lua/rom/help");
                Path path = pathProvider.m_245527_(location, "txt");
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8);){
                    Resource resource = this.existingFileHelper.getResource(location, PackType.SERVER_DATA, ".txt", "lua/rom/help");
                    try (Scanner scanner = new Scanner(resource.m_215507_()).useDelimiter("(?<=\\n)|(?!\\n)(?<=\\r)");){
                        while (scanner.hasNext()) {
                            String line = scanner.next();
                            if (line.startsWith("[API]")) {
                                line = LuaHelpProvider.generateApiHelp(name, klass, line.substring(5));
                            }
                            writer.write(line);
                        }
                    }
                }
                cache.m_213871_(path, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
            }
            catch (IOException e) {
                Colony4CC.LOGGER.error("Error generating lua help for " + name, (Throwable)e);
            }
        }, Util.m_183991_());
    }

    private static String generateApiHelp(@NotNull String name, @NotNull Class<?> klass, @NotNull String newline) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (Method method : klass.getMethods()) {
            LuaFunction function = method.getAnnotation(LuaFunction.class);
            if (function == null) continue;
            LuaDoc doc = method.getAnnotation(LuaDoc.class);
            String methodName = method.getName();
            String args = LuaHelpProvider.generateApiArgs(method, doc);
            Object returns = LuaHelpProvider.generateApiReturns(method, doc);
            if (!((String)returns).isEmpty()) {
                returns = " => " + (String)returns;
            }
            MethodInfo info = new MethodInfo();
            info.method = method;
            info.function = function;
            info.doc = doc;
            info.name = methodName;
            info.content = String.format("%s.%s(%s)%s%s", name, methodName, args, returns, newline);
            methods.add(info);
        }
        methods.sort((a, b) -> {
            if (a.doc == null) {
                return b.doc == null ? 0 : 1;
            }
            if (b.doc == null) {
                return -1;
            }
            if (a.doc.group() < b.doc.group()) {
                return -1;
            }
            if (a.doc.group() > b.doc.group()) {
                return 1;
            }
            if (a.doc.order() < b.doc.order()) {
                return -1;
            }
            if (a.doc.order() > b.doc.order()) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(a.name, b.name);
        });
        return methods.stream().map(m -> m.content).collect(Collectors.joining());
    }

    private static String generateApiArgs(Method method, LuaDoc doc) {
        if (doc != null && !doc.args().isEmpty()) {
            return doc.args();
        }
        if (method.getParameterCount() == 0) {
            return "";
        }
        Colony4CC.LOGGER.warn("Missing @LuaDoc args on " + method.getName());
        return "...";
    }

    private static String generateApiReturns(Method method, LuaDoc doc) {
        if (doc != null && !doc.returns().isEmpty()) {
            return doc.returns();
        }
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            return "";
        }
        if (returnType == String.class) {
            return "string";
        }
        if (returnType.isPrimitive()) {
            return returnType.getName().toLowerCase(Locale.ROOT);
        }
        return "table";
    }

    static class MethodInfo {
        public Method method;
        public LuaFunction function;
        public LuaDoc doc;
        public String name;
        public String content;

        MethodInfo() {
        }
    }
}

