/*
 * Decompiled with CFR 0.152.
 */
package nz.co.mirality.colony4cc;

import dan200.computercraft.api.detail.VanillaDetailRegistries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import nz.co.mirality.colony4cc.Colony4CC;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LuaConversion {
    private static final List<IConverter> CONVERTERS = new ArrayList<IConverter>();

    private LuaConversion() {
    }

    public static void register(IConverter converter) {
        CONVERTERS.add(converter);
    }

    public static Object convert(Object value) {
        if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value;
        }
        for (IConverter converter : CONVERTERS) {
            Object result = converter.convert(value);
            if (result == null) continue;
            return result;
        }
        Colony4CC.LOGGER.error("Unable to convert value type {}", (Object)value.getClass().getName());
        return null;
    }

    static {
        LuaConversion.register(new CollectionConverter());
        LuaConversion.register(new MinecraftConverter());
    }

    public static interface IConverter {
        public Object convert(Object var1);
    }

    private static class CollectionConverter
    implements IConverter {
        private CollectionConverter() {
        }

        @Override
        public Object convert(Object value) {
            if (value instanceof Map) {
                Map map = (Map)value;
                HashMap result = new HashMap();
                map.forEach((k, v) -> result.put(String.valueOf(k), LuaConversion.convert(v)));
                return result;
            }
            if (value instanceof List) {
                List list = (List)value;
                HashMap<Integer, Object> result = new HashMap<Integer, Object>();
                int count = list.size();
                for (int i = 0; i < count; ++i) {
                    result.put(i + 1, LuaConversion.convert(list.get(i)));
                }
                return result;
            }
            if (value instanceof Collection) {
                Collection list = (Collection)value;
                HashMap result = new HashMap();
                int[] count = new int[]{0};
                list.forEach(v -> {
                    count[0] = count[0] + 1;
                    result.put(count[0], LuaConversion.convert(v));
                });
                return result;
            }
            return null;
        }
    }

    public static class MinecraftConverter
    implements IConverter {
        @Override
        public Object convert(Object value) {
            if (value instanceof ItemStack) {
                ItemStack stack = (ItemStack)value;
                return MinecraftConverter.convertStack(stack);
            }
            if (value instanceof GlobalPos) {
                GlobalPos pos = (GlobalPos)value;
                return this.convert(pos);
            }
            if (value instanceof BlockPos) {
                BlockPos pos = (BlockPos)value;
                return this.convert(pos);
            }
            if (value instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)value;
                return MinecraftConverter.convertNbt((Tag)tag);
            }
            if (value instanceof ResourceLocation) {
                ResourceLocation location = (ResourceLocation)value;
                return location.toString();
            }
            if (value instanceof Component) {
                Component component = (Component)value;
                return component.getString();
            }
            if (value instanceof ComponentContents) {
                ComponentContents contents = (ComponentContents)value;
                return MutableComponent.m_237204_((ComponentContents)contents).getString();
            }
            return null;
        }

        @NotNull
        private Map<Object, Object> convert(GlobalPos pos) {
            Map<Object, Object> result = this.convert(pos.m_122646_());
            result.put("world", pos.m_122640_().m_135782_().toString());
            return result;
        }

        @NotNull
        private Map<Object, Object> convert(BlockPos pos) {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            result.put("x", pos.m_123341_());
            result.put("y", pos.m_123342_());
            result.put("z", pos.m_123343_());
            return result;
        }

        @NotNull
        public static Map<Object, Object> convertStack(@NotNull ItemStack stack) {
            boolean wasEmptyish;
            boolean bl = wasEmptyish = stack != ItemStack.f_41583_ && stack.m_41613_() == 0;
            if (wasEmptyish) {
                stack.m_41764_(1);
            }
            HashMap<Object, Object> result = new HashMap<Object, Object>(VanillaDetailRegistries.ITEM_STACK.getDetails((Object)stack));
            if (wasEmptyish) {
                stack.m_41764_(0);
                result.put("count", 0);
            }
            return result;
        }

        @Nullable
        private static Object convertNbt(@Nullable Tag nbt) {
            if (nbt == null) {
                return null;
            }
            if (nbt instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)nbt;
                HashMap<String, Object> result = new HashMap<String, Object>();
                for (String key : compound.m_128431_()) {
                    result.put(key, MinecraftConverter.convertNbt(compound.m_128423_(key)));
                }
                return result;
            }
            if (nbt instanceof NumericTag) {
                return ((NumericTag)nbt).m_8103_();
            }
            if (nbt instanceof ListTag) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Tag inbt : (ListTag)nbt) {
                    result.add(MinecraftConverter.convertNbt(inbt));
                }
                return result;
            }
            return nbt.m_7916_();
        }
    }
}

