/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.recipe;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;

public class ItemStackFromIngredient {
    private final List<String> modPriorities;
    private final String key;
    private final Ingredient ingredient;
    private final int count;
    @Nullable
    private ItemStack firstItemStack;

    public ItemStackFromIngredient(List<String> modPriorities, String key, Ingredient ingredient, int count) {
        this.modPriorities = modPriorities;
        this.key = key;
        this.ingredient = ingredient;
        this.count = count;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getCount() {
        return this.count;
    }

    public ItemStack getFirstItemStack() {
        if (this.firstItemStack != null) {
            return this.firstItemStack;
        }
        ItemStack[] matchingStacks = this.ingredient.m_43908_();
        HashMap modPriorityIndex = Maps.newHashMap();
        for (int i = 0; i < this.modPriorities.size(); ++i) {
            modPriorityIndex.put(this.modPriorities.get(i), i);
        }
        ItemStack outputStack = Arrays.stream(matchingStacks).min(Comparator.comparingInt(e -> modPriorityIndex.getOrDefault(ForgeRegistries.ITEMS.getKey((Object)e.m_41720_()).m_135827_(), Integer.MAX_VALUE))).orElseThrow(() -> new IllegalStateException("No tag value found for " + this.key)).m_41777_();
        this.firstItemStack = outputStack.m_41777_();
        this.firstItemStack.m_41764_(this.count);
        return this.firstItemStack;
    }

    public void writeToPacket(FriendlyByteBuf buf) {
        buf.m_130130_(this.modPriorities.size());
        for (String modPriority : this.modPriorities) {
            buf.m_130070_(modPriority);
        }
        buf.m_130070_(this.key);
        this.ingredient.m_43923_(buf);
        buf.m_130130_(this.count);
    }

    public static ItemStackFromIngredient readFromPacket(FriendlyByteBuf buf) {
        ArrayList modPriorities = Lists.newArrayList();
        int modPrioritiesSize = buf.m_130242_();
        for (int i = 0; i < modPrioritiesSize; ++i) {
            modPriorities.add(buf.m_130277_());
        }
        String key = buf.m_130277_();
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int count = buf.m_130242_();
        return new ItemStackFromIngredient(modPriorities, key, ingredient, count);
    }
}

