/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.world.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public class InfernalSpireColumn
extends Feature<ColumnFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.f_49991_, (Object)Blocks.f_50752_, (Object)Blocks.f_50450_, (Object)Blocks.f_50135_, (Object)Blocks.f_50197_, (Object)Blocks.f_50198_, (Object)Blocks.f_50199_, (Object)Blocks.f_50200_, (Object)Blocks.f_50087_, (Object)Blocks.f_50085_);

    public InfernalSpireColumn(Codec<ColumnFeatureConfiguration> configCodec) {
        super(configCodec);
    }

    @Nullable
    private static BlockPos findSurface(WorldGenLevel level, int seaLevel, BlockPos.MutableBlockPos pos, int calculatedDistance) {
        while (pos.m_123342_() > level.m_141937_() + 1 && calculatedDistance > 0) {
            --calculatedDistance;
            if (InfernalSpireColumn.canPlaceAt(level, seaLevel, pos)) {
                return pos;
            }
            pos.m_122173_(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(WorldGenLevel level, int seaLevel, BlockPos.MutableBlockPos pos) {
        if (!InfernalSpireColumn.isAirOrLavaOcean(level, seaLevel, (BlockPos)pos)) {
            return false;
        }
        BlockState blockstate = level.m_8055_((BlockPos)pos.m_122173_(Direction.DOWN));
        pos.m_122173_(Direction.UP);
        return !blockstate.m_60795_() && !CANNOT_PLACE_ON.contains((Object)blockstate.m_60734_());
    }

    @Nullable
    private static BlockPos findAir(WorldGenLevel level, BlockPos.MutableBlockPos pos, int i) {
        while (pos.m_123342_() < level.m_151558_() && i > 0) {
            --i;
            BlockState blockstate = level.m_8055_((BlockPos)pos);
            if (CANNOT_PLACE_ON.contains((Object)blockstate.m_60734_())) {
                return null;
            }
            if (blockstate.m_60795_()) {
                return pos;
            }
            pos.m_122173_(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(WorldGenLevel level, int seaLevel, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        return blockstate.m_60795_() || blockstate.m_60713_(Blocks.f_49991_) && pos.m_123342_() <= seaLevel;
    }

    public boolean m_142674_(FeaturePlaceContext<ColumnFeatureConfiguration> context) {
        int seaLevel = context.m_159775_().m_6337_();
        BlockPos blockpos = context.m_159777_();
        RandomSource random = context.m_225041_();
        ColumnFeatureConfiguration config = (ColumnFeatureConfiguration)context.m_159778_();
        if (!InfernalSpireColumn.canPlaceAt(context.m_159774_(), seaLevel, blockpos.m_122032_())) {
            return false;
        }
        int height = config.m_160720_().m_214085_(random);
        boolean flag = random.m_188501_() < 0.9f;
        int k = Math.min(height, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos randomPos : BlockPos.m_235641_((RandomSource)random, (int)l, (int)(blockpos.m_123341_() - k), (int)blockpos.m_123342_(), (int)(blockpos.m_123343_() - k), (int)(blockpos.m_123341_() + k), (int)blockpos.m_123342_(), (int)(blockpos.m_123343_() + k))) {
            int calculatedDistance = height - randomPos.m_123333_((Vec3i)blockpos);
            if (calculatedDistance < 0) continue;
            flag1 |= this.placeColumn(context.m_159774_(), seaLevel, randomPos, calculatedDistance, config.m_160717_().m_214085_(random));
        }
        return flag1;
    }

    private boolean placeColumn(WorldGenLevel level, int seaLevel, BlockPos randomPos, int calculatedDistance, int reach) {
        boolean flag = false;
        block0: for (BlockPos blockpos : BlockPos.m_121976_((int)(randomPos.m_123341_() - reach), (int)randomPos.m_123342_(), (int)(randomPos.m_123343_() - reach), (int)(randomPos.m_123341_() + reach), (int)randomPos.m_123342_(), (int)(randomPos.m_123343_() + reach))) {
            int calculatedDistance2 = blockpos.m_123333_((Vec3i)randomPos);
            BlockPos blockpos1 = InfernalSpireColumn.isAirOrLavaOcean(level, seaLevel, blockpos) ? InfernalSpireColumn.findSurface(level, seaLevel, blockpos.m_122032_(), calculatedDistance2) : InfernalSpireColumn.findAir(level, blockpos.m_122032_(), calculatedDistance2);
            if (blockpos1 == null) continue;
            BlockPos.MutableBlockPos pos = blockpos1.m_122032_();
            for (int j = calculatedDistance - calculatedDistance2 / 2; j >= 0; --j) {
                if (InfernalSpireColumn.isAirOrLavaOcean(level, seaLevel, (BlockPos)pos)) {
                    this.m_5974_((LevelWriter)level, (BlockPos)pos, ((Block)ModBlocks.INFERNAL_SPIRE_BLOCK.get()).m_49966_());
                    pos.m_122173_(Direction.UP);
                    flag = true;
                    continue;
                }
                if (!level.m_8055_((BlockPos)pos).m_60713_((Block)ModBlocks.INFERNAL_SPIRE_BLOCK.get())) continue block0;
                pos.m_7494_();
            }
        }
        return flag;
    }
}

