/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.util;

import architectury_inject_AdAstra_common_7b013182e1c846fa94c1846ad886be8e_28ddd4886018c711c85d4ad961b88206e8dc2e9c49897d03cde0ae1128f857e5adastra1153devjar.PlatformMethods;
import com.mojang.serialization.Codec;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.data.Planet;
import earth.terrarium.ad_astra.common.data.PlanetData;
import earth.terrarium.ad_astra.common.entity.vehicle.Lander;
import earth.terrarium.ad_astra.common.entity.vehicle.Rocket;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.ad_astra.common.item.vehicle.VehicleItem;
import earth.terrarium.ad_astra.common.registry.ModCriteria;
import earth.terrarium.ad_astra.common.registry.ModEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.util.PlatformUtils;
import earth.terrarium.ad_astra.common.util.algorithm.LandFinder;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class ModUtils {
    public static final ResourceKey<Level> MOON_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "moon"));
    public static final ResourceKey<Level> MARS_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "mars"));
    public static final ResourceKey<Level> VENUS_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "venus"));
    public static final ResourceKey<Level> MERCURY_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "mercury"));
    public static final ResourceKey<Level> GLACIO_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("ad_astra", "glacio"));
    public static final float VANILLA_GRAVITY = 9.806f;
    public static final float ORBIT_TEMPERATURE = -270.0f;

    public static void teleportToLevel(ResourceKey<Level> targetWorld, Entity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel oldWorld = (ServerLevel)level;
            ServerLevel level2 = oldWorld.m_7654_().m_129880_(targetWorld);
            if (level2 == null) {
                return;
            }
            LinkedHashSet<Object> entitiesToTeleport = new LinkedHashSet<Object>();
            Vec3 targetPos = new Vec3(entity.m_20185_(), (double)VehiclesConfig.RocketConfig.atmosphereLeave, entity.m_20189_());
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Entity entity2 = player.m_20202_();
                if (entity2 instanceof Rocket) {
                    Rocket rocket = (Rocket)entity2;
                    rocket.m_20153_();
                    player.m_5661_((Component)Component.m_237115_((String)"message.ad_astra.hold_space"), false);
                    entity = ModUtils.createLander(rocket, level2, targetPos);
                    rocket.m_146870_();
                    entitiesToTeleport.add(entity);
                    entitiesToTeleport.add(player);
                } else if (player.m_20202_() == null || player.m_20202_().m_20197_().size() <= 0) {
                    entitiesToTeleport.add(entity);
                }
            } else {
                entitiesToTeleport.add(entity);
            }
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ModUtils.cookFood(itemEntity);
            }
            entitiesToTeleport.addAll(entity.m_20197_());
            for (Object entityToTeleport : entitiesToTeleport) {
                if (!(entityToTeleport instanceof ServerPlayer)) continue;
                ChunkPos chunkPos = new ChunkPos(BlockPos.m_274446_((Position)targetPos));
                level2.m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)entityToTeleport.m_19879_());
                break;
            }
            LinkedList<Entity> teleportedEntities = new LinkedList<Entity>();
            for (Entity entity2 : entitiesToTeleport) {
                PortalInfo target = new PortalInfo(targetPos, entity2.m_20184_(), entity2.m_146908_(), entity2.m_146909_());
                teleportedEntities.add(PlatformUtils.teleportToDimension(entity2, level2, target));
            }
            Entity first = (Entity)teleportedEntities.poll();
            if (first instanceof Lander) {
                Vec3 vec3 = LandFinder.findNearestLand(first.m_9236_(), new Vec3(first.m_20185_(), (double)VehiclesConfig.RocketConfig.atmosphereLeave, first.m_20189_()), 70);
                first.m_7678_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), first.m_146908_(), first.m_146909_());
            }
            for (Entity teleportedEntity : teleportedEntities) {
                if (first instanceof Lander) {
                    Vec3 nearestLand = LandFinder.findNearestLand(teleportedEntity.m_9236_(), new Vec3(teleportedEntity.m_20185_(), (double)VehiclesConfig.RocketConfig.atmosphereLeave, teleportedEntity.m_20189_()), 70);
                    teleportedEntity.m_7678_(nearestLand.m_7096_(), nearestLand.m_7098_(), nearestLand.m_7094_(), teleportedEntity.m_146908_(), teleportedEntity.m_146909_());
                }
                if (teleportedEntity == null) continue;
                teleportedEntity.m_7998_(first, true);
            }
        }
    }

    public static void teleportPlayer(ResourceKey<Level> targetWorld, ServerPlayer player) {
        ServerLevel level = player.m_20194_().m_129880_(targetWorld);
        Vec3 targetPos = new Vec3((double)player.m_20183_().m_123341_(), (double)VehiclesConfig.RocketConfig.atmosphereLeave, (double)player.m_20183_().m_123343_());
        ChunkPos chunkPos = new ChunkPos(BlockPos.m_274446_((Position)targetPos));
        level.m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)player.m_19879_());
        PortalInfo target = new PortalInfo(targetPos, player.m_20184_(), player.m_146908_(), player.m_146909_());
        PlatformUtils.teleportToDimension(player, level, target);
    }

    public static Lander createLander(Rocket rocket, ServerLevel targetWorld, Vec3 target) {
        Lander lander = new Lander((EntityType)ModEntityTypes.LANDER.get(), (Level)targetWorld);
        lander.m_146884_(target);
        for (int i = 0; i < rocket.getInventorySize(); ++i) {
            lander.getInventory().m_6836_(i, rocket.getInventory().m_8020_(i));
        }
        ItemStackHolder stack = new ItemStackHolder(rocket.getDropStack());
        ((VehicleItem)stack.getStack().m_41720_()).insert(stack, rocket.getTankHolder());
        lander.getInventory().m_6836_(10, stack.getStack());
        if (PlatformMethods.getCurrentTarget().equals("fabric")) {
            targetWorld.m_7967_((Entity)lander);
        }
        return lander;
    }

    public static void cookFood(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        ItemStack foodOutput = ItemStack.f_41583_;
        for (SmokingRecipe recipe : itemEntity.m_9236_().m_7465_().m_44013_(RecipeType.f_44110_)) {
            for (Ingredient ingredient : recipe.m_7527_()) {
                if (!ingredient.test(stack)) continue;
                foodOutput = recipe.m_8043_(itemEntity.m_9236_().m_9598_());
            }
        }
        if (!foodOutput.m_41619_()) {
            itemEntity.m_32045_(new ItemStack((ItemLike)foodOutput.m_41720_(), stack.m_41613_()));
            Entity entity = itemEntity.m_19749_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ModCriteria.FOOD_COOKED_IN_ATMOSPHERE.trigger(player);
            }
        }
    }

    public static ResourceKey<Level> getPlanetOrbit(Level level) {
        return PlanetData.getPlanetFromOrbit((ResourceKey<Level>)level.m_46472_()).map(Planet::level).orElse(Level.f_46428_);
    }

    public static float getEntityGravity(Entity entity) {
        return ModUtils.getPlanetGravity(entity.m_9236_());
    }

    public static float getPlanetGravity(Level level) {
        if (!ModUtils.isSpacelevel(level)) {
            return 1.0f;
        }
        if (ModUtils.isOrbitlevel(level)) {
            return AdAstraConfig.orbitGravity / 9.806f;
        }
        return PlanetData.getPlanetFromLevel((ResourceKey<Level>)level.m_46472_()).map(Planet::gravity).orElse(Float.valueOf(9.806f)).floatValue() / 9.806f;
    }

    public static boolean planetHasAtmosphere(Level level) {
        return PlanetData.getPlanetFromLevel((ResourceKey<Level>)level.m_46472_()).map(Planet::hasAtmosphere).orElse(false);
    }

    public static float getWorldTemperature(Level level) {
        if (ModUtils.isOrbitlevel(level)) {
            return -270.0f;
        }
        return PlanetData.getPlanetFromLevel((ResourceKey<Level>)level.m_46472_()).map(Planet::temperature).orElse(Float.valueOf(20.0f)).floatValue();
    }

    public static boolean isSpacelevel(Level level) {
        return ModUtils.isPlanet(level) || ModUtils.isOrbitlevel(level);
    }

    public static boolean isPlanet(Level level) {
        if (AdAstraConfig.avoidOverworldChecks && Level.f_46428_.equals(level.m_46472_())) {
            return false;
        }
        return PlanetData.isPlanetLevel(level);
    }

    public static boolean isOrbitlevel(Level level) {
        return PlanetData.isOrbitLevel((ResourceKey<Level>)level.m_46472_());
    }

    public static <T extends ParticleOptions> void spawnForcedParticles(ServerLevel level, T particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        for (ServerPlayer player : level.m_6907_()) {
            level.m_8624_(player, particle, true, x, y, z, count, deltaX, deltaY, deltaZ, speed);
        }
    }

    public static void rotateVehicleYaw(Vehicle vehicle, float newYaw) {
        vehicle.m_146922_(newYaw);
        vehicle.m_5618_(newYaw);
        vehicle.f_19859_ = newYaw;
    }

    public static boolean checkTag(Entity entity, TagKey<EntityType<?>> tag) {
        return entity.m_6095_().m_204039_(tag);
    }

    public static boolean checkTag(ItemStack stack, TagKey<Item> tag) {
        return stack.m_204117_(tag);
    }

    public static boolean armourIsFreezeResistant(LivingEntity entity) {
        return StreamSupport.stream(entity.m_6168_().spliterator(), false).allMatch(s -> s.m_204117_(ModTags.FREEZE_RESISTANT));
    }

    public static boolean armourIsHeatResistant(LivingEntity entity) {
        return StreamSupport.stream(entity.m_6168_().spliterator(), false).allMatch(s -> s.m_204117_(ModTags.HEAT_RESISTANT));
    }

    public static boolean armourIsOxygenated(LivingEntity entity) {
        return StreamSupport.stream(entity.m_6168_().spliterator(), false).allMatch(s -> s.m_204117_(ModTags.OXYGENATED_ARMOR));
    }

    public static long getSolarEnergy(Level level) {
        if (ModUtils.isOrbitlevel(level)) {
            return PlanetData.getPlanetFromOrbit((ResourceKey<Level>)level.m_46472_()).map(Planet::orbitSolarPower).orElse(15L);
        }
        if (ModUtils.isPlanet(level)) {
            return PlanetData.getPlanetFromLevel((ResourceKey<Level>)level.m_46472_()).map(Planet::solarPower).orElse(15L);
        }
        return 15L;
    }

    public static <T extends Enum<T>> Codec<T> createEnumCodec(Class<T> enumClass) {
        return Codec.STRING.xmap(s -> Enum.valueOf(enumClass, s.toUpperCase(Locale.ROOT)), Enum::name);
    }

    public static void sendUpdatePacket(ServerPlayer player) {
        player.f_19864_ = true;
    }
}

