/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.vehicle;

import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.item.vehicle.VehicleItem;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.screen.VehicleScreenMenuProvider;
import earth.terrarium.ad_astra.common.util.CustomInventory;
import earth.terrarium.ad_astra.common.util.FluidUtils;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.common.menu.MenuHooks;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
public abstract class Vehicle
extends Entity {
    protected static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(Vehicle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final SimpleFluidContainer tank = new SimpleFluidContainer(this.getTankSize(), 1, (amount, fluid) -> true);
    private final CustomInventory inventory = new CustomInventory(this.getInventorySize());
    public double clientYaw;
    public double clientPitch;
    public float previousYaw;
    protected double clientX;
    protected double clientY;
    protected double clientZ;
    protected double clientXVelocity;
    protected double clientYVelocity;
    protected double clientZVelocity;
    private int clientInterpolationSteps;

    public Vehicle(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(CompoundTag nbt) {
        this.inventory.m_7797_(nbt.m_128437_("Inventory", 10));
        this.getTankHolder().deserialize(nbt.m_128469_("InputFluid"));
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
        nbt.m_128365_("InputFluid", (Tag)this.getTankHolder().serialize());
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.clientInterpolationSteps = 10;
        this.m_20334_(this.clientXVelocity, this.clientYVelocity, this.clientZVelocity);
    }

    private void updatePositionAndRotation() {
        if (this.m_6109_()) {
            this.clientInterpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.clientInterpolationSteps <= 0) {
            return;
        }
        double d = this.m_20185_() + (this.clientX - this.m_20185_()) / (double)this.clientInterpolationSteps;
        double e = this.m_20186_() + (this.clientY - this.m_20186_()) / (double)this.clientInterpolationSteps;
        double f = this.m_20189_() + (this.clientZ - this.m_20189_()) / (double)this.clientInterpolationSteps;
        double g = Mth.m_14175_((double)(this.clientYaw - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)g / (float)this.clientInterpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.clientPitch - (double)this.m_146909_()) / (float)this.clientInterpolationSteps);
        --this.clientInterpolationSteps;
        this.m_6034_(d, e, f);
        this.m_19915_(this.m_146908_(), this.m_146909_());
    }

    public void m_6001_(double x, double y, double z) {
        this.clientXVelocity = x;
        this.clientYVelocity = y;
        this.clientZVelocity = z;
        this.m_20334_(this.clientXVelocity, this.clientYVelocity, this.clientZVelocity);
    }

    public void m_8119_() {
        this.previousYaw = this.m_146908_();
        super.m_8119_();
        this.updatePositionAndRotation();
        this.doMovement();
        this.slowDown();
        this.doGravity();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20101_();
        this.tryInsertingIntoTank();
    }

    public void doMovement() {
        this.m_146926_(0.0f);
        Vec3 movement = this.m_20171_(this.m_146909_(), this.m_146908_());
        double yVelocity = this.m_20184_().m_7098_();
        this.m_20256_(this.m_20184_().m_82520_(movement.m_7096_(), 0.0, movement.m_7094_()).m_82490_((double)this.getSpeed()));
        this.m_20256_(new Vec3(this.m_20184_().m_7096_(), yVelocity, this.m_20184_().m_7094_()));
    }

    public void slowDown() {
        this.setSpeed(this.getSpeed() / 1.05f);
        if ((double)this.getSpeed() < 0.001 && (double)this.getSpeed() > -0.001) {
            this.setSpeed(0.0f);
        }
        this.setSpeed(Mth.m_14036_((float)this.getSpeed(), (float)this.getMinSpeed(), (float)this.getMaxSpeed()));
    }

    public float getMinSpeed() {
        return -0.2f;
    }

    public float getMaxSpeed() {
        return 0.4f;
    }

    public void doGravity() {
        if (!this.m_9236_().m_46805_(this.m_20183_())) {
            return;
        }
        if (!this.m_20068_()) {
            if (this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -1.0E-4, 0.0));
            } else {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
            }
            if (this.m_20184_().m_7098_() < VehiclesConfig.gravity) {
                this.m_20256_(new Vec3(this.m_20184_().m_7096_(), VehiclesConfig.gravity, this.m_20184_().m_7094_()));
            }
        }
    }

    public float getSpeed() {
        return ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
    }

    public void setSpeed(float value) {
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(value));
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_20197_().size() > this.getMaxPassengers()) {
                return InteractionResult.PASS;
            }
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void openInventory(Player player) {
        this.openInventory(player, new VehicleScreenMenuProvider(this));
    }

    public void openInventory(Player player, ExtraDataMenuProvider handler) {
        if (!player.m_9236_().f_46443_ && player.m_6144_()) {
            MenuHooks.openMenu((ServerPlayer)((ServerPlayer)player), (ExtraDataMenuProvider)handler);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        Entity entity;
        if (amount > 0.0f && (entity = source.m_7639_()) instanceof Player && !((player = (Player)entity).m_20202_() instanceof Vehicle)) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46136_)) {
            BlockPos pos = this.m_20183_();
            if (!this.getDropStack().m_41619_()) {
                ItemStackHolder dropStack = new ItemStackHolder(this.getDropStack());
                ((VehicleItem)dropStack.getStack().m_41720_()).insert(dropStack, this.getTankHolder());
                CompoundTag nbt = dropStack.getStack().m_41784_();
                nbt.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
                this.m_9236_().m_5594_(null, pos, SoundEvents.f_12198_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), (double)pos.m_123341_(), (double)((float)pos.m_123342_() + 0.5f), (double)pos.m_123343_(), dropStack.getStack()));
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    public void explode(float powerMultiplier) {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 7.0f * powerMultiplier, OxygenUtils.levelHasOxygen(this.m_9236_()), Level.ExplosionInteraction.TNT);
        }
        this.m_146870_();
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.m_20184_().m_7098_() < VehiclesConfig.fallingExplosionThreshold && this.m_20096_()) {
            this.explode(VehiclesConfig.fallingExplosionMultiplier);
            return true;
        }
        return false;
    }

    public ItemStack getDropStack() {
        return ItemStack.f_41583_;
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            return entity2;
        }
        return super.m_6688_();
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    public int getMaxPassengers() {
        return 1;
    }

    public double m_6048_() {
        return 0.0;
    }

    public boolean shouldSit() {
        return true;
    }

    public boolean shouldRenderPlayer() {
        return true;
    }

    public boolean doHighFov() {
        return false;
    }

    public boolean fullyConcealsRider() {
        return false;
    }

    public boolean canRiderTakeFallDamage() {
        return true;
    }

    public boolean renderPlanetBar() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public long getTankSize() {
        return 0L;
    }

    public long getFuelPerTick() {
        return 0L;
    }

    public CustomInventory getInventory() {
        return this.inventory;
    }

    public abstract int getInventorySize();

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void tryInsertingIntoTank() {
        if (this.getInventorySize() > 1 && !this.getInventory().m_8020_(0).m_41619_() && !this.m_9236_().f_46443_) {
            FluidUtils.insertItemFluidToTank((FluidContainer)this.tank, (Container)this.getInventory(), 0, 1, 0, f -> f.m_205067_(ModTags.FUELS));
            FluidUtils.extractTankFluidToItem((FluidContainer)this.tank, (Container)this.getInventory(), 0, 1, 0, f -> true);
        }
    }

    public SimpleFluidContainer getTank() {
        return this.tank;
    }

    public FluidHolder getTankHolder() {
        return (FluidHolder)this.tank.getFluids().get(0);
    }

    public long getTankAmount() {
        return this.getTankHolder().getFluidAmount();
    }

    public Fluid getTankFluid() {
        return this.getTankHolder().getFluid();
    }

    public void consumeFuel() {
        if (this.m_9236_().m_46467_() % 20L == 0L) {
            this.getTank().extractFluid(FluidHooks.newFluidHolder((Fluid)this.getTankFluid(), (long)this.getFuelPerTick(), null), false);
        }
    }
}

