/*
 * Decompiled with CFR 0.152.
 */
package net.aaw.extendedseating.block.util;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public record ItemDescriptionsCreate(ImmutableList<Component> lines, ImmutableList<Component> linesOnShift, ImmutableList<Component> linesOnCtrl) {
    private static final Map<Item, Supplier<String>> CUSTOM_TOOLTIP_KEYS = new IdentityHashMap<Item, Supplier<String>>();

    @Nullable
    public static ItemDescriptionsCreate create(Item item, TooltipHelper.Palette palette) {
        return ItemDescriptionsCreate.create(ItemDescriptionsCreate.getTooltipTranslationKey(item), palette);
    }

    @Nullable
    public static ItemDescriptionsCreate create(String translationKey, TooltipHelper.Palette palette) {
        if (!ItemDescriptionsCreate.canFillBuilder(translationKey)) {
            return null;
        }
        Builder builder = new Builder(palette);
        ItemDescriptionsCreate.fillBuilder(builder, translationKey);
        return builder.build();
    }

    public static boolean canFillBuilder(String translationKey) {
        return I18n.m_118936_((String)translationKey);
    }

    public static void fillBuilder(Builder builder, String translationKey) {
        int i;
        String summaryKey = translationKey + ".summary";
        if (I18n.m_118936_((String)summaryKey)) {
            builder.addSummary(I18n.m_118938_((String)summaryKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String conditionKey = translationKey + ".condition" + i;
            String behaviourKey = translationKey + ".behaviour" + i;
            if (!I18n.m_118936_((String)conditionKey)) break;
            builder.addBehaviour(I18n.m_118938_((String)conditionKey, (Object[])new Object[0]), I18n.m_118938_((String)behaviourKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String controlKey = translationKey + ".control" + i;
            String actionKey = translationKey + ".action" + i;
            if (!I18n.m_118936_((String)controlKey)) break;
            builder.addAction(I18n.m_118938_((String)controlKey, (Object[])new Object[0]), I18n.m_118938_((String)actionKey, (Object[])new Object[0]));
        }
    }

    public static void useKey(Item item, Supplier<String> supplier) {
        CUSTOM_TOOLTIP_KEYS.put(item, supplier);
    }

    public static void useKey(ItemLike item, String string) {
        ItemDescriptionsCreate.useKey(item.m_5456_(), () -> string);
    }

    public static void referKey(ItemLike item, Supplier<? extends ItemLike> otherItem) {
        ItemDescriptionsCreate.useKey(item.m_5456_(), () -> ((ItemLike)otherItem.get()).m_5456_().m_5524_());
    }

    public static String getTooltipTranslationKey(Item item) {
        if (CUSTOM_TOOLTIP_KEYS.containsKey(item)) {
            return CUSTOM_TOOLTIP_KEYS.get(item).get() + ".tooltip";
        }
        return item.m_5524_() + ".tooltip";
    }

    public ImmutableList<Component> getCurrentLines() {
        if (Screen.m_96638_()) {
            return this.linesOnShift;
        }
        if (Screen.m_96637_()) {
            return this.linesOnCtrl;
        }
        return this.lines;
    }

    public static class Builder {
        protected final TooltipHelper.Palette palette;
        protected final List<String> summary = new ArrayList<String>();
        protected final List<Pair<String, String>> behaviours = new ArrayList<Pair<String, String>>();
        protected final List<Pair<String, String>> actions = new ArrayList<Pair<String, String>>();

        public Builder(TooltipHelper.Palette palette) {
            this.palette = palette;
        }

        public Builder addSummary(String summaryLine) {
            this.summary.add(summaryLine);
            return this;
        }

        public Builder addBehaviour(String condition, String behaviour) {
            this.behaviours.add((Pair<String, String>)Pair.of((Object)condition, (Object)behaviour));
            return this;
        }

        public Builder addAction(String condition, String action) {
            this.actions.add((Pair<String, String>)Pair.of((Object)condition, (Object)action));
            return this;
        }

        public ItemDescriptionsCreate build() {
            boolean bl;
            String condition;
            ArrayList lines = new ArrayList();
            ArrayList<Object> linesOnShift = new ArrayList<Object>();
            ArrayList<Object> linesOnCtrl = new ArrayList<Object>();
            for (String string : this.summary) {
                linesOnShift.addAll(TooltipHelper.cutStringTextComponent((String)string, (TooltipHelper.Palette)this.palette));
            }
            if (!this.behaviours.isEmpty()) {
                linesOnShift.add(Components.immutableEmpty());
            }
            for (Pair pair : this.behaviours) {
                condition = (String)pair.getLeft();
                String behaviour = (String)pair.getRight();
                linesOnShift.add(Components.literal((String)condition).m_130940_(ChatFormatting.GRAY));
                linesOnShift.addAll(TooltipHelper.cutStringTextComponent((String)behaviour, (Style)this.palette.primary(), (Style)this.palette.highlight(), (int)1));
            }
            for (Pair pair : this.actions) {
                condition = (String)pair.getLeft();
                String action = (String)pair.getRight();
                linesOnCtrl.add(Components.literal((String)condition).m_130940_(ChatFormatting.GRAY));
                linesOnCtrl.addAll(TooltipHelper.cutStringTextComponent((String)action, (Style)this.palette.primary(), (Style)this.palette.highlight(), (int)1));
            }
            boolean hasDescription = !linesOnShift.isEmpty();
            boolean bl2 = bl = !linesOnCtrl.isEmpty();
            if (hasDescription || bl) {
                String[] holdDesc = Lang.translateDirect((String)"tooltip.holdForDescription", (Object[])new Object[]{"$"}).getString().split("\\$");
                String[] holdCtrl = Lang.translateDirect((String)"tooltip.holdForControls", (Object[])new Object[]{"$"}).getString().split("\\$");
                MutableComponent keyShift = Lang.translateDirect((String)"tooltip.keyShift", (Object[])new Object[0]);
                MutableComponent keyCtrl = Lang.translateDirect((String)"tooltip.keyCtrl", (Object[])new Object[0]);
                for (List list : Arrays.asList(lines, linesOnShift, linesOnCtrl)) {
                    MutableComponent tabBuilder;
                    boolean ctrl;
                    boolean shift = list == linesOnShift;
                    boolean bl3 = ctrl = list == linesOnCtrl;
                    if (holdDesc.length != 2 || holdCtrl.length != 2) {
                        list.add(0, Components.literal((String)"Invalid lang formatting!"));
                        continue;
                    }
                    if (bl) {
                        tabBuilder = Components.empty();
                        tabBuilder.m_7220_((Component)Components.literal((String)holdCtrl[0]).m_130940_(ChatFormatting.DARK_GRAY));
                        tabBuilder.m_7220_((Component)keyCtrl.m_6879_().m_130940_(ctrl ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                        tabBuilder.m_7220_((Component)Components.literal((String)holdCtrl[1]).m_130940_(ChatFormatting.DARK_GRAY));
                        list.add(0, tabBuilder);
                    }
                    if (hasDescription) {
                        tabBuilder = Components.empty();
                        tabBuilder.m_7220_((Component)Components.literal((String)holdDesc[0]).m_130940_(ChatFormatting.DARK_GRAY));
                        tabBuilder.m_7220_((Component)keyShift.m_6879_().m_130940_(shift ? ChatFormatting.WHITE : ChatFormatting.GRAY));
                        tabBuilder.m_7220_((Component)Components.literal((String)holdDesc[1]).m_130940_(ChatFormatting.DARK_GRAY));
                        list.add(0, tabBuilder);
                    }
                    if (!shift && !ctrl) continue;
                    list.add(hasDescription && bl ? 2 : 1, Components.immutableEmpty());
                }
            }
            if (!hasDescription) {
                linesOnCtrl.clear();
                linesOnShift.addAll(lines);
            }
            if (!bl) {
                linesOnCtrl.clear();
                linesOnCtrl.addAll(lines);
            }
            return new ItemDescriptionsCreate((ImmutableList<Component>)ImmutableList.copyOf(lines), (ImmutableList<Component>)ImmutableList.copyOf(linesOnShift), (ImmutableList<Component>)ImmutableList.copyOf(linesOnCtrl));
        }
    }

    public static class Modifier
    implements TooltipModifier {
        protected final Item item;
        protected final TooltipHelper.Palette palette;
        protected String cachedLanguage;
        protected ItemDescriptionsCreate description;

        public Modifier(Item item, TooltipHelper.Palette palette) {
            this.item = item;
            this.palette = palette;
        }

        public void modify(ItemTooltipEvent context) {
            if (this.checkLocale()) {
                this.description = ItemDescriptionsCreate.create(this.item, this.palette);
            }
            if (this.description == null) {
                return;
            }
            context.getToolTip().addAll(1, this.description.getCurrentLines());
        }

        protected boolean checkLocale() {
            String currentLanguage = Minecraft.m_91087_().m_91102_().m_264236_();
            if (!currentLanguage.equals(this.cachedLanguage)) {
                this.cachedLanguage = currentLanguage;
                return true;
            }
            return false;
        }
    }
}

