/*
 * Decompiled with CFR 0.152.
 */
package net.aaw.extendedseating.block.custom;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.aaw.extendedseating.BigSeatEntity;
import net.aaw.extendedseating.block.ModBlocks;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeBlockState;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChairBlockExtendsSeat
extends SeatBlock
implements ProperWaterloggedBlock,
IWrenchable {
    protected final DyeColor color;
    public static final EnumProperty<ArmrestConfigurations> ARMRESTS = EnumProperty.m_61587_((String)"armrests", ArmrestConfigurations.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)5.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape SHAPE_BACK = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)7.0, (double)12.0), Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)13.0, (double)12.0, (double)16.0, (double)20.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public ChairBlockExtendsSeat(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties, color);
        this.color = color;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public boolean isNormalCube(IForgeBlockState state) {
        return false;
    }

    public boolean isOpaqueCube(IForgeBlockState state) {
        return false;
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
        pBuilder.m_61104_(new Property[]{FACING});
        pBuilder.m_61104_(new Property[]{ARMRESTS});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(ARMRESTS, (Comparable)((Object)ArmrestConfigurations.NONE));
    }

    public static void sitDown(Level world, BlockPos pos, Entity entity) {
        if (world.f_46443_) {
            return;
        }
        BigSeatEntity seat = new BigSeatEntity(world, pos);
        seat.m_6034_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.34f, (float)pos.m_123343_() + 0.5f);
        world.m_7967_((Entity)seat);
        entity.m_7998_((Entity)seat, true);
        if (entity instanceof TamableAnimal) {
            TamableAnimal ta = (TamableAnimal)entity;
            ta.m_21837_(true);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        ItemStack heldItem = player.m_21120_(hand);
        if (heldItem == AllItems.WRENCH.asStack(1)) {
            return InteractionResult.PASS;
        }
        if (heldItem.m_150930_(AllItems.WRENCH.m_5456_())) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        DyeColor color = DyeColor.getColor((ItemStack)heldItem);
        if (color != null && color != this.color) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockState newState = BlockHelper.copyProperties((BlockState)state, (BlockState)ModBlocks.CHAIRS.get(color).getDefaultState());
            world.m_46597_(pos, newState);
            return InteractionResult.SUCCESS;
        }
        List seats = world.m_45976_(BigSeatEntity.class, new AABB(pos));
        if (!seats.isEmpty()) {
            BigSeatEntity BigSeatEntity2 = (BigSeatEntity)((Object)seats.get(0));
            List passengers = BigSeatEntity2.m_20197_();
            if (!passengers.isEmpty() && passengers.get(0) instanceof Player) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                BigSeatEntity2.m_20153_();
                player.m_20329_((Entity)BigSeatEntity2);
            }
            return InteractionResult.SUCCESS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ChairBlockExtendsSeat.sitDown(world, pos, (Entity)ChairBlockExtendsSeat.getLeashed((Level)world, (Player)player).or((Object)player));
        return InteractionResult.SUCCESS;
    }

    public void m_5548_(BlockGetter reader, Entity entity) {
        BlockPos pos = entity.m_20183_();
        if (entity instanceof Player || !(entity instanceof LivingEntity) || !ChairBlockExtendsSeat.canBePickedUp((Entity)entity) || ChairBlockExtendsSeat.isSeatOccupied((Level)entity.m_9236_(), (BlockPos)pos)) {
            if (entity.m_20162_()) {
                super.m_5548_(reader, entity);
                return;
            }
            Vec3 vec3 = entity.m_20184_();
            if (vec3.f_82480_ < 0.0) {
                double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
                entity.m_20334_(vec3.f_82479_, -vec3.f_82480_ * (double)0.66f * d0, vec3.f_82481_);
            }
            return;
        }
        if (reader.m_8055_(pos).m_60734_() != this) {
            return;
        }
        ChairBlockExtendsSeat.sitDown(entity.m_9236_(), pos, entity);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (!world.f_46443_) {
            world.m_7731_(pos, (BlockState)state.m_61122_(ARMRESTS), 3);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (!world.f_46443_) {
            world.m_7731_(pos, (BlockState)state.m_61122_(ARMRESTS), 3);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState updateAfterWrenched(BlockState newState, UseOnContext context) {
        return Block.m_49931_((BlockState)newState, (LevelAccessor)context.m_43725_(), (BlockPos)context.m_8083_());
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.ordinal() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE;
            }
            case SOUTH: {
                return ChairBlockExtendsSeat.rotateShape(Direction.NORTH, Direction.WEST, SHAPE);
            }
            case WEST: {
                return ChairBlockExtendsSeat.rotateShape(Direction.NORTH, Direction.EAST, SHAPE);
            }
        }
        return ChairBlockExtendsSeat.rotateShape(Direction.NORTH, Direction.SOUTH, SHAPE);
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((Direction)pState.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_BACK;
            }
            case SOUTH: {
                return ChairBlockExtendsSeat.rotateShape(Direction.NORTH, Direction.WEST, SHAPE_BACK);
            }
            case WEST: {
                return ChairBlockExtendsSeat.rotateShape(Direction.NORTH, Direction.EAST, SHAPE_BACK);
            }
        }
        return ChairBlockExtendsSeat.rotateShape(Direction.NORTH, Direction.SOUTH, SHAPE_BACK);
    }

    public static enum ArmrestConfigurations implements StringRepresentable
    {
        NONE,
        LEFT,
        RIGHT,
        BOTH;


        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

