/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.valkyrienskies.physics_api.RigidBodyInertiaData;

public class RigidBodyInertiaDataEncoder {
    public static final int RIGID_BODY_INERTIA_DATA_BYTES_SIZE = 80;

    @NotNull
    public static byte[] encodeRigidBodyInertiaData(@NotNull RigidBodyInertiaData rigidBodyInertiaData) {
        ByteBuffer outputBuffer = ByteBuffer.allocate(80);
        outputBuffer.order(ByteOrder.LITTLE_ENDIAN);
        outputBuffer.putDouble(rigidBodyInertiaData.getInvMass());
        outputBuffer.putDouble(rigidBodyInertiaData.getInvMOI().m00());
        outputBuffer.putDouble(rigidBodyInertiaData.getInvMOI().m10());
        outputBuffer.putDouble(rigidBodyInertiaData.getInvMOI().m20());
        outputBuffer.putDouble(rigidBodyInertiaData.getInvMOI().m01());
        outputBuffer.putDouble(rigidBodyInertiaData.getInvMOI().m11());
        outputBuffer.putDouble(rigidBodyInertiaData.getInvMOI().m21());
        outputBuffer.putDouble(rigidBodyInertiaData.getInvMOI().m02());
        outputBuffer.putDouble(rigidBodyInertiaData.getInvMOI().m12());
        outputBuffer.putDouble(rigidBodyInertiaData.getInvMOI().m22());
        return outputBuffer.array();
    }

    public static RigidBodyInertiaData decodeRigidBodyInertiaData(@NotNull byte[] encoded) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(encoded);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        double invMass = byteBuffer.getDouble();
        double invMOI00 = byteBuffer.getDouble();
        double invMOI10 = byteBuffer.getDouble();
        double invMOI20 = byteBuffer.getDouble();
        double invMOI01 = byteBuffer.getDouble();
        double invMOI11 = byteBuffer.getDouble();
        double invMOI21 = byteBuffer.getDouble();
        double invMOI02 = byteBuffer.getDouble();
        double invMOI12 = byteBuffer.getDouble();
        double invMOI22 = byteBuffer.getDouble();
        Matrix3d invInertia = new Matrix3d(invMOI00, invMOI01, invMOI02, invMOI10, invMOI11, invMOI12, invMOI20, invMOI21, invMOI22);
        return new RigidBodyInertiaData(invMass, (Matrix3dc)invInertia);
    }
}

