/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.joml.primitives.AABBic;
import org.valkyrienskies.physics_api.PhysicsWorldReference;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api.constraints.ConstraintAndId;
import org.valkyrienskies.physics_api.voxel_updates.VoxelRigidBodyShapeUpdates;
import org.valkyrienskies.physics_api_krunch.ConstraintEncoder;
import org.valkyrienskies.physics_api_krunch.KrunchNativeRigidBodyReference;
import org.valkyrienskies.physics_api_krunch.KrunchPhysicsWorldSettingsc;
import org.valkyrienskies.physics_api_krunch.VoxelRigidBodyShapeUpdatesEncoder;

class KrunchNativePhysicsWorldReference
implements PhysicsWorldReference {
    private static final long DELETED_PHYSICS_WORLD_POINTER = 0L;
    private long physicsWorldPointer = KrunchNativePhysicsWorldReference.createKrunchNativePhysicsWorld();
    private boolean hasBeenDeleted = false;

    protected KrunchNativePhysicsWorldReference() throws OutOfMemoryError {
    }

    @Override
    @NotNull
    public KrunchNativeRigidBodyReference createVoxelRigidBody(int dimension, @NotNull Vector3ic minDefined, @NotNull Vector3ic maxDefined, @NotNull AABBic totalVoxelRegion) throws OutOfMemoryError, UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        int rigidBodyUniqueId = KrunchNativePhysicsWorldReference.createVoxelRigidBody(this.physicsWorldPointer, dimension, minDefined.x(), minDefined.y(), minDefined.z(), maxDefined.x(), maxDefined.y(), maxDefined.z(), totalVoxelRegion.minX(), totalVoxelRegion.minY(), totalVoxelRegion.minZ(), totalVoxelRegion.maxX(), totalVoxelRegion.maxY(), totalVoxelRegion.maxZ());
        return new KrunchNativeRigidBodyReference(this, rigidBodyUniqueId);
    }

    @Override
    public void queueVoxelShapeUpdates(@NotNull VoxelRigidBodyShapeUpdates[] array) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] encoded = VoxelRigidBodyShapeUpdatesEncoder.encodeVoxelRigidBodyShapeUpdatesArray(array);
        KrunchNativePhysicsWorldReference.queueVoxelShapeUpdates(this.physicsWorldPointer, encoded);
    }

    @Override
    public void tick(@NotNull Vector3dc gravity, double timeStep, boolean simulatePhysics) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        KrunchNativePhysicsWorldReference.tick(this.physicsWorldPointer, gravity.x(), gravity.y(), gravity.z(), timeStep, simulatePhysics);
    }

    public void setSettings(@NotNull KrunchPhysicsWorldSettingsc settingsWrapper) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        KrunchNativePhysicsWorldReference.setSettings(this.physicsWorldPointer, settingsWrapper.getSubSteps(), settingsWrapper.getIterations(), settingsWrapper.getSolverIterationWeight(), settingsWrapper.getCollisionCompliance(), settingsWrapper.getCollisionRestitutionCompliance(), settingsWrapper.getDynamicFrictionCompliance(), settingsWrapper.getSpeculativeContactDistance(), settingsWrapper.getSolverType().getSolverName(), settingsWrapper.getMaxCollisionPoints(), settingsWrapper.getMaxCollisionPointDepth(), settingsWrapper.getMaxDePenetrationSpeed(), settingsWrapper.getMaxVoxelShapeCollisionPoints());
    }

    @Override
    public void deletePhysicsWorldResources() {
        if (!this.hasBeenDeleted) {
            KrunchNativePhysicsWorldReference.deleteKrunchNativePhysicsWorld(this.physicsWorldPointer);
            this.physicsWorldPointer = 0L;
            this.hasBeenDeleted = true;
        }
    }

    @Override
    public boolean deleteRigidBody(int rigidBodyId) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        return KrunchNativePhysicsWorldReference.deleteRigidBody(this.physicsWorldPointer, rigidBodyId);
    }

    @Override
    public boolean hasBeenDeleted() {
        return this.hasBeenDeleted;
    }

    @Override
    public boolean addConstraint(@NotNull ConstraintAndId constraintAndId) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] bytesRaw = ConstraintEncoder.encodeConstraintAndId(constraintAndId);
        return KrunchNativePhysicsWorldReference.addConstraintAndId(this.physicsWorldPointer, bytesRaw);
    }

    @Override
    @NotNull
    public List<ConstraintAndId> getConstraints() throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] bytesRaw = KrunchNativePhysicsWorldReference.getConstraints(this.physicsWorldPointer);
        return ConstraintEncoder.decodeConstraints(bytesRaw);
    }

    @Override
    @NotNull
    public List<ConstraintAndId> getConstraintsBrokenLastTick() throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] bytesRaw = KrunchNativePhysicsWorldReference.getConstraintsBrokenLastTick(this.physicsWorldPointer);
        return ConstraintEncoder.decodeConstraints(bytesRaw);
    }

    @Override
    @NotNull
    public List<ConstraintAndId> getConstraintsRemovedFromDeletedBodiesLastTick() throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] bytesRaw = KrunchNativePhysicsWorldReference.getConstraintsRemovedFromDeletedBodiesLastTick(this.physicsWorldPointer);
        return ConstraintEncoder.decodeConstraints(bytesRaw);
    }

    @Override
    public boolean removeConstraint(int constraintId) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        return KrunchNativePhysicsWorldReference.removeConstraint(this.physicsWorldPointer, constraintId);
    }

    @Override
    public boolean updateConstraint(@NotNull ConstraintAndId constraintAndId) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] bytesRaw = ConstraintEncoder.encodeConstraintAndId(constraintAndId);
        return KrunchNativePhysicsWorldReference.updateConstraint(this.physicsWorldPointer, bytesRaw);
    }

    private void ensureResourcesNotDeleted() throws UsingDeletedReferenceException {
        if (this.hasBeenDeleted()) {
            throw new UsingDeletedReferenceException("The underlying physics world has already been deleted!");
        }
    }

    protected long getPhysicsWorldPointer() {
        return this.physicsWorldPointer;
    }

    private static native long createKrunchNativePhysicsWorld() throws OutOfMemoryError;

    private static native void deleteKrunchNativePhysicsWorld(long var0);

    private static native int createVoxelRigidBody(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14) throws OutOfMemoryError;

    private static native void queueVoxelShapeUpdates(long var0, @NotNull byte[] var2);

    private static native void tick(long var0, double var2, double var4, double var6, double var8, boolean var10);

    private static native void setSettings(long var0, int var2, int var3, double var4, double var6, double var8, double var10, double var12, String var14, int var15, double var16, double var18, int var20);

    private static native boolean deleteRigidBody(long var0, int var2);

    private static native boolean addConstraintAndId(long var0, @NotNull byte[] var2);

    private static native byte[] getConstraints(long var0);

    private static native byte[] getConstraintsBrokenLastTick(long var0);

    private static native byte[] getConstraintsRemovedFromDeletedBodiesLastTick(long var0);

    private static native boolean removeConstraint(long var0, int var2);

    private static native boolean updateConstraint(long var0, @NotNull byte[] var2);
}

