/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.PoseVel;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\b\u0018\u0000 -2\u00020\u0001:\u0001-B\u001f\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b+\u0010,J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c2\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\nJ\u0015\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0019J\u001d\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0015\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0019J\u001d\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001cJ\u0010\u0010!\u001a\u00020 H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b#\u0010\u0019J\u001d\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\u0004\b#\u0010\u001cJ\u0015\u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b$\u0010\u0019J\u001d\u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\u0004\b$\u0010\u001cJ\u0015\u0010%\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016\u00a2\u0006\u0004\b%\u0010\u0019J\u001d\u0010%\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\u0004\b%\u0010\u001cR\u0017\u0010\r\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010&\u001a\u0004\b'\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010(R\u0017\u0010\f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\f\u0010)\u001a\u0004\b*\u0010\u0007\u00a8\u0006."}, d2={"Lorg/valkyrienskies/physics_api/SegmentDisplacement;", "", "Lorg/valkyrienskies/physics_api/PoseVel;", "component1", "()Lorg/valkyrienskies/physics_api/PoseVel;", "", "component2", "()D", "", "component3", "()I", "poseVel", "scaling", "dimension", "copy", "(Lorg/valkyrienskies/physics_api/PoseVel;DI)Lorg/valkyrienskies/physics_api/SegmentDisplacement;", "other", "", "equals", "(Ljava/lang/Object;)Z", "getPoseVelForInternalUseOnly", "hashCode", "Lorg/joml/Vector3d;", "direction", "invTransformDirectionWithScale", "(Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "Lorg/joml/Vector3dc;", "dest", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "invTransformDirectionWithoutScale", "position", "invTransformPosition", "", "toString", "()Ljava/lang/String;", "transformDirectionWithScale", "transformDirectionWithoutScale", "transformPosition", "I", "getDimension", "Lorg/valkyrienskies/physics_api/PoseVel;", "D", "getScaling", "<init>", "(Lorg/valkyrienskies/physics_api/PoseVel;DI)V", "Companion", "physics_api"})
public final class SegmentDisplacement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PoseVel poseVel;
    private final double scaling;
    private final int dimension;

    public SegmentDisplacement(@NotNull PoseVel poseVel, double scaling, int dimension) {
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        this.poseVel = poseVel;
        this.scaling = scaling;
        this.dimension = dimension;
    }

    public final double getScaling() {
        return this.scaling;
    }

    public final int getDimension() {
        return this.dimension;
    }

    @NotNull
    public final Vector3d transformPosition(@NotNull Vector3dc position, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        position.mul(this.scaling, dest);
        return this.poseVel.transformPosition(dest);
    }

    @NotNull
    public final Vector3d invTransformPosition(@NotNull Vector3dc position, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        this.poseVel.invTransformPosition(position, dest);
        Vector3d vector3d = dest.div(this.scaling);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"dest.div(scaling)");
        return vector3d;
    }

    @NotNull
    public final Vector3d transformDirectionWithScale(@NotNull Vector3dc direction, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        direction.mul(this.scaling, dest);
        return this.poseVel.transformDirection(dest);
    }

    @NotNull
    public final Vector3d invTransformDirectionWithScale(@NotNull Vector3dc direction, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        this.poseVel.invTransformDirection(direction, dest);
        Vector3d vector3d = dest.div(this.scaling);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"dest.div(scaling)");
        return vector3d;
    }

    @NotNull
    public final Vector3d transformPosition(@NotNull Vector3d position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.transformPosition((Vector3dc)position, position);
    }

    @NotNull
    public final Vector3d invTransformPosition(@NotNull Vector3d position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.invTransformPosition((Vector3dc)position, position);
    }

    @NotNull
    public final Vector3d transformDirectionWithScale(@NotNull Vector3d direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.transformDirectionWithScale((Vector3dc)direction, direction);
    }

    @NotNull
    public final Vector3d invTransformDirectionWithScale(@NotNull Vector3d direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.invTransformDirectionWithScale((Vector3dc)direction, direction);
    }

    @NotNull
    public final Vector3d transformDirectionWithoutScale(@NotNull Vector3dc direction, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        return this.poseVel.transformDirection(direction, dest);
    }

    @NotNull
    public final Vector3d invTransformDirectionWithoutScale(@NotNull Vector3dc direction, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        return this.poseVel.invTransformDirection(direction, dest);
    }

    @NotNull
    public final Vector3d transformDirectionWithoutScale(@NotNull Vector3d direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.transformDirectionWithoutScale((Vector3dc)direction, direction);
    }

    @NotNull
    public final Vector3d invTransformDirectionWithoutScale(@NotNull Vector3d direction) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return this.invTransformDirectionWithoutScale((Vector3dc)direction, direction);
    }

    @Deprecated(message="Only the Krunch physics API should use this! Nothing else!")
    @NotNull
    public final PoseVel getPoseVelForInternalUseOnly() {
        return this.poseVel;
    }

    private final PoseVel component1() {
        return this.poseVel;
    }

    public final double component2() {
        return this.scaling;
    }

    public final int component3() {
        return this.dimension;
    }

    @NotNull
    public final SegmentDisplacement copy(@NotNull PoseVel poseVel, double scaling, int dimension) {
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        return new SegmentDisplacement(poseVel, scaling, dimension);
    }

    public static /* synthetic */ SegmentDisplacement copy$default(SegmentDisplacement segmentDisplacement, PoseVel poseVel, double d, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            poseVel = segmentDisplacement.poseVel;
        }
        if ((n2 & 2) != 0) {
            d = segmentDisplacement.scaling;
        }
        if ((n2 & 4) != 0) {
            n = segmentDisplacement.dimension;
        }
        return segmentDisplacement.copy(poseVel, d, n);
    }

    @NotNull
    public String toString() {
        return "SegmentDisplacement(poseVel=" + this.poseVel + ", scaling=" + this.scaling + ", dimension=" + this.dimension + ')';
    }

    public int hashCode() {
        int result = this.poseVel.hashCode();
        result = result * 31 + Double.hashCode(this.scaling);
        result = result * 31 + Integer.hashCode(this.dimension);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SegmentDisplacement)) {
            return false;
        }
        SegmentDisplacement segmentDisplacement = (SegmentDisplacement)other;
        if (!Intrinsics.areEqual((Object)this.poseVel, (Object)segmentDisplacement.poseVel)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scaling, (Object)segmentDisplacement.scaling)) {
            return false;
        }
        return this.dimension == segmentDisplacement.dimension;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/valkyrienskies/physics_api/SegmentDisplacement$Companion;", "", "", "scaling", "", "dimension", "Lorg/valkyrienskies/physics_api/SegmentDisplacement;", "createSegmentDisplacement", "(DI)Lorg/valkyrienskies/physics_api/SegmentDisplacement;", "<init>", "()V", "physics_api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SegmentDisplacement createSegmentDisplacement(double scaling, int dimension) {
            if (scaling < 1.0E-6) {
                throw new IllegalArgumentException("Scaling " + scaling + " is too small!");
            }
            return new SegmentDisplacement(PoseVel.Companion.getNULL_POSE_VEL(), scaling, dimension);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

