/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server.world;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Wing;
import org.valkyrienskies.core.api.ships.WingManager;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.apigame.world.chunks.TerrainUpdate;
import org.valkyrienskies.mod.common.IShipObjectWorldServerProvider;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.block.WingBlock;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixin.accessors.server.world.ChunkMapAccessor;

@Mixin(value={ServerLevel.class})
public abstract class MixinServerLevel
implements IShipObjectWorldServerProvider {
    @Shadow
    @Final
    private ServerChunkCache f_8547_;
    private final Map<ChunkPos, List<Vector3ic>> knownChunks = new HashMap<ChunkPos, List<Vector3ic>>();

    @Shadow
    @NotNull
    public abstract MinecraftServer m_7654_();

    @Override
    @Nullable
    public ServerShipWorldCore getShipObjectWorld() {
        return ((IShipObjectWorldServerProvider)this.m_7654_()).getShipObjectWorld();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    void onInit(CallbackInfo ci) {
        if (this.getShipObjectWorld() != null) {
            this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((Level)((ServerLevel)this)), VSGameUtilsKt.getYRange((Level)((ServerLevel)this)));
        }
    }

    @WrapOperation(method={"sendParticles(Lnet/minecraft/server/level/ServerPlayer;ZDDDLnet/minecraft/network/protocol/Packet;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;closerToCenterThan(Lnet/minecraft/core/Position;D)Z")})
    private boolean includeShipsInParticleDistanceCheck(BlockPos player, Position particle, double distance, Operation<Boolean> closerToCenterThan) {
        ServerLevel self = (ServerLevel)ServerLevel.class.cast(this);
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos(self, (int)particle.m_7096_() >> 4, (int)particle.m_7094_() >> 4);
        if (ship == null) {
            return (Boolean)closerToCenterThan.call(new Object[]{player, particle, distance});
        }
        Vector3d posInWorld = ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(particle));
        return posInWorld.distanceSquared((double)player.m_123341_(), (double)player.m_123342_(), (double)player.m_123343_()) < distance * distance;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void postTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        ServerLevel self = (ServerLevel)ServerLevel.class.cast(this);
        ServerShipWorldCore shipObjectWorld = VSGameUtilsKt.getShipObjectWorld(self);
        ChunkMapAccessor chunkMapAccessor = (ChunkMapAccessor)this.f_8547_.f_8325_;
        ArrayList<TerrainUpdate> voxelShapeUpdates = new ArrayList<TerrainUpdate>();
        for (ChunkHolder chunkHolder : chunkMapAccessor.callGetChunks()) {
            LevelChunk worldChunk;
            Optional worldChunkOptional = chunkHolder.m_140026_().getNow(ChunkHolder.f_139997_).left();
            if (!worldChunkOptional.isPresent() || this.knownChunks.containsKey((worldChunk = (LevelChunk)worldChunkOptional.get()).m_7697_())) continue;
            ArrayList<Vector3i> voxelChunkPositions = new ArrayList<Vector3i>();
            int chunkX = worldChunk.m_7697_().f_45578_;
            int chunkZ = worldChunk.m_7697_().f_45579_;
            LevelChunkSection[] chunkSections = worldChunk.m_7103_();
            for (int sectionY = 0; sectionY < chunkSections.length; ++sectionY) {
                LevelChunkSection chunkSection = chunkSections[sectionY];
                Vector3i chunkPos = new Vector3i(chunkX, worldChunk.m_151568_(sectionY), chunkZ);
                voxelChunkPositions.add(chunkPos);
                if (chunkSection != null && !chunkSection.m_188008_()) {
                    TerrainUpdate voxelShapeUpdate = VSGameUtilsKt.toDenseVoxelUpdate(chunkSection, (Vector3ic)chunkPos);
                    voxelShapeUpdates.add(voxelShapeUpdate);
                    ServerLevel thisAsLevel = (ServerLevel)ServerLevel.class.cast(this);
                    LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos(thisAsLevel, chunkX, chunkZ);
                    if (ship == null) continue;
                    WingManager shipAsWingManager = (WingManager)ship.getAttachment(WingManager.class);
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                BlockState blockState = chunkSection.m_62982_(x, y, z);
                                int posX = (chunkX << 4) + x;
                                int posY = (sectionY << 4) + worldChunk.m_141937_() + y;
                                int posZ = (chunkZ << 4) + z;
                                if (!(blockState.m_60734_() instanceof WingBlock)) continue;
                                mutableBlockPos.m_122178_(posX, posY, posZ);
                                Wing wing = ((WingBlock)blockState.m_60734_()).getWing((Level)thisAsLevel, (BlockPos)mutableBlockPos, blockState);
                                if (wing == null) continue;
                                shipAsWingManager.setWing(shipAsWingManager.getFirstWingGroupId(), posX, posY, posZ, wing);
                            }
                        }
                    }
                    continue;
                }
                TerrainUpdate emptyVoxelShapeUpdate = ValkyrienSkiesMod.getVsCore().newEmptyVoxelShapeUpdate(chunkPos.x(), chunkPos.y(), chunkPos.z(), true);
                voxelShapeUpdates.add(emptyVoxelShapeUpdate);
            }
            this.knownChunks.put(worldChunk.m_7697_(), voxelChunkPositions);
        }
        Iterator<Map.Entry<ChunkPos, List<Vector3ic>>> knownChunkPosIterator = this.knownChunks.entrySet().iterator();
        while (knownChunkPosIterator.hasNext()) {
            Map.Entry<ChunkPos, List<Vector3ic>> knownChunkPosEntry = knownChunkPosIterator.next();
            if (chunkMapAccessor.callGetVisibleChunkIfPresent(knownChunkPosEntry.getKey().m_45588_()) != null) continue;
            for (Vector3ic unloadedChunk : knownChunkPosEntry.getValue()) {
                TerrainUpdate deleteVoxelShapeUpdate = ValkyrienSkiesMod.getVsCore().newDeleteTerrainUpdate(unloadedChunk.x(), unloadedChunk.y(), unloadedChunk.z());
                voxelShapeUpdates.add(deleteVoxelShapeUpdate);
            }
            knownChunkPosIterator.remove();
        }
        shipObjectWorld.addTerrainUpdates(VSGameUtilsKt.getDimensionId((Level)self), voxelShapeUpdates);
    }
}

