/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server.world;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;
import org.valkyrienskies.mod.common.util.ShipSettingsKt;

@Mixin(value={ChunkMap.class})
public abstract class MixinChunkMap {
    @Shadow
    @Final
    ServerLevel f_140133_;
    @Shadow
    @Final
    private Supplier<DimensionDataStorage> f_140137_;

    @Shadow
    protected abstract CompoundTag m_214947_(CompoundTag var1);

    @Inject(method={"readChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private void preReadChunk(ChunkPos chunkPos, CallbackInfoReturnable<CompletableFuture<Optional<CompoundTag>>> cir) {
        ChunkMap self = (ChunkMap)ChunkMap.class.cast(this);
        cir.setReturnValue((Object)self.m_223454_(chunkPos).thenApplyAsync(compoundTag -> {
            ServerShip ship;
            if (compoundTag.isEmpty() && ((ship = VSGameUtilsKt.getShipManagingPos(this.f_140133_, chunkPos.f_45578_, chunkPos.f_45579_)) == null && VSGameUtilsKt.isChunkInShipyard((Level)this.f_140133_, chunkPos.f_45578_, chunkPos.f_45579_) || ship != null && !ShipSettingsKt.getSettings(ship).getShouldGenerateChunks())) {
                LevelChunk generatedChunk = new LevelChunk(this.f_140133_, new ProtoChunk(chunkPos, UpgradeData.f_63320_, (LevelHeightAccessor)this.f_140133_, this.f_140133_.m_9598_().m_175515_(Registries.f_256952_), null), null);
                return Optional.of(ChunkSerializer.m_63454_((ServerLevel)this.f_140133_, (ChunkAccess)generatedChunk));
            }
            return compoundTag.map(this::m_214947_);
        }));
    }

    @Inject(method={"getPlayers"}, at={@At(value="TAIL")}, cancellable=true)
    private void postGetPlayersWatchingChunk(ChunkPos chunkPos, boolean onlyOnWatchDistanceEdge, CallbackInfoReturnable<List<ServerPlayer>> cir) {
        Iterator<IPlayer> playersWatchingShipChunk = VSGameUtilsKt.getShipObjectWorld(this.f_140133_).getIPlayersWatchingShipChunk(chunkPos.f_45578_, chunkPos.f_45579_, VSGameUtilsKt.getDimensionId((Level)this.f_140133_));
        if (!playersWatchingShipChunk.hasNext()) {
            return;
        }
        List oldReturnValue = (List)cir.getReturnValue();
        HashSet watchingPlayers = new HashSet(oldReturnValue);
        playersWatchingShipChunk.forEachRemaining(iPlayer -> {
            MinecraftPlayer minecraftPlayer = (MinecraftPlayer)iPlayer;
            ServerPlayer playerEntity = (ServerPlayer)minecraftPlayer.getPlayerEntityReference().get();
            if (playerEntity != null) {
                watchingPlayers.add(playerEntity);
            }
        });
        cir.setReturnValue(new ArrayList(watchingPlayers));
    }
}

