/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.entity.handling.VSEntityManager;
import org.valkyrienskies.mod.common.util.MinecraftPlayer;
import org.valkyrienskies.mod.util.KrunchSupport;

@Mixin(value={PlayerList.class})
public abstract class MixinPlayerList {
    @Shadow
    @Final
    private List<ServerPlayer> f_11196_;
    @Shadow
    @Final
    private MinecraftServer f_11195_;

    @Shadow
    public abstract void m_11241_(@Nullable Player var1, double var2, double var4, double var6, double var8, ResourceKey<Level> var10, Packet<?> var11);

    @Inject(method={"placeNewPlayer"}, at={@At(value="TAIL")})
    private void afterPlayerJoin(Connection netManager, ServerPlayer player, CallbackInfo ci) {
        MinecraftPlayer wrapped = VSGameUtilsKt.getPlayerWrapper((Player)player);
        ValkyrienSkiesMod.getVsCore().getHooks().afterClientJoinServer(wrapped);
        if (!KrunchSupport.INSTANCE.isKrunchSupported()) {
            player.m_213846_((Component)Component.m_237113_((String)"VS 2 physics are disabled on this server, because Krunch is not supported on this server!  Current supported platforms are: Windows x86-64, Linux x86-64, Linux aarch64, Macos x86-64, Macos arm64").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        }
        VSEntityManager.INSTANCE.syncHandlers(wrapped);
    }

    @Inject(method={"broadcast"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendToAround(@Nullable Player player, double x, double y, double z, double distance, ResourceKey<Level> worldKey, Packet<?> packet, CallbackInfo ci) {
        ServerLevel world = this.f_11195_.m_129880_(worldKey);
        if (world == null) {
            return;
        }
        if (player != null && VSGameUtilsKt.isChunkInShipyard((Level)world, (int)player.m_20182_().f_82479_ >> 4, (int)player.m_20182_().f_82480_ >> 4)) {
            return;
        }
        LoadedShip ship = VSGameUtilsKt.getShipObjectManagingPos((Level)world, (int)x >> 4, (int)z >> 4);
        if (ship == null) {
            return;
        }
        Vector3d p = VSGameUtilsKt.toWorldCoordinates((Ship)ship, x, y, z);
        this.m_11241_(player, p.x, p.y, p.z, distance, worldKey, packet);
        ci.cancel();
    }
}

