/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.optifine;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.optifine.Config;
import net.optifine.render.VboRegion;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.mixinducks.client.render.IVSViewAreaMethods;

@Mixin(value={ViewArea.class})
public abstract class MixinViewAreaOptifine
implements IVSViewAreaMethods {
    private final Long2ObjectMap<ChunkRenderDispatcher.RenderChunk[]> vs$shipRenderChunks = new Long2ObjectOpenHashMap();
    @Shadow
    @Final
    protected Level f_110839_;
    @Shadow
    protected int f_110840_;
    private ChunkRenderDispatcher vs$chunkBuilder;
    @Shadow(remap=false)
    private Map<ChunkPos, VboRegion[]> mapVboRegions;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(ChunkRenderDispatcher chunkBuilder, Level world, int viewDistance, LevelRenderer worldRenderer, CallbackInfo callbackInfo) {
        this.vs$chunkBuilder = chunkBuilder;
    }

    @Shadow(remap=false)
    protected abstract void updateVboRegion(ChunkRenderDispatcher.RenderChunk var1);

    @Inject(method={"setDirty"}, at={@At(value="HEAD")}, cancellable=true)
    private void preScheduleRebuild(int x, int y, int z, boolean important, CallbackInfo callbackInfo) {
        if (y < 0 || y >= this.f_110840_) {
            return;
        }
        if (VSGameUtilsKt.isChunkInShipyard(this.f_110839_, x, z)) {
            long chunkPosAsLong = ChunkPos.m_45589_((int)x, (int)z);
            ChunkRenderDispatcher.RenderChunk[] renderChunksArray = (ChunkRenderDispatcher.RenderChunk[])this.vs$shipRenderChunks.computeIfAbsent(chunkPosAsLong, k -> new ChunkRenderDispatcher.RenderChunk[this.f_110840_]);
            if (renderChunksArray[y] == null) {
                ChunkRenderDispatcher.RenderChunk builtChunk;
                ChunkRenderDispatcher chunkRenderDispatcher = this.vs$chunkBuilder;
                Objects.requireNonNull(chunkRenderDispatcher);
                renderChunksArray[y] = builtChunk = new ChunkRenderDispatcher.RenderChunk(chunkRenderDispatcher, 0, x << 4, y << 4, z << 4);
                if (Config.isVbo() && Config.isRenderRegions()) {
                    this.updateVboRegion(renderChunksArray[y]);
                }
            }
            renderChunksArray[y].m_112828_(important);
            callbackInfo.cancel();
        }
    }

    @Inject(method={"getRenderChunkAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetRenderedChunk(BlockPos pos, CallbackInfoReturnable<ChunkRenderDispatcher.RenderChunk> callbackInfoReturnable) {
        int chunkX = Mth.m_14042_((int)pos.m_123341_(), (int)16);
        int chunkY = Mth.m_14042_((int)pos.m_123342_(), (int)16);
        int chunkZ = Mth.m_14042_((int)pos.m_123343_(), (int)16);
        if (chunkY < 0 || chunkY >= this.f_110840_) {
            return;
        }
        if (VSGameUtilsKt.isChunkInShipyard(this.f_110839_, chunkX, chunkZ)) {
            long chunkPosAsLong = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
            ChunkRenderDispatcher.RenderChunk[] renderChunksArray = (ChunkRenderDispatcher.RenderChunk[])this.vs$shipRenderChunks.get(chunkPosAsLong);
            if (renderChunksArray == null) {
                callbackInfoReturnable.setReturnValue(null);
                return;
            }
            ChunkRenderDispatcher.RenderChunk renderChunk = renderChunksArray[chunkY];
            callbackInfoReturnable.setReturnValue((Object)renderChunk);
        }
    }

    @Override
    public void unloadChunk(int chunkX, int chunkZ) {
        if (VSGameUtilsKt.isChunkInShipyard(this.f_110839_, chunkX, chunkZ)) {
            VboRegion[] vboRegions;
            ChunkRenderDispatcher.RenderChunk[] chunks = (ChunkRenderDispatcher.RenderChunk[])this.vs$shipRenderChunks.remove(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
            if (chunks != null) {
                for (ChunkRenderDispatcher.RenderChunk chunk : chunks) {
                    chunk.m_112838_();
                }
            }
            if ((vboRegions = this.mapVboRegions.remove(new ChunkPos(chunkX, chunkZ))) != null) {
                for (VboRegion vboRegion : vboRegions) {
                    if (vboRegion == null) continue;
                    vboRegion.deleteGlBuffers();
                }
            }
        }
    }

    @Inject(method={"releaseAllBuffers"}, at={@At(value="HEAD")})
    private void postReleaseAllBuffers(CallbackInfo ci) {
        for (Long2ObjectMap.Entry entry : this.vs$shipRenderChunks.long2ObjectEntrySet()) {
            for (ChunkRenderDispatcher.RenderChunk renderChunk : (ChunkRenderDispatcher.RenderChunk[])entry.getValue()) {
                if (renderChunk == null) continue;
                renderChunk.m_112838_();
            }
        }
        this.vs$shipRenderChunks.clear();
    }
}

