/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.flywheel;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.gl.GlStateTracker;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.InstanceWorld;
import com.jozufozu.flywheel.backend.instancing.ParallelTaskEngine;
import com.jozufozu.flywheel.backend.instancing.TaskEngine;
import com.jozufozu.flywheel.backend.instancing.batching.BatchingEngine;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import java.util.WeakHashMap;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.mod.common.VSClientGameUtils;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixinducks.MixinBlockEntityInstanceManagerDuck;
import org.valkyrienskies.mod.mixinducks.MixinInstancingEngineDuck;

@Pseudo
@Mixin(value={InstanceWorld.class}, remap=false)
public class MixinInstanceWorld {
    @Shadow
    @Final
    protected InstanceManager<BlockEntity> blockEntityInstanceManager;
    @Shadow
    @Final
    public ParallelTaskEngine taskEngine;

    @Inject(method={"renderLayer"}, at={@At(value="INVOKE", target="Lcom/jozufozu/flywheel/backend/instancing/Engine;render(Lcom/jozufozu/flywheel/backend/instancing/TaskEngine;Lcom/jozufozu/flywheel/event/RenderLayerEvent;)V")})
    void renderShipTiles(RenderLayerEvent event, CallbackInfo ci) {
        GlStateTracker.State restoreState = GlStateTracker.getRestoreState();
        WeakHashMap<ClientShip, MaterialManager> shipManagers = ((MixinBlockEntityInstanceManagerDuck)this.blockEntityInstanceManager).getShipMaterialManagers();
        shipManagers.forEach((ship, manager) -> this.render((ClientShip)ship, (MaterialManager)manager, event));
        restoreState.restore();
    }

    @Unique
    void render(ClientShip ship, MaterialManager manager, RenderLayerEvent event) {
        if (manager instanceof InstancingEngine) {
            InstancingEngine engine = (InstancingEngine)manager;
            Vector3d origin = VectorConversionsMCKt.toJOMLD(engine.getOriginCoordinate());
            Matrix4d viewProjection = new Matrix4d((Matrix4fc)event.viewProjection);
            Matrix4d finalProjection = new Matrix4d().mul((Matrix4dc)viewProjection).translate(-event.camX, -event.camY, -event.camZ).mul(ship.getRenderTransform().getShipToWorld()).translate((Vector3dc)origin);
            Vector3d camInShipLocal = ship.getRenderTransform().getWorldToShip().transformPosition(event.camX, event.camY, event.camZ, new Vector3d()).sub((Vector3dc)origin);
            Matrix4f fnlProj = new Matrix4f((Matrix4dc)finalProjection);
            ((MixinInstancingEngineDuck)engine).render(fnlProj, camInShipLocal.x, camInShipLocal.y, camInShipLocal.z, event.layer);
        } else if (manager instanceof BatchingEngine) {
            BatchingEngine engine = (BatchingEngine)manager;
            event.stack.m_85836_();
            VSClientGameUtils.multiplyWithShipToWorld(event.stack, ship);
            engine.render((TaskEngine)this.taskEngine, event);
            event.stack.m_85849_();
        } else {
            throw new IllegalArgumentException("unrecognized engine");
        }
    }
}

