/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.flywheel;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.Instance;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.InstancedRenderRegistry;
import com.jozufozu.flywheel.backend.instancing.batching.BatchingEngine;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstanceManager;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.core.Contexts;
import com.jozufozu.flywheel.core.compile.ProgramCompiler;
import java.util.WeakHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Vector3i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.world.LevelYRange;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.mixin.mod_compat.flywheel.InstancingEngineAccessor;
import org.valkyrienskies.mod.mixinducks.MixinBlockEntityInstanceManagerDuck;

@ParametersAreNonnullByDefault
@Pseudo
@Mixin(value={BlockEntityInstanceManager.class})
public abstract class MixinBlockEntityInstanceManager
extends InstanceManager<BlockEntity>
implements MixinBlockEntityInstanceManagerDuck {
    @Unique
    private final WeakHashMap<ClientShip, MaterialManager> shipMaterialManagers = new WeakHashMap();

    @Override
    public WeakHashMap<ClientShip, MaterialManager> getShipMaterialManagers() {
        return this.shipMaterialManagers;
    }

    public MixinBlockEntityInstanceManager(MaterialManager materialManager) {
        super(materialManager);
    }

    @Inject(method={"createRaw(Lnet/minecraft/world/level/block/entity/BlockEntity;)Lcom/jozufozu/flywheel/backend/instancing/AbstractInstance;"}, at={@At(value="HEAD")}, cancellable=true)
    void preCreateRaw(BlockEntity blockEntity, CallbackInfoReturnable<Instance> cir) {
        ClientLevel level;
        ClientShip ship;
        Level nullableLevel = blockEntity.m_58904_();
        if (nullableLevel instanceof ClientLevel && (ship = VSGameUtilsKt.getShipObjectManagingPos(level = (ClientLevel)nullableLevel, (Vec3i)blockEntity.m_58899_())) != null) {
            MaterialManager manager = this.shipMaterialManagers.computeIfAbsent(ship, k -> this.createMaterialManager());
            Vector3i c = ship.getChunkClaim().getCenterBlockCoordinates(new LevelYRange(0, 0), new Vector3i());
            ((InstancingEngineAccessor)manager).setOriginCoordinate(new BlockPos(c.x, c.y, c.z));
            cir.setReturnValue((Object)InstancedRenderRegistry.createInstance((MaterialManager)manager, (BlockEntity)blockEntity));
        }
    }

    @Unique
    private MaterialManager createMaterialManager() {
        if (Backend.getBackendType() == BackendType.INSTANCING) {
            return InstancingEngine.builder((ProgramCompiler)Contexts.WORLD).build();
        }
        if (Backend.getBackendType() == BackendType.BATCHING) {
            return new BatchingEngine();
        }
        throw new IllegalArgumentException("Unknown engine type");
    }
}

