/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.shipyard_entities;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.entity.handling.VSEntityManager;
import org.valkyrienskies.mod.common.entity.handling.WorldEntityHandler;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={Entity.class})
public abstract class MixinEntity {
    @Unique
    private boolean isModifyingSetPos = false;
    @Unique
    private boolean isModifyingTeleport = false;
    @Shadow
    public Level f_19853_;

    @Shadow
    public abstract Level m_9236_();

    @Shadow
    public abstract void m_20343_(double var1, double var3, double var5);

    @Shadow
    public abstract void m_7332_(Entity var1);

    @Shadow
    public abstract void m_6021_(double var1, double var3, double var5);

    @Shadow
    public abstract boolean m_264318_(ServerLevel var1, double var2, double var4, double var6, Set<RelativeMovement> var8, float var9, float var10);

    @Shadow
    public abstract EntityType<?> m_6095_();

    @WrapOperation(method={"positionRider(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V")})
    private void positionRider(Entity instance, Entity passengerI, Entity.MoveFunction callback, Operation<Void> positionRider) {
        positionRider.call(new Object[]{instance, passengerI, (passenger, x, y, z) -> VSEntityManager.INSTANCE.getHandler(passenger).positionSetFromVehicle(passenger, (Entity)Entity.class.cast(this), x, y, z)});
    }

    @Inject(method={"setPosRaw"}, at={@At(value="HEAD")}, cancellable=true)
    private void handlePosSet(double x, double y, double z, CallbackInfo ci) {
        Level level = this.m_9236_();
        if (!Player.class.isInstance(this) || level == null || this.isModifyingSetPos || !VSGameUtilsKt.isBlockInShipyard(level, x, y, z)) {
            return;
        }
        Ship ship = VSGameUtilsKt.getShipManagingPos(level, x, y, z);
        if (ship != null) {
            this.isModifyingSetPos = true;
            WorldEntityHandler.INSTANCE.moveEntityFromShipyardToWorld((Entity)Entity.class.cast(this), ship, x, y, z);
            this.isModifyingSetPos = false;
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"teleportTo(DDD)V"}, cancellable=true)
    private void beforeTeleportTo(double d, double e, double f, CallbackInfo ci) {
        if (this.isModifyingTeleport) {
            return;
        }
        ci.cancel();
        this.isModifyingTeleport = true;
        Vector3d pos = VSEntityManager.INSTANCE.getHandler((Entity)Entity.class.cast(this)).getTeleportPos((Entity)Entity.class.cast(this), new Vector3d(d, e, f));
        this.m_6021_(pos.x, pos.y, pos.z);
        this.isModifyingTeleport = false;
    }

    @Inject(at={@At(value="HEAD")}, method={"teleportTo(Lnet/minecraft/server/level/ServerLevel;DDDLjava/util/Set;FF)Z"}, cancellable=true)
    private void beforeTeleportTo(ServerLevel serverLevel, double d, double e, double f, Set<RelativeMovement> set, float g, float h, CallbackInfoReturnable<Boolean> ci) {
        if (this.isModifyingTeleport) {
            return;
        }
        ci.cancel();
        this.isModifyingTeleport = true;
        Vector3d pos = VSEntityManager.INSTANCE.getHandler((Entity)Entity.class.cast(this)).getTeleportPos((Entity)Entity.class.cast(this), new Vector3d(d, e, f));
        this.m_264318_(serverLevel, pos.x, pos.y, pos.z, set, g, h);
        this.isModifyingTeleport = false;
    }

    @ModifyExpressionValue(method={"saveWithoutId"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/Entity;vehicle:Lnet/minecraft/world/entity/Entity;")})
    private Entity preventSavingVehiclePosAsOurPos(Entity originalVehicle) {
        int vehicleChunkZ;
        if (originalVehicle == null) {
            return null;
        }
        int vehicleChunkX = (int)originalVehicle.m_20182_().m_7096_() >> 4;
        boolean isVehicleInShipyard = VSGameUtilsKt.isChunkInShipyard(this.f_19853_, vehicleChunkX, vehicleChunkZ = (int)originalVehicle.m_20182_().m_7094_() >> 4);
        if (isVehicleInShipyard) {
            return null;
        }
        return originalVehicle;
    }

    @Inject(method={"setRemoved"}, at={@At(value="HEAD")})
    private void preSetRemoved(Entity.RemovalReason removalReason, CallbackInfo ci) {
        Entity thisAsEntity = (Entity)Entity.class.cast(this);
        LoadedShip ship = VSGameUtilsKt.getShipObjectManagingPos(thisAsEntity.m_9236_(), (Vector3dc)VectorConversionsMCKt.toJOML(thisAsEntity.m_20182_()));
        if (ship != null) {
            VSEntityManager.INSTANCE.getHandler(thisAsEntity).entityRemovedFromShipyard(thisAsEntity, (Ship)ship);
        }
    }

    @Shadow
    protected abstract void m_19956_(Entity var1, Entity.MoveFunction var2);
}

