/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.seamless_copy;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.assembly.SeamlessChunksManager;
import org.valkyrienskies.mod.mixin.accessors.network.protocol.game.ClientboundSectionBlocksUpdatePacketAccessor;
import org.valkyrienskies.mod.mixinducks.feature.seamless_copy.SeamlessCopyClientPacketListenerDuck;

@Mixin(value={ClientPacketListener.class})
public class MixinClientPacketListener
implements SeamlessCopyClientPacketListenerDuck {
    @Shadow
    private ClientLevel f_104889_;
    @Unique
    private final SeamlessChunksManager chunks = new SeamlessChunksManager((ClientPacketListener)ClientPacketListener.class.cast(this));

    @Inject(at={@At(value="HEAD")}, method={"close"})
    private void beforeClose(CallbackInfo ci) {
        this.chunks.cleanup();
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)}, method={"handleLevelChunkWithLight"}, cancellable=true)
    private void beforeHandleLevelChunk(ClientboundLevelChunkWithLightPacket packet, CallbackInfo ci) {
        if (this.chunks.queue(packet.m_195717_(), packet.m_195718_(), (Packet<?>)packet, this.f_104889_)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)}, method={"handleChunkBlocksUpdate"}, cancellable=true)
    private void beforeHandleChunkBlocksUpdate(ClientboundSectionBlocksUpdatePacket packet, CallbackInfo ci) {
        SectionPos pos = ((ClientboundSectionBlocksUpdatePacketAccessor)packet).getSectionPos();
        if (this.chunks.queue(pos.m_123170_(), pos.m_123222_(), (Packet<?>)packet, this.f_104889_)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/util/thread/BlockableEventLoop;)V", shift=At.Shift.AFTER)}, method={"handleBlockUpdate"}, cancellable=true)
    private void beforeHandleBlockUpdate(ClientboundBlockUpdatePacket packet, CallbackInfo ci) {
        if (this.chunks.queue(packet.m_131749_().m_123341_() >> 4, packet.m_131749_().m_123343_() >> 4, (Packet<?>)packet, this.f_104889_)) {
            ci.cancel();
        }
    }

    @Override
    @NotNull
    public SeamlessChunksManager vs_getChunks() {
        return this.chunks;
    }
}

