/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.entity;

import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClient;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IEntityDraggingInformationProvider {
    @Unique
    private final EntityDraggingInformation draggingInformation = new EntityDraggingInformation();
    @Shadow
    private Vec3 f_19825_;
    @Shadow
    public Level f_19853_;
    @Shadow
    @Nullable
    private Entity f_19824_;

    @Redirect(method={"pick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;clip(Lnet/minecraft/world/level/ClipContext;)Lnet/minecraft/world/phys/BlockHitResult;"))
    public BlockHitResult addShipsToRaycast(Level receiver, ClipContext ctx) {
        return RaycastUtilsKt.clipIncludeShips(receiver, ctx);
    }

    @Inject(at={@At(value="TAIL")}, method={"checkInsideBlocks"})
    private void afterCheckInside(CallbackInfo ci) {
        AABBd boundingBox = VectorConversionsMCKt.toJOML(this.m_20191_());
        AABBd temp = new AABBd();
        for (Ship ship : VSGameUtilsKt.getShipsIntersecting(this.f_19853_, (AABBdc)boundingBox)) {
            AABBd inShipBB = boundingBox.transform(ship.getShipTransform().getWorldToShipMatrix(), temp);
            this.originalCheckInside(inShipBB);
        }
    }

    @Unique
    private void originalCheckInside(AABBd aABB) {
        Entity self = (Entity)Entity.class.cast(this);
        BlockPos blockPos = BlockPos.m_274561_((double)(aABB.minX + 0.001), (double)(aABB.minY + 0.001), (double)(aABB.minZ + 0.001));
        BlockPos blockPos2 = BlockPos.m_274561_((double)(aABB.maxX - 0.001), (double)(aABB.maxY - 0.001), (double)(aABB.maxZ - 0.001));
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        if (this.f_19853_.m_46832_(blockPos, blockPos2)) {
            for (int i = blockPos.m_123341_(); i <= blockPos2.m_123341_(); ++i) {
                for (int j = blockPos.m_123342_(); j <= blockPos2.m_123342_(); ++j) {
                    for (int k = blockPos.m_123343_(); k <= blockPos2.m_123343_(); ++k) {
                        mutableBlockPos.m_122178_(i, j, k);
                        BlockState blockState = this.f_19853_.m_8055_((BlockPos)mutableBlockPos);
                        try {
                            blockState.m_60682_(this.f_19853_, (BlockPos)mutableBlockPos, self);
                            this.m_6763_(blockState);
                            continue;
                        }
                        catch (Throwable var12) {
                            CrashReport crashReport = CrashReport.m_127521_((Throwable)var12, (String)"Colliding entity with block");
                            CrashReportCategory crashReportCategory = crashReport.m_127514_("Block being collided with");
                            CrashReportCategory.m_178950_((CrashReportCategory)crashReportCategory, (LevelHeightAccessor)this.f_19853_, (BlockPos)mutableBlockPos, (BlockState)blockState);
                            throw new ReportedException(crashReport);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetEyePosition(float partialTicks, CallbackInfoReturnable<Vec3> cir) {
        LoadedShip shipMountedTo = VSGameUtilsKt.getShipObjectEntityMountedTo(this.f_19853_, (Entity)Entity.class.cast(this));
        if (shipMountedTo == null) {
            return;
        }
        ShipTransform shipTransform = shipMountedTo instanceof ShipObjectClient ? ((ShipObjectClient)shipMountedTo).getRenderTransform() : shipMountedTo.getShipTransform();
        Vector3d basePos = shipTransform.getShipToWorldMatrix().transformPosition(VSGameUtilsKt.getPassengerPos(this.f_19824_, this.m_6049_(), partialTicks), new Vector3d());
        Vector3d eyeRelativePos = shipTransform.getShipCoordinatesToWorldCoordinatesRotation().transform(new Vector3d(0.0, (double)this.m_20192_(), 0.0));
        Vec3 newEyePos = VectorConversionsMCKt.toMinecraft((Vector3dc)basePos.add((Vector3dc)eyeRelativePos, new Vector3d()));
        cir.setReturnValue((Object)newEyePos);
    }

    @Inject(method={"calculateViewVector"}, at={@At(value="HEAD")}, cancellable=true)
    private void preCalculateViewVector(float xRot, float yRot, CallbackInfoReturnable<Vec3> cir) {
        LoadedShip shipMountedTo = VSGameUtilsKt.getShipObjectEntityMountedTo(this.f_19853_, (Entity)Entity.class.cast(this));
        if (shipMountedTo == null) {
            return;
        }
        float f = xRot * ((float)Math.PI / 180);
        float g = -yRot * ((float)Math.PI / 180);
        float h = Mth.m_14089_((float)g);
        float i = Mth.m_14031_((float)g);
        float j = Mth.m_14089_((float)f);
        float k = Mth.m_14031_((float)f);
        Vector3d originalViewVector = new Vector3d((double)(i * j), (double)(-k), (double)(h * j));
        ShipTransform shipTransform = shipMountedTo instanceof ClientShip ? ((ClientShip)shipMountedTo).getRenderTransform() : shipMountedTo.getShipTransform();
        Vec3 newViewVector = VectorConversionsMCKt.toMinecraft((Vector3dc)shipTransform.getShipCoordinatesToWorldCoordinatesRotation().transform((Vector3dc)originalViewVector, new Vector3d()));
        cir.setReturnValue((Object)newViewVector);
    }

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    protected abstract void m_19956_(Entity var1, Entity.MoveFunction var2);

    @Shadow
    protected abstract void m_6763_(BlockState var1);

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract float m_20192_();

    @Shadow
    public abstract EntityType<?> m_6095_();

    @Shadow
    public abstract double m_6049_();

    @Override
    @NotNull
    public EntityDraggingInformation getDraggingInformation() {
        return this.draggingInformation;
    }
}

