/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.client.world;

import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.compat.SodiumCompat;
import org.valkyrienskies.mod.compat.VSRenderer;
import org.valkyrienskies.mod.mixin.ValkyrienCommonMixinConfigPlugin;
import org.valkyrienskies.mod.mixin.accessors.client.multiplayer.ClientLevelAccessor;
import org.valkyrienskies.mod.mixin.accessors.client.render.LevelRendererAccessor;
import org.valkyrienskies.mod.mixin.accessors.client.world.ClientChunkCacheStorageAccessor;
import org.valkyrienskies.mod.mixinducks.client.render.IVSViewAreaMethods;
import org.valkyrienskies.mod.mixinducks.client.world.ClientChunkCacheDuck;

@Mixin(value={ClientChunkCache.class})
public abstract class MixinClientChunkCache
implements ClientChunkCacheDuck {
    @Shadow
    volatile ClientChunkCache.Storage f_104410_;
    @Shadow
    @Final
    ClientLevel f_104411_;
    private final LongObjectMap<LevelChunk> shipChunks = new LongObjectHashMap();

    @Override
    public LongObjectMap<LevelChunk> vs_getShipChunks() {
        return this.shipChunks;
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")}, cancellable=true)
    private void preLoadChunkFromPacket(int x, int z, FriendlyByteBuf buf, CompoundTag tag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer, CallbackInfoReturnable<LevelChunk> cir) {
        ClientChunkCacheStorageAccessor clientChunkMapAccessor = (ClientChunkCacheStorageAccessor)ClientChunkCacheStorageAccessor.class.cast(this.f_104410_);
        if (!clientChunkMapAccessor.callInRange(x, z) && VSGameUtilsKt.isChunkInShipyard((Level)this.f_104411_, x, z)) {
            long chunkPosLong = ChunkPos.m_45589_((int)x, (int)z);
            LevelChunk worldChunk = new LevelChunk((Level)this.f_104411_, new ChunkPos(x, z));
            worldChunk.m_187971_(buf, tag, consumer);
            this.shipChunks.put(chunkPosLong, (Object)worldChunk);
            LevelChunkSection[] chunkSections = worldChunk.m_7103_();
            LevelLightEngine lightingProvider = this.m_7827_();
            lightingProvider.m_9335_(new ChunkPos(x, z), true);
            for (int j = 0; j < chunkSections.length; ++j) {
                LevelChunkSection chunkSection = chunkSections[j];
                lightingProvider.m_6191_(SectionPos.m_123173_((int)x, (int)this.f_104411_.m_151568_(j), (int)z), chunkSection.m_188008_());
            }
            this.f_104411_.m_171649_(new ChunkPos(x, z));
            SodiumCompat.onChunkAdded(x, z);
            cir.setReturnValue((Object)worldChunk);
        }
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")}, cancellable=true)
    public void preUnload(int chunkX, int chunkZ, CallbackInfo ci) {
        this.shipChunks.remove(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
        if (ValkyrienCommonMixinConfigPlugin.getVSRenderer() != VSRenderer.SODIUM) {
            ((IVSViewAreaMethods)((LevelRendererAccessor)((ClientLevelAccessor)this.f_104411_).getLevelRenderer()).getViewArea()).unloadChunk(chunkX, chunkZ);
        }
        SodiumCompat.onChunkRemoved(chunkX, chunkZ);
        ci.cancel();
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/LevelChunk;"}, at={@At(value="HEAD")}, cancellable=true)
    public void preGetChunk(int chunkX, int chunkZ, ChunkStatus chunkStatus, boolean bl, CallbackInfoReturnable<LevelChunk> cir) {
        LevelChunk shipChunk = (LevelChunk)this.shipChunks.get(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
        if (shipChunk != null) {
            cir.setReturnValue((Object)shipChunk);
        }
    }

    @Shadow
    public abstract LevelLightEngine m_7827_();
}

