/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.client.renderer;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.mod.client.IVSCamera;
import org.valkyrienskies.mod.common.IShipObjectWorldClientProvider;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;
import org.valkyrienskies.mod.mixinducks.client.MinecraftDuck;

@Mixin(value={GameRenderer.class})
public abstract class MixinGameRenderer {
    @Shadow
    @Final
    private Minecraft f_109059_;
    @Shadow
    @Final
    private Camera f_109054_;

    @Shadow
    protected abstract double m_109141_(Camera var1, float var2, boolean var3);

    @Shadow
    public abstract Matrix4f m_253088_(double var1);

    @Unique
    private static HitResult entityRaycastNoTransform(Entity entity, double maxDistance, float tickDelta, boolean includeFluids) {
        Vec3 vec3d = entity.m_20299_(tickDelta);
        Vec3 vec3d2 = entity.m_20252_(tickDelta);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * maxDistance, vec3d2.f_82480_ * maxDistance, vec3d2.f_82481_ * maxDistance);
        return RaycastUtilsKt.clipIncludeShips(entity.m_9236_(), new ClipContext(vec3d, vec3d3, ClipContext.Block.OUTLINE, includeFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, entity), false);
    }

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;pick(DFZ)Lnet/minecraft/world/phys/HitResult;")})
    public HitResult modifyCrosshairTargetBlocks(Entity receiver, double maxDistance, float tickDelta, boolean includeFluids, Operation<HitResult> pick) {
        HitResult original = MixinGameRenderer.entityRaycastNoTransform(receiver, maxDistance, tickDelta, includeFluids);
        ((MinecraftDuck)this.f_109059_).vs$setOriginalCrosshairTarget(original);
        return (HitResult)pick.call(new Object[]{receiver, maxDistance, Float.valueOf(tickDelta), includeFluids});
    }

    @WrapOperation(method={"pick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;distanceToSqr(Lnet/minecraft/world/phys/Vec3;)D")})
    public double correctDistanceChecks(Vec3 instance, Vec3 vec, Operation<Vec3> distanceToSqr) {
        return VSGameUtilsKt.squaredDistanceBetweenInclShips((Level)this.f_109059_.f_91073_, vec.f_82479_, vec.f_82480_, vec.f_82481_, instance.f_82479_, instance.f_82480_, instance.f_82481_);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void preRender(float tickDelta, long startTime, boolean tick2, CallbackInfo ci) {
        ClientLevel clientWorld = this.f_109059_.f_91073_;
        if (clientWorld != null) {
            ClientShipWorldCore shipWorld = ((IShipObjectWorldClientProvider)IShipObjectWorldClientProvider.class.cast(this.f_109059_)).getShipObjectWorld();
            if (shipWorld == null) {
                return;
            }
            shipWorld.updateRenderTransforms(tickDelta);
            for (Entity entity : clientWorld.m_104735_()) {
                ClientShip shipObject;
                EntityDraggingInformation entityDraggingInformation;
                Long lastShipStoodOn;
                Vector3d entityShouldBeHere = null;
                ClientShip shipMountedTo = VSGameUtilsKt.getShipObjectEntityMountedTo(clientWorld, entity);
                if (shipMountedTo != null) {
                    Vector3dc passengerPos = VSGameUtilsKt.getPassengerPos(entity.m_20202_(), entity.m_6049_(), tickDelta);
                    entityShouldBeHere = shipMountedTo.getRenderTransform().getShipToWorld().transformPosition(passengerPos, new Vector3d());
                    entity.m_6034_(entityShouldBeHere.x(), entityShouldBeHere.y(), entityShouldBeHere.z());
                    entity.f_19854_ = entityShouldBeHere.x();
                    entity.f_19855_ = entityShouldBeHere.y();
                    entity.f_19856_ = entityShouldBeHere.z();
                    entity.f_19790_ = entityShouldBeHere.x();
                    entity.f_19791_ = entityShouldBeHere.y();
                    entity.f_19792_ = entityShouldBeHere.z();
                    continue;
                }
                if (entityShouldBeHere == null && (lastShipStoodOn = (entityDraggingInformation = ((IEntityDraggingInformationProvider)entity).getDraggingInformation()).getLastShipStoodOn()) != null && entityDraggingInformation.isEntityBeingDraggedByAShip() && (shipObject = (ClientShip)VSGameUtilsKt.getShipObjectWorld(clientWorld).getLoadedShips().getById(lastShipStoodOn.longValue())) != null) {
                    entityDraggingInformation.setCachedLastPosition((Vector3dc)new Vector3d(entity.f_19854_, entity.f_19855_, entity.f_19856_));
                    entityDraggingInformation.setRestoreCachedLastPosition(true);
                    Vector3dc entityAddedVelocity = entityDraggingInformation.getAddedMovementLastTick();
                    double entityMovementX = entity.m_20185_() - entityAddedVelocity.x() - entity.f_19854_;
                    double entityMovementY = entity.m_20186_() - entityAddedVelocity.y() - entity.f_19855_;
                    double entityMovementZ = entity.m_20189_() - entityAddedVelocity.z() - entity.f_19856_;
                    Vector3d entityShouldBeHerePreTransform = new Vector3d(entity.f_19854_ + entityMovementX * (double)tickDelta, entity.f_19855_ + entityMovementY * (double)tickDelta, entity.f_19856_ + entityMovementZ * (double)tickDelta);
                    entityShouldBeHere = shipObject.getRenderTransform().getShipToWorldMatrix().transformPosition(shipObject.getPrevTickShipTransform().getWorldToShipMatrix().transformPosition((Vector3dc)entityShouldBeHerePreTransform, new Vector3d()));
                }
                if (entityShouldBeHere == null || !((double)tickDelta < 0.99999)) continue;
                entity.f_19854_ = (entityShouldBeHere.x() - entity.m_20185_() * (double)tickDelta) / (1.0 - (double)tickDelta);
                entity.f_19855_ = (entityShouldBeHere.y() - entity.m_20186_() * (double)tickDelta) / (1.0 - (double)tickDelta);
                entity.f_19856_ = (entityShouldBeHere.z() - entity.m_20189_() * (double)tickDelta) / (1.0 - (double)tickDelta);
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void postRender(float tickDelta, long startTime, boolean tick2, CallbackInfo ci) {
        ClientLevel clientWorld = this.f_109059_.f_91073_;
        if (clientWorld != null) {
            for (Entity entity : clientWorld.m_104735_()) {
                EntityDraggingInformation vsEntity = ((IEntityDraggingInformationProvider)entity).getDraggingInformation();
                if (!vsEntity.getRestoreCachedLastPosition()) continue;
                vsEntity.setRestoreCachedLastPosition(false);
                Vector3dc cachedLastPosition = vsEntity.getCachedLastPosition();
                if (cachedLastPosition != null) {
                    entity.f_19854_ = cachedLastPosition.x();
                    entity.f_19855_ = cachedLastPosition.y();
                    entity.f_19856_ = cachedLastPosition.z();
                    continue;
                }
                System.err.println("How was cachedLastPosition was null?");
            }
        }
    }

    @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;prepareCullFrustum(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/phys/Vec3;Lorg/joml/Matrix4f;)V")})
    private void setupCameraWithMountedShip(LevelRenderer instance, PoseStack ignore, Vec3 vec3, Matrix4f matrix4f, Operation<Void> prepareCullFrustum, float partialTicks, long finishTimeNano, PoseStack matrixStack) {
        ClientLevel clientLevel = this.f_109059_.f_91073_;
        LocalPlayer player = this.f_109059_.f_91074_;
        if (clientLevel == null || player == null) {
            prepareCullFrustum.call(new Object[]{instance, matrixStack, vec3, matrix4f});
            return;
        }
        ClientShip playerShipMountedTo = VSGameUtilsKt.getShipObjectEntityMountedTo(clientLevel, (Entity)player);
        if (playerShipMountedTo == null) {
            prepareCullFrustum.call(new Object[]{instance, matrixStack, vec3, matrix4f});
            return;
        }
        Entity playerVehicle = player.m_20202_();
        if (playerVehicle == null) {
            prepareCullFrustum.call(new Object[]{instance, matrixStack, vec3, matrix4f});
            return;
        }
        Vector3dc inShipPos = VSGameUtilsKt.getPassengerPos(playerVehicle, player.m_6049_(), partialTicks);
        Camera camera = this.f_109054_;
        if (camera == null) {
            prepareCullFrustum.call(new Object[]{instance, matrixStack, vec3, matrix4f});
            return;
        }
        ((IVSCamera)camera).setupWithShipMounted((BlockGetter)this.f_109059_.f_91073_, (Entity)(this.f_109059_.m_91288_() == null ? this.f_109059_.f_91074_ : this.f_109059_.m_91288_()), !this.f_109059_.f_91066_.m_92176_().m_90612_(), this.f_109059_.f_91066_.m_92176_().m_90613_(), partialTicks, playerShipMountedTo, inShipPos);
        Quaterniond invShipRenderRotation = playerShipMountedTo.getRenderTransform().getShipToWorldRotation().conjugate(new Quaterniond());
        matrixStack.m_252781_(new Quaternionf().set((Quaterniondc)invShipRenderRotation));
        Matrix3f matrix3f = new Matrix3f((Matrix3fc)matrixStack.m_85850_().m_252943_());
        matrix3f.invert();
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)matrix3f);
        double fov = this.m_109141_(camera, partialTicks, true);
        prepareCullFrustum.call(new Object[]{instance, matrixStack, camera.m_90583_(), this.m_253088_(Math.max(fov, (double)((Integer)this.f_109059_.f_91066_.m_231837_().m_231551_()).intValue()))});
    }
}

