/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.forge.mixin.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mixin(value={FireBlock.class})
public abstract class FireMixin {
    @Unique
    private boolean isModifyingFireTick = false;
    @Shadow
    @Final
    public static IntegerProperty f_53408_;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void fireTickMixin(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (this.isModifyingFireTick) {
            return;
        }
        this.isModifyingFireTick = true;
        double origX = pos.m_123341_();
        double origY = pos.m_123342_();
        double origZ = pos.m_123343_();
        VSGameUtilsKt.transformToNearbyShipsAndWorld((Level)level, origX, origY, origZ, 3.0, (x, y, z) -> {
            BlockPos newPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            if (level.m_46801_(newPos)) {
                level.m_7471_(pos, false);
            }
            int i = (Integer)state.m_61143_((Property)f_53408_);
            boolean bl2 = level.m_46758_(newPos);
            int k = bl2 ? -50 : 0;
            this.tryCatchFire((Level)level, pos.m_122029_(), 300 + k, random, i, Direction.WEST);
            this.tryCatchFire((Level)level, pos.m_122024_(), 300 + k, random, i, Direction.EAST);
            this.tryCatchFire((Level)level, pos.m_7495_(), 250 + k, random, i, Direction.UP);
            this.tryCatchFire((Level)level, pos.m_7494_(), 250 + k, random, i, Direction.DOWN);
            this.tryCatchFire((Level)level, pos.m_122012_(), 300 + k, random, i, Direction.SOUTH);
            this.tryCatchFire((Level)level, pos.m_122019_(), 300 + k, random, i, Direction.NORTH);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int l = -1; l <= 1; ++l) {
                for (int m = -1; m <= 1; ++m) {
                    for (int n = -1; n <= 4; ++n) {
                        if (l == 0 && n == 0 && m == 0) continue;
                        int o = 100;
                        if (n > 1) {
                            o += (n - 1) * 100;
                        }
                        mutableBlockPos.m_122154_((Vec3i)newPos, l, n, m);
                        int p = this.m_221156_((LevelReader)level, (BlockPos)mutableBlockPos);
                        if (p <= 0) continue;
                        int q = (p + 40 + level.m_46791_().m_19028_() * 7) / (i + 30);
                        if (bl2) {
                            q /= 2;
                        }
                        if (q <= 0 || random.m_188503_(o) > q || level.m_46471_() && this.m_53428_((Level)level, (BlockPos)mutableBlockPos)) continue;
                        int r = Math.min(15, i + random.m_188503_(5) / 4);
                        level.m_7731_((BlockPos)mutableBlockPos, this.m_53437_((LevelAccessor)level, (BlockPos)mutableBlockPos, r), 3);
                    }
                }
            }
        });
        this.isModifyingFireTick = false;
    }

    @Inject(method={"onPlace"}, at={@At(value="HEAD")})
    public void onPlaceMixin(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving, CallbackInfo ci) {
        double origX = pos.m_123341_();
        double origY = pos.m_123342_();
        double origZ = pos.m_123343_();
        VSGameUtilsKt.transformToNearbyShipsAndWorld(level, origX, origY, origZ, 1.0, (x, y, z) -> {
            BlockPos newPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            if (level.m_46801_(newPos)) {
                level.m_7471_(pos, false);
            }
        });
    }

    @Shadow
    private void tryCatchFire(Level arg, BlockPos arg2, int k, RandomSource random, int l, Direction face) {
    }

    @Shadow
    protected abstract BlockState m_53437_(LevelAccessor var1, BlockPos var2, int var3);

    @Shadow
    protected abstract boolean m_53428_(Level var1, BlockPos var2);

    @Shadow
    protected abstract int m_221156_(LevelReader var1, BlockPos var2);
}

