/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.world;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.util.McMathUtilKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a]\u0010\u000b\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00042\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00028\u00000\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a+\u0010\u000b\u001a\u00020\u000e*\u00020\r2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u000f\u001a7\u0010\u0016\u001a\u00020\u000e*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00112\u0010\b\u0002\u0010\u0015\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\u0014H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001aI\u0010#\u001a\u0004\u0018\u00010\"*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b#\u0010$\u001a\u0019\u0010&\u001a\u00020\u000e*\u00020%2\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b&\u0010'\"\u001c\u0010*\u001a\n )*\u0004\u0018\u00010(0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006,"}, d2={"T", "Lnet/minecraft/world/phys/Vec3;", "realStart", "realEnd", "Lnet/minecraft/world/level/ClipContext;", "raycastContext", "Ljava/util/function/BiFunction;", "Lnet/minecraft/core/BlockPos;", "context", "Ljava/util/function/Function;", "blockRaycaster", "clip", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/ClipContext;Ljava/util/function/BiFunction;Ljava/util/function/Function;)Ljava/lang/Object;", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/world/phys/BlockHitResult;", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ClipContext;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/BlockHitResult;", "ctx", "", "shouldTransformHitPos", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "skipShip", "clipIncludeShips", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/ClipContext;ZLjava/lang/Long;)Lnet/minecraft/world/phys/BlockHitResult;", "Lnet/minecraft/world/entity/Entity;", "shooter", "origStartVecM", "origEndVecM", "Lnet/minecraft/world/phys/AABB;", "origBoundingBoxM", "Ljava/util/function/Predicate;", "filter", "", "maxDistance2", "Lnet/minecraft/world/phys/EntityHitResult;", "raytraceEntities", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;", "Lnet/minecraft/world/level/BlockGetter;", "vanillaClip", "(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/level/ClipContext;)Lnet/minecraft/world/phys/BlockHitResult;", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "valkyrienskies-1201"})
public final class RaycastUtilsKt {
    private static final Logger logger = LogManager.getLogger((String)"RaycastUtilsKt");

    @JvmOverloads
    @NotNull
    public static final BlockHitResult clipIncludeShips(@NotNull Level $this$clipIncludeShips, @NotNull ClipContext ctx, boolean shouldTransformHitPos, @Nullable Long skipShip) {
        Intrinsics.checkNotNullParameter((Object)$this$clipIncludeShips, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BlockHitResult vanillaHit = RaycastUtilsKt.vanillaClip((BlockGetter)$this$clipIncludeShips, ctx);
        if (VSGameUtilsKt.getShipObjectWorld($this$clipIncludeShips) == null) {
            logger.error("shipObjectWorld was empty for level raytrace, this should not be possible! Returning vanilla result.");
            return vanillaHit;
        }
        BlockHitResult closestHit = vanillaHit;
        Vec3 closestHitPos = vanillaHit.f_82445_;
        double closestHitDist = closestHitPos.m_82557_(ctx.m_45702_());
        Vec3 vec3 = ctx.m_45702_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ctx.from");
        Vector3dc vector3dc = (Vector3dc)VectorConversionsMCKt.toJOML(vec3);
        Vec3 vec32 = ctx.m_45693_();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ctx.to");
        AABBd aABBd = new AABBd(vector3dc, (Vector3dc)VectorConversionsMCKt.toJOML(vec32)).correctBounds();
        Intrinsics.checkNotNullExpressionValue((Object)aABBd, (String)"AABBd(ctx.from.toJOML(),\u2026toJOML()).correctBounds()");
        AABBdc clipAABB = (AABBdc)aABBd;
        for (LoadedShip ship : VSGameUtilsKt.getShipObjectWorld($this$clipIncludeShips).getLoadedShips().getIntersecting(clipAABB)) {
            ClientShip clientShip;
            ClientShip worldToShip;
            Long l = skipShip;
            if (l != null && ship.getId() == l.longValue()) continue;
            ClientShip clientShip2 = ship instanceof ClientShip ? (ClientShip)ship : null;
            if (clientShip2 == null || (clientShip2 = clientShip2.getRenderTransform()) == null || (clientShip2 = clientShip2.getWorldToShipMatrix()) == null) {
                clientShip2 = worldToShip = ship.getWorldToShip();
            }
            if ((clientShip = ship instanceof ClientShip ? (ClientShip)ship : null) == null || (clientShip = clientShip.getRenderTransform()) == null || (clientShip = clientShip.getShipToWorldMatrix()) == null) {
                clientShip = ship.getShipToWorld();
            }
            ClientShip shipToWorld = clientShip;
            Vec3 vec33 = ctx.m_45702_();
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"ctx.from");
            Vector3d vector3d = worldToShip.transformPosition(VectorConversionsMCKt.toJOML(vec33));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"worldToShip.transformPosition(ctx.from.toJOML())");
            Vec3 shipStart = VectorConversionsMCKt.toMinecraft((Vector3dc)vector3d);
            Vec3 vec34 = ctx.m_45693_();
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"ctx.to");
            Vector3d vector3d2 = worldToShip.transformPosition(VectorConversionsMCKt.toJOML(vec34));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"worldToShip.transformPosition(ctx.to.toJOML())");
            Vec3 shipEnd = VectorConversionsMCKt.toMinecraft((Vector3dc)vector3d2);
            BlockHitResult shipHit = RaycastUtilsKt.clip($this$clipIncludeShips, ctx, shipStart, shipEnd);
            Vec3 vec35 = shipHit.f_82445_;
            Intrinsics.checkNotNullExpressionValue((Object)vec35, (String)"shipHit.location");
            Vector3d vector3d3 = shipToWorld.transformPosition(VectorConversionsMCKt.toJOML(vec35));
            Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"shipToWorld.transformPos\u2026hipHit.location.toJOML())");
            Vec3 shipHitPos = VectorConversionsMCKt.toMinecraft((Vector3dc)vector3d3);
            double shipHitDist = shipHitPos.m_82557_(ctx.m_45702_());
            if (!(shipHitDist < closestHitDist) || shipHit.m_6662_() == HitResult.Type.MISS) continue;
            closestHit = shipHit;
            closestHitPos = shipHitPos;
            closestHitDist = shipHitDist;
        }
        if (shouldTransformHitPos) {
            closestHit.f_82445_ = closestHitPos;
        }
        return closestHit;
    }

    public static /* synthetic */ BlockHitResult clipIncludeShips$default(Level level, ClipContext clipContext, boolean bl, Long l, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            l = null;
        }
        return RaycastUtilsKt.clipIncludeShips(level, clipContext, bl, l);
    }

    private static final BlockHitResult clip(Level $this$clip, ClipContext context, Vec3 realStart, Vec3 realEnd) {
        BlockHitResult blockHitResult = RaycastUtilsKt.clip(realStart, realEnd, context, (arg_0, arg_1) -> RaycastUtilsKt.clip$lambda-0($this$clip, realStart, realEnd, arg_0, arg_1), arg_0 -> RaycastUtilsKt.clip$lambda-1(realStart, realEnd, arg_0));
        Intrinsics.checkNotNull((Object)blockHitResult, (String)"null cannot be cast to non-null type net.minecraft.world.phys.BlockHitResult");
        return blockHitResult;
    }

    private static final <T> T clip(Vec3 realStart, Vec3 realEnd, ClipContext raycastContext, BiFunction<ClipContext, BlockPos, T> context, Function<ClipContext, T> blockRaycaster) {
        T t;
        Vec3 vec3d = realStart;
        Vec3 vec3d2 = realEnd;
        if (Intrinsics.areEqual((Object)vec3d, (Object)vec3d2)) {
            t = blockRaycaster.apply(raycastContext);
        } else {
            int l;
            int k;
            double d = Mth.m_14139_((double)-1.0E-7, (double)vec3d2.f_82479_, (double)vec3d.f_82479_);
            double e = Mth.m_14139_((double)-1.0E-7, (double)vec3d2.f_82480_, (double)vec3d.f_82480_);
            double f = Mth.m_14139_((double)-1.0E-7, (double)vec3d2.f_82481_, (double)vec3d.f_82481_);
            double g = Mth.m_14139_((double)-1.0E-7, (double)vec3d.f_82479_, (double)vec3d2.f_82479_);
            double h = Mth.m_14139_((double)-1.0E-7, (double)vec3d.f_82480_, (double)vec3d2.f_82480_);
            double i = Mth.m_14139_((double)-1.0E-7, (double)vec3d.f_82481_, (double)vec3d2.f_82481_);
            int j = Mth.m_14107_((double)g);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(j, k = Mth.m_14107_((double)h), l = Mth.m_14107_((double)i));
            T object = context.apply(raycastContext, (BlockPos)mutable);
            if (object != null) {
                t = object;
            } else {
                double m = d - g;
                double n = e - h;
                double o = f - i;
                int p = Mth.m_14205_((double)m);
                int q = Mth.m_14205_((double)n);
                int r = Mth.m_14205_((double)o);
                double s = p == 0 ? Double.MAX_VALUE : (double)p / m;
                double t2 = q == 0 ? Double.MAX_VALUE : (double)q / n;
                double u = r == 0 ? Double.MAX_VALUE : (double)r / o;
                double v = s * (p > 0 ? 1.0 - Mth.m_14185_((double)g) : Mth.m_14185_((double)g));
                double w = t2 * (q > 0 ? 1.0 - Mth.m_14185_((double)h) : Mth.m_14185_((double)h));
                double x = u * (r > 0 ? 1.0 - Mth.m_14185_((double)i) : Mth.m_14185_((double)i));
                Object object2 = null;
                do {
                    if (v > 1.0 && w > 1.0 && x > 1.0) {
                        return blockRaycaster.apply(raycastContext);
                    }
                    if (v < w) {
                        if (v < x) {
                            j += p;
                            v += s;
                            continue;
                        }
                        l += r;
                        x += u;
                        continue;
                    }
                    if (w < x) {
                        k += q;
                        w += t2;
                        continue;
                    }
                    l += r;
                    x += u;
                } while ((object2 = context.apply(raycastContext, (BlockPos)mutable.m_122178_(j, k, l))) == null);
                t = object2;
            }
        }
        return t;
    }

    @Nullable
    public static final EntityHitResult raytraceEntities(@NotNull Level $this$raytraceEntities, @NotNull Entity shooter, @NotNull Vec3 origStartVecM, @NotNull Vec3 origEndVecM, @NotNull AABB origBoundingBoxM, @NotNull Predicate<Entity> filter, double maxDistance2) {
        Ref.ObjectRef location;
        Ref.ObjectRef resultEntity;
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$raytraceEntities, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)shooter, (String)"shooter");
            Intrinsics.checkNotNullParameter((Object)origStartVecM, (String)"origStartVecM");
            Intrinsics.checkNotNullParameter((Object)origEndVecM, (String)"origEndVecM");
            Intrinsics.checkNotNullParameter((Object)origBoundingBoxM, (String)"origBoundingBoxM");
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            Ref.DoubleRef distance2 = new Ref.DoubleRef();
            distance2.element = maxDistance2;
            resultEntity = new Ref.ObjectRef();
            location = new Ref.ObjectRef();
            List entities = $this$raytraceEntities.m_6249_(shooter, origBoundingBoxM, filter);
            Intrinsics.checkNotNullExpressionValue((Object)entities, (String)"entities");
            RaycastUtilsKt.raytraceEntities$checkEntities(distance2, (Ref.ObjectRef<Entity>)resultEntity, (Ref.ObjectRef<Vec3>)location, shooter, entities, origStartVecM, origEndVecM, 1.0);
            Vector3d origStartVec = VectorConversionsMCKt.toJOML(origStartVecM);
            Vector3d origEndVec = VectorConversionsMCKt.toJOML(origEndVecM);
            Vector3d start = new Vector3d();
            Vector3d end = new Vector3d();
            if (VSGameUtilsKt.getShipObjectWorld($this$raytraceEntities) == null) {
                logger.error("rayTraceEntities shipObjectWorld was null! this should never happen!");
            }
            if ((object = VSGameUtilsKt.getShipObjectWorld($this$raytraceEntities)) == null || (object = object.getLoadedShips()) == null || (object = object.getIntersecting((AABBdc)VectorConversionsMCKt.toJOML(origBoundingBoxM))) == null) break block3;
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                Object element$iv = iterator2.next();
                LoadedShip it = (LoadedShip)element$iv;
                boolean bl2 = false;
                it.getWorldToShip().transformPosition((Vector3dc)origStartVec, start);
                it.getWorldToShip().transformPosition((Vector3dc)origEndVec, end);
                Vector3d scale = it.getShipTransform().getWorldToShipMatrix().getScale(new Vector3d());
                boolean bl3 = scale.x == scale.y && scale.y == scale.z ? true : (bl = false);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                RaycastUtilsKt.raytraceEntities$checkEntities(distance2, (Ref.ObjectRef<Entity>)resultEntity, (Ref.ObjectRef<Vec3>)location, shooter, entities, VectorConversionsMCKt.toMinecraft((Vector3dc)start), VectorConversionsMCKt.toMinecraft((Vector3dc)end), scale.x);
            }
        }
        return resultEntity.element == null ? (EntityHitResult)null : new EntityHitResult((Entity)resultEntity.element, (Vec3)location.element);
    }

    @NotNull
    public static final BlockHitResult vanillaClip(@NotNull BlockGetter $this$vanillaClip, @NotNull ClipContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$vanillaClip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = BlockGetter.m_151361_((Vec3)context.m_45702_(), (Vec3)context.m_45693_(), (Object)context, (arg_0, arg_1) -> RaycastUtilsKt.vanillaClip$lambda-4($this$vanillaClip, arg_0, arg_1), RaycastUtilsKt::vanillaClip$lambda-5);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"traverseBlocks(context.f\u2026\n            )\n        })");
        return (BlockHitResult)object;
    }

    @JvmOverloads
    @NotNull
    public static final BlockHitResult clipIncludeShips(@NotNull Level $this$clipIncludeShips, @NotNull ClipContext ctx, boolean shouldTransformHitPos) {
        Intrinsics.checkNotNullParameter((Object)$this$clipIncludeShips, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return RaycastUtilsKt.clipIncludeShips$default($this$clipIncludeShips, ctx, shouldTransformHitPos, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public static final BlockHitResult clipIncludeShips(@NotNull Level $this$clipIncludeShips, @NotNull ClipContext ctx) {
        Intrinsics.checkNotNullParameter((Object)$this$clipIncludeShips, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return RaycastUtilsKt.clipIncludeShips$default($this$clipIncludeShips, ctx, false, null, 6, null);
    }

    private static final BlockHitResult clip$lambda-0(Level $this_clip, Vec3 $realStart, Vec3 $realEnd, ClipContext raycastContext, BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)$this_clip, (String)"$this_clip");
        Intrinsics.checkNotNullParameter((Object)$realStart, (String)"$realStart");
        Intrinsics.checkNotNullParameter((Object)$realEnd, (String)"$realEnd");
        Intrinsics.checkNotNullParameter((Object)raycastContext, (String)"raycastContext");
        BlockPos blockPos2 = blockPos;
        Intrinsics.checkNotNull((Object)blockPos2);
        BlockState blockState = $this_clip.m_8055_(blockPos2);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(blockPos!!)");
        BlockState blockState2 = blockState;
        FluidState fluidState = $this_clip.m_6425_(blockPos);
        Intrinsics.checkNotNullExpressionValue((Object)fluidState, (String)"getFluidState(blockPos)");
        FluidState fluidState2 = fluidState;
        Vec3 vec3d = $realStart;
        Vec3 vec3d2 = $realEnd;
        VoxelShape voxelShape = raycastContext.m_45694_(blockState2, (BlockGetter)$this_clip, blockPos);
        BlockHitResult blockHitResult = $this_clip.m_45558_(vec3d, vec3d2, blockPos, voxelShape, blockState2);
        VoxelShape voxelShape2 = raycastContext.m_45698_(fluidState2, (BlockGetter)$this_clip, blockPos);
        BlockHitResult blockHitResult2 = voxelShape2.m_83220_(vec3d, vec3d2, blockPos);
        BlockHitResult blockHitResult3 = blockHitResult;
        double d = blockHitResult3 == null ? Double.MAX_VALUE : $realStart.m_82557_(blockHitResult3.f_82445_);
        BlockHitResult blockHitResult4 = blockHitResult2;
        double e = blockHitResult4 == null ? Double.MAX_VALUE : $realEnd.m_82557_(blockHitResult4.f_82445_);
        return d <= e ? blockHitResult : blockHitResult2;
    }

    private static final BlockHitResult clip$lambda-1(Vec3 $realStart, Vec3 $realEnd, ClipContext raycastContext) {
        Intrinsics.checkNotNullParameter((Object)$realStart, (String)"$realStart");
        Intrinsics.checkNotNullParameter((Object)$realEnd, (String)"$realEnd");
        Intrinsics.checkNotNullParameter((Object)raycastContext, (String)"raycastContext");
        Vec3 vec3d = $realStart.m_82546_($realEnd);
        return BlockHitResult.m_82426_((Vec3)$realEnd, (Direction)Direction.m_122366_((double)vec3d.f_82479_, (double)vec3d.f_82480_, (double)vec3d.f_82481_), (BlockPos)BlockPos.m_274446_((Position)((Position)$realEnd)));
    }

    private static final void raytraceEntities$checkEntities(Ref.DoubleRef distance2, Ref.ObjectRef<Entity> resultEntity, Ref.ObjectRef<Vec3> location, Entity $shooter, List<? extends Entity> entities, Vec3 startVec, Vec3 endVec, double scale) {
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            AABB aABB = entity.m_20191_().m_82400_((double)entity.m_6143_());
            Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"entity.boundingBox.infla\u2026ty.pickRadius.toDouble())");
            AABB aabb = McMathUtilKt.scale(aABB, scale);
            Optional clipO = aabb.m_82371_(startVec, endVec);
            if (aabb.m_82390_(startVec)) {
                if (distance2.element < 0.0) continue;
                resultEntity.element = entity;
                location.element = clipO.orElse(startVec);
                distance2.element = 0.0;
                continue;
            }
            if (!clipO.isPresent()) continue;
            Object t = clipO.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"clipO.get()");
            Vec3 clip = (Vec3)t;
            double d = startVec.m_82557_(clip) / (scale * scale);
            if (d >= distance2.element && !(distance2.element == 0.0)) continue;
            if (entity.m_20201_() == $shooter.m_20201_()) {
                if (!(distance2.element == 0.0)) continue;
                resultEntity.element = entity;
                location.element = clip;
                continue;
            }
            resultEntity.element = entity;
            location.element = clip;
            distance2.element = d;
        }
    }

    private static final BlockHitResult vanillaClip$lambda-4(BlockGetter $this_vanillaClip, ClipContext clipContext, BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)$this_vanillaClip, (String)"$this_vanillaClip");
        Intrinsics.checkNotNullParameter((Object)clipContext, (String)"clipContext");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        BlockState blockState = $this_vanillaClip.m_8055_(blockPos);
        FluidState fluidState = $this_vanillaClip.m_6425_(blockPos);
        Vec3 vec3 = clipContext.m_45702_();
        Vec3 vec32 = clipContext.m_45693_();
        VoxelShape voxelShape = clipContext.m_45694_(blockState, $this_vanillaClip, blockPos);
        BlockHitResult blockHitResult = $this_vanillaClip.m_45558_(vec3, vec32, blockPos, voxelShape, blockState);
        VoxelShape voxelShape2 = clipContext.m_45698_(fluidState, $this_vanillaClip, blockPos);
        BlockHitResult blockHitResult2 = voxelShape2.m_83220_(vec3, vec32, blockPos);
        double d = blockHitResult == null ? Double.MAX_VALUE : clipContext.m_45702_().m_82557_(blockHitResult.f_82445_);
        double e = blockHitResult2 == null ? Double.MAX_VALUE : clipContext.m_45702_().m_82557_(blockHitResult2.f_82445_);
        return d <= e ? blockHitResult : blockHitResult2;
    }

    private static final BlockHitResult vanillaClip$lambda-5(ClipContext ctx) {
        Vec3 vec3 = ctx.m_45702_().m_82546_(ctx.m_45693_());
        return BlockHitResult.m_82426_((Vec3)ctx.m_45693_(), (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)BlockPos.m_274446_((Position)((Position)ctx.m_45693_())));
    }
}

