/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import java.lang.ref.WeakReference;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010%\u001a\u00020\u0017\u00a2\u0006\u0004\b&\u0010'J\u001a\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0015\u001a\u00060\u0011j\u0002`\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010!\u001a\u00020 8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006("}, d2={"Lorg/valkyrienskies/mod/common/util/MinecraftPlayer;", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lorg/joml/Vector3d;", "dest", "getPosition", "(Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "", "hashCode", "()I", "getCanModifyServerConfig", "()Z", "canModifyServerConfig", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "getDimension", "()Ljava/lang/String;", "dimension", "isAdmin", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "player", "Ljava/lang/ref/WeakReference;", "playerEntityReference", "Ljava/lang/ref/WeakReference;", "getPlayerEntityReference", "()Ljava/lang/ref/WeakReference;", "Ljava/util/UUID;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "playerObject", "<init>", "(Lnet/minecraft/world/entity/player/Player;)V", "valkyrienskies-1201"})
public final class MinecraftPlayer
implements IPlayer {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final WeakReference<Player> playerEntityReference;

    public MinecraftPlayer(@NotNull Player playerObject) {
        Intrinsics.checkNotNullParameter((Object)playerObject, (String)"playerObject");
        UUID uUID = playerObject.m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"playerObject.uuid");
        this.uuid = uUID;
        this.playerEntityReference = new WeakReference<Player>(playerObject);
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final WeakReference<Player> getPlayerEntityReference() {
        return this.playerEntityReference;
    }

    @NotNull
    public final Player getPlayer() {
        Object t = this.playerEntityReference.get();
        Intrinsics.checkNotNull(t);
        return (Player)t;
    }

    @Override
    public boolean isAdmin() {
        return this.getPlayer().m_20310_(4);
    }

    @Override
    public boolean getCanModifyServerConfig() {
        return VSGameUtilsKt.getVsCore().getHooks().isPhysicalClient() || this.getPlayer().m_20310_(4);
    }

    @Override
    @NotNull
    public String getDimension() {
        Level level = this.getPlayer().m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"player.level()");
        return VSGameUtilsKt.getDimensionId(level);
    }

    @Override
    @NotNull
    public Vector3d getPosition(@NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Vector3d vector3d = dest.set(this.getPlayer().m_20185_(), this.getPlayer().m_20186_(), this.getPlayer().m_20189_());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"dest.set(player.x, player.y, player.z)");
        return vector3d;
    }

    public int hashCode() {
        return this.getUuid().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof MinecraftPlayer) {
            return Intrinsics.areEqual((Object)this.getUuid(), (Object)((MinecraftPlayer)other).getUuid());
        }
        return false;
    }
}

