/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.collision.ConvexPolygonc;
import org.valkyrienskies.core.impl.collision.EntityPolygonCollider;
import org.valkyrienskies.core.impl.util.AABBdUtilKt;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ/\u0010\n\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/valkyrienskies/mod/common/util/EntityShipCollisionUtils;", "", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/world/phys/Vec3;", "movement", "Lnet/minecraft/world/phys/AABB;", "entityBoundingBox", "Lnet/minecraft/world/level/Level;", "world", "adjustEntityMovementForShipCollisions", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/phys/Vec3;", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "Lorg/joml/primitives/AABBdc;", "aABB", "level", "", "areAllChunksLoaded", "(Lorg/valkyrienskies/core/api/ships/Ship;Lorg/joml/primitives/AABBdc;Lnet/minecraft/world/level/Level;)Z", "", "Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;", "getShipPolygonsCollidingWithEntity", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;)Ljava/util/List;", "isCollidingWithUnloadedShips", "(Lnet/minecraft/world/entity/Entity;)Z", "<init>", "()V", "valkyrienskies-1201"})
public final class EntityShipCollisionUtils {
    @NotNull
    public static final EntityShipCollisionUtils INSTANCE = new EntityShipCollisionUtils();

    private EntityShipCollisionUtils() {
    }

    @JvmStatic
    public static final boolean isCollidingWithUnloadedShips(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel || level.f_46443_ && level instanceof ClientLevel) {
            boolean bl;
            block5: {
                if (level.f_46443_ && level instanceof ClientLevel && !VSGameUtilsKt.getShipObjectWorld((ClientLevel)level).isSyncedWithServer()) {
                    return true;
                }
                AABB aABB = entity.m_20191_();
                Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"entity.boundingBox");
                AABBd aabb = VectorConversionsMCKt.toJOML(aABB);
                Iterable<Ship> $this$all$iv = VSGameUtilsKt.getShipsIntersecting(level, (AABBdc)aabb);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator<Ship> iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        Ship element$iv;
                        Ship ship = element$iv = iterator2.next();
                        boolean bl2 = false;
                        AABBd aabbInShip = new AABBd((AABBdc)aabb).transform(ship.getWorldToShip());
                        Intrinsics.checkNotNullExpressionValue((Object)aabbInShip, (String)"aabbInShip");
                        if (INSTANCE.areAllChunksLoaded(ship, (AABBdc)aabbInShip, level)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return !bl;
        }
        return false;
    }

    private final boolean areAllChunksLoaded(Ship ship, AABBdc aABB, Level level) {
        int minX = Mth.m_14107_((double)(aABB.minX() - 1.0E-7)) - 1 >> 4;
        int maxX = Mth.m_14107_((double)(aABB.maxX() + 1.0E-7)) + 1 >> 4;
        int minZ = Mth.m_14107_((double)(aABB.minZ() - 1.0E-7)) - 1 >> 4;
        int maxZ = Mth.m_14107_((double)(aABB.maxZ() + 1.0E-7)) + 1 >> 4;
        int chunkX = minX;
        if (chunkX <= maxX) {
            while (true) {
                int chunkZ;
                if ((chunkZ = minZ) <= maxZ) {
                    while (true) {
                        if (ship.getActiveChunksSet().contains(chunkX, chunkZ) && level.m_7925_(chunkX, chunkZ) == null) {
                            return false;
                        }
                        if (chunkZ == maxZ) break;
                        ++chunkZ;
                    }
                }
                if (chunkX == maxX) break;
                ++chunkX;
            }
        }
        return true;
    }

    @NotNull
    public final Vec3 adjustEntityMovementForShipCollisions(@Nullable Entity entity, @NotNull Vec3 movement, @NotNull AABB entityBoundingBox, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)movement, (String)"movement");
        Intrinsics.checkNotNullParameter((Object)entityBoundingBox, (String)"entityBoundingBox");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        double inflation = entity instanceof Player ? 0.5 : 0.1;
        Entity entity2 = entity;
        double stepHeight = entity2 != null ? (double)entity2.m_274421_() : 0.0;
        Vec3 vec3 = new Vec3(movement.m_7096_(), movement.m_7098_() + Math.max(stepHeight - inflation, 0.0), movement.m_7094_());
        AABB aABB = entityBoundingBox.m_82400_(inflation);
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"entityBoundingBox.inflate(inflation)");
        List<ConvexPolygonc> collidingShipPolygons = this.getShipPolygonsCollidingWithEntity(entity, vec3, aABB, world);
        if (collidingShipPolygons.isEmpty()) {
            return movement;
        }
        Pair<Vector3dc, Long> pair = EntityPolygonCollider.INSTANCE.adjustEntityMovementForPolygonCollisions((Vector3dc)VectorConversionsMCKt.toJOML(movement), (AABBdc)VectorConversionsMCKt.toJOML(entityBoundingBox), stepHeight, collidingShipPolygons);
        Vector3dc newMovement = (Vector3dc)pair.component1();
        Long shipCollidingWith = (Long)pair.component2();
        if (entity != null && shipCollidingWith != null) {
            ((IEntityDraggingInformationProvider)entity).getDraggingInformation().setLastShipStoodOn(shipCollidingWith);
        }
        return VectorConversionsMCKt.toMinecraft(newMovement);
    }

    private final List<ConvexPolygonc> getShipPolygonsCollidingWithEntity(Entity entity, Vec3 movement, AABB entityBoundingBox, Level world) {
        AABB entityBoxWithMovement = entityBoundingBox.m_82369_(movement);
        List collidingPolygons = new ArrayList();
        AABBd entityBoundingBoxExtended = AABBdUtilKt.extend(VectorConversionsMCKt.toJOML(entityBoundingBox), (Vector3dc)VectorConversionsMCKt.toJOML(movement));
        for (LoadedShip shipObject : VSGameUtilsKt.getShipObjectWorld(world).getLoadedShips().getIntersecting((AABBdc)entityBoundingBoxExtended)) {
            ShipTransform shipTransform = shipObject.getTransform();
            Intrinsics.checkNotNullExpressionValue((Object)entityBoxWithMovement, (String)"entityBoxWithMovement");
            ConvexPolygonc entityPolyInShipCoordinates = EntityPolygonCollider.createPolygonFromAABB$default(EntityPolygonCollider.INSTANCE, (AABBdc)VectorConversionsMCKt.toJOML(entityBoxWithMovement), shipTransform.getWorldToShip(), null, 4, null);
            AABBdc entityBoundingBoxInShipCoordinates = (AABBdc)entityPolyInShipCoordinates.getEnclosingAABB(new AABBd());
            Iterable shipBlockCollisionStream = world.m_186434_(entity, VectorConversionsMCKt.toMinecraft(entityBoundingBoxInShipCoordinates));
            Intrinsics.checkNotNullExpressionValue((Object)shipBlockCollisionStream, (String)"shipBlockCollisionStream");
            Iterable $this$forEach$iv = shipBlockCollisionStream;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VoxelShape voxelShape = (VoxelShape)element$iv;
                boolean bl = false;
                voxelShape.m_83286_((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> EntityShipCollisionUtils.getShipPolygonsCollidingWithEntity$lambda-2$lambda-1(shipTransform, shipObject, collidingPolygons, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
            }
        }
        return collidingPolygons;
    }

    private static final void getShipPolygonsCollidingWithEntity$lambda-2$lambda-1(ShipTransform $shipTransform, LoadedShip $shipObject, List $collidingPolygons, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Intrinsics.checkNotNullParameter((Object)$shipTransform, (String)"$shipTransform");
        Intrinsics.checkNotNullParameter((Object)$shipObject, (String)"$shipObject");
        Intrinsics.checkNotNullParameter((Object)$collidingPolygons, (String)"$collidingPolygons");
        ConvexPolygonc shipPolygon = EntityPolygonCollider.INSTANCE.createPolygonFromAABB((AABBdc)new AABBd(minX, minY, minZ, maxX, maxY, maxZ), $shipTransform.getShipToWorld(), $shipObject.getId());
        $collidingPolygons.add(shipPolygon);
    }
}

