/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/valkyrienskies/mod/common/util/EntityDragger;", "", "", "Lnet/minecraft/world/entity/Entity;", "entities", "", "dragEntitiesWithShips", "(Ljava/lang/Iterable;)V", "", "addedMovementDecay", "D", "<init>", "()V", "valkyrienskies-1201"})
public final class EntityDragger {
    @NotNull
    public static final EntityDragger INSTANCE = new EntityDragger();
    private static final double addedMovementDecay = 0.9;

    private EntityDragger() {
    }

    public final void dragEntitiesWithShips(@NotNull Iterable<? extends Entity> entities) {
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        Iterable<? extends Entity> $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        Iterator<? extends Entity> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            double d;
            Entity element$iv;
            Entity entity = element$iv = iterator2.next();
            boolean bl = false;
            Level level = entity.m_9236_();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"entity.level()");
            LoadedShip shipMountedTo = VSGameUtilsKt.getShipObjectEntityMountedTo(level, entity);
            if (shipMountedTo != null) continue;
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider");
            EntityDraggingInformation entityDraggingInformation = ((IEntityDraggingInformationProvider)entity).getDraggingInformation();
            boolean dragTheEntity = false;
            Vector3dc addedMovement = null;
            double addedYRot = 0.0;
            Long shipDraggingEntity = entityDraggingInformation.getLastShipStoodOn();
            if (shipDraggingEntity != null) {
                if (entityDraggingInformation.isEntityBeingDraggedByAShip()) {
                    Ship shipData = VSGameUtilsKt.getShipObjectWorld(entity.m_9236_()).getQueryableShipData().getById(shipDraggingEntity.longValue());
                    if (shipData != null) {
                        double newYRotAsDegrees;
                        double addedYRotFromDragging;
                        dragTheEntity = true;
                        Vector3d newPosIdeal = shipData.getShipToWorld().transformPosition(shipData.getPrevTickTransform().getWorldToShip().transformPosition(new Vector3d(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())));
                        addedMovement = (Vector3dc)new Vector3d(newPosIdeal.x - entity.m_20185_(), newPosIdeal.y - entity.m_20186_(), newPosIdeal.z - entity.m_20189_());
                        double yViewRot = entity.m_5675_(1.0f);
                        Vector3d entityLookYawOnly = new Vector3d(Math.sin(-Math.toRadians(yViewRot)), 0.0, Math.cos(-Math.toRadians(yViewRot)));
                        Vector3d newLookIdeal = shipData.getShipToWorld().transformDirection(shipData.getPrevTickTransform().getWorldToShip().transformDirection(entityLookYawOnly));
                        double newXRot = Math.asin(-newLookIdeal.y());
                        double xRotCos = Math.cos(newXRot);
                        double newYRot = -Math.atan2(newLookIdeal.x() / xRotCos, newLookIdeal.z() / xRotCos);
                        double entityYRotCorrected = (double)entity.m_146908_() % 360.0;
                        if (entityYRotCorrected < -180.0) {
                            entityYRotCorrected += 360.0;
                        }
                        if (entityYRotCorrected > 180.0) {
                            entityYRotCorrected -= 360.0;
                        }
                        if ((addedYRotFromDragging = (newYRotAsDegrees = Math.toDegrees(newYRot)) - entityYRotCorrected) < -180.0) {
                            addedYRotFromDragging += 360.0;
                        }
                        if (addedYRotFromDragging > 180.0) {
                            addedYRotFromDragging -= 360.0;
                        }
                        addedYRot = addedYRotFromDragging;
                    }
                } else {
                    dragTheEntity = true;
                    addedMovement = (Vector3dc)entityDraggingInformation.getAddedMovementLastTick().mul(0.9, new Vector3d());
                    addedYRot = entityDraggingInformation.getAddedYawRotLastTick() * 0.9;
                }
            }
            if (dragTheEntity && addedMovement != null && addedMovement.isFinite() && !Double.isInfinite(d = addedYRot) && !Double.isNaN(d)) {
                AABB newBB = entity.m_20191_().m_82383_(VectorConversionsMCKt.toMinecraft(addedMovement));
                entity.m_20011_(newBB);
                entity.m_6034_(entity.m_20185_() + addedMovement.x(), entity.m_20186_() + addedMovement.y(), entity.m_20189_() + addedMovement.z());
                entityDraggingInformation.setAddedMovementLastTick(addedMovement);
                double d2 = addedYRot;
                if (!Double.isInfinite(d2) && !Double.isNaN(d2) && !(entity instanceof ServerPlayer)) {
                    entity.m_146922_(entity.m_146908_() + (float)addedYRot);
                    entity.m_5616_(entity.m_6080_() + (float)addedYRot);
                    entityDraggingInformation.setAddedYawRotLastTick(addedYRot);
                }
            }
            int n = entityDraggingInformation.getTicksSinceStoodOnShip();
            entityDraggingInformation.setTicksSinceStoodOnShip(n + 1);
        }
    }
}

