/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.entity;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.impl.networking.simple.SimplePackets;
import org.valkyrienskies.mod.api.SeatedControllingPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSKeyBindings;
import org.valkyrienskies.mod.common.networking.PacketPlayerDriving;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001d\u0012\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0006J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\bJ\u000f\u0010\u0016\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0016\u0010\bR\"\u0010\u0018\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0018\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lorg/valkyrienskies/mod/common/entity/ShipMountingEntity;", "Lnet/minecraft/world/entity/Entity;", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "", "addAdditionalSaveData", "(Lnet/minecraft/nbt/CompoundTag;)V", "defineSynchedData", "()V", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getAddEntityPacket", "()Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/world/entity/LivingEntity;", "getControllingPassenger", "()Lnet/minecraft/world/entity/LivingEntity;", "readAdditionalSaveData", "Lnet/minecraft/world/entity/Entity$RemovalReason;", "removalReason", "remove", "(Lnet/minecraft/world/entity/Entity$RemovalReason;)V", "sendDrivingPacket", "tick", "", "isController", "Z", "()Z", "setController", "(Z)V", "Lnet/minecraft/world/entity/EntityType;", "type", "Lnet/minecraft/world/level/Level;", "level", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "valkyrienskies-1201"})
public class ShipMountingEntity
extends Entity {
    private boolean isController;

    public ShipMountingEntity(@NotNull EntityType<ShipMountingEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.f_19850_ = false;
        this.f_19794_ = true;
    }

    public final boolean isController() {
        return this.isController;
    }

    public final void setController(boolean bl) {
        this.isController = bl;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_20197_().isEmpty()) {
            this.m_6074_();
            return;
        }
        Level level = this.m_9236_();
        BlockPos blockPos = this.m_20183_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition()");
        if (VSGameUtilsKt.getShipObjectManagingPos(level, (Vec3i)blockPos) != null) {
            this.sendDrivingPacket();
        }
    }

    protected void m_7378_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
    }

    protected void m_7380_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
    }

    protected void m_8097_() {
    }

    /*
     * WARNING - void declaration
     */
    public void m_142687_(@NotNull Entity.RemovalReason removalReason) {
        Intrinsics.checkNotNullParameter((Object)removalReason, (String)"removalReason");
        if (this.isController && !this.m_9236_().f_46443_) {
            Level level = this.m_9236_();
            BlockPos blockPos = this.m_20183_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition()");
            LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getShipObjectManagingPos(level, (Vec3i)blockPos);
            if (loadedServerShip != null) {
                void $this$setAttachment$iv;
                LoadedServerShip loadedServerShip2 = loadedServerShip;
                Object value$iv = null;
                boolean $i$f$setAttachment = false;
                $this$setAttachment$iv.setAttachment(SeatedControllingPlayer.class, value$iv);
            }
        }
        super.m_142687_(removalReason);
    }

    private final void sendDrivingPacket() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        Options opts = Minecraft.m_91087_().f_91066_;
        boolean forward = opts.f_92085_.m_90857_();
        boolean backward = opts.f_92087_.m_90857_();
        boolean left = opts.f_92086_.m_90857_();
        boolean right = opts.f_92088_.m_90857_();
        boolean up = opts.f_92089_.m_90857_();
        LivingEntity livingEntity = this.m_6688_();
        boolean sprint = livingEntity != null ? livingEntity.m_20142_() : false;
        boolean down = VSKeyBindings.INSTANCE.getShipDown().get().m_90857_();
        boolean cruise = VSKeyBindings.INSTANCE.getShipCruise().get().m_90857_();
        Vector3f impulse = new Vector3f();
        float f = forward == backward ? 0.0f : (impulse.z = forward ? 1.0f : -1.0f);
        float f2 = left == right ? 0.0f : (impulse.x = left ? 1.0f : -1.0f);
        impulse.y = up == down ? 0.0f : (up ? 1.0f : -1.0f);
        SimplePackets.sendToServer(new PacketPlayerDriving(impulse, sprint, cruise));
    }

    @Nullable
    public LivingEntity m_6688_() {
        Object object;
        if (this.isController) {
            List list = this.m_20197_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"this.passengers");
            Object object2 = CollectionsKt.getOrNull((List)list, (int)0);
            object = object2 instanceof LivingEntity ? (LivingEntity)object2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return (Packet)new ClientboundAddEntityPacket((Entity)this);
    }
}

