/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.util.assertions.stages.constraints;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.impl.util.assertions.stages.constraints.StageConstraint;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u0015\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/valkyrienskies/core/impl/util/assertions/stages/constraints/RequireOrder;", "S", "Lorg/valkyrienskies/core/impl/util/assertions/stages/constraints/StageConstraint;", "", "stagesSinceReset", "", "isReset", "", "check", "(Ljava/util/List;Z)Ljava/lang/String;", "stages", "Ljava/util/List;", "<init>", "(Ljava/util/List;)V", "impl"})
public final class RequireOrder<S>
implements StageConstraint<S> {
    @NotNull
    private final List<S> stages;

    public RequireOrder(@NotNull List<? extends S> stages) {
        Intrinsics.checkNotNullParameter(stages, (String)"stages");
        this.stages = stages;
        if (!(!((Collection)this.stages).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @Nullable
    public String check(@NotNull List<? extends S> stagesSinceReset, boolean isReset) {
        Intrinsics.checkNotNullParameter(stagesSinceReset, (String)"stagesSinceReset");
        int requiredIndex = 0;
        for (S stage2 : stagesSinceReset) {
            if (!this.stages.contains(stage2) || Intrinsics.areEqual(stage2, this.stages.get(requiredIndex)) || requiredIndex + 1 >= this.stages.size() || Intrinsics.areEqual(stage2, this.stages.get(++requiredIndex))) continue;
            return "Required stages in the following order: " + this.stages;
        }
        return null;
    }
}

