/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.pipelines;

import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.apigame.world.VSPipeline;
import org.valkyrienskies.core.impl.config.VSCoreConfig;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.core.impl.hooks.CoreHooksImpl;
import org.valkyrienskies.core.impl.pipelines.VSGameFrame;
import org.valkyrienskies.core.impl.pipelines.VSGamePipelineStage;
import org.valkyrienskies.core.impl.pipelines.VSNetworkPipelineStage;
import org.valkyrienskies.core.impl.pipelines.VSPhysicsFrame;
import org.valkyrienskies.core.impl.pipelines.VSPhysicsPipelineBackgroundTask;
import org.valkyrienskies.core.impl.pipelines.VSPhysicsPipelineStage;
import org.valkyrienskies.core.impl.util.WorldScoped;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010,\u001a\u00020+\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\u0006\u0010&\u001a\u00020%\u0012\u0006\u0010 \u001a\u00020\u001f\u0012\u0006\u00104\u001a\u000203\u00a2\u0006\u0004\b5\u00106J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001d\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR*\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00108\u0016@VX\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\u00108\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0015R\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020+8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R$\u00101\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00108\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b1\u0010\u0013\u001a\u0004\b2\u0010\u0015\u00a8\u00067"}, d2={"Lorg/valkyrienskies/core/impl/pipelines/VSPipelineImpl;", "Lorg/valkyrienskies/core/apigame/world/VSPipeline;", "", "computePhysTps", "()D", "Lorg/joml/Vector3dc;", "getPhysicsGravity", "()Lorg/joml/Vector3dc;", "", "postTickGame", "()V", "preTickGame", "gravity", "timeStep", "tickPhysics", "(Lorg/joml/Vector3dc;D)V", "", "value", "arePhysicsRunning", "Z", "getArePhysicsRunning", "()Z", "setArePhysicsRunning", "(Z)V", "deleteResources", "getDeleteResources", "setDeleteResources", "Lorg/valkyrienskies/core/impl/pipelines/VSGamePipelineStage;", "gameStage", "Lorg/valkyrienskies/core/impl/pipelines/VSGamePipelineStage;", "isUsingDummyPhysics", "Lorg/valkyrienskies/core/impl/pipelines/VSNetworkPipelineStage;", "networkStage", "Lorg/valkyrienskies/core/impl/pipelines/VSNetworkPipelineStage;", "Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsPipelineBackgroundTask;", "physicsPipelineBackgroundTask", "Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsPipelineBackgroundTask;", "Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsPipelineStage;", "physicsStage", "Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsPipelineStage;", "Ljava/lang/Thread;", "physicsThread", "Ljava/lang/Thread;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", "shipWorld", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", "getShipWorld", "()Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", "<set-?>", "synchronizePhysics", "getSynchronizePhysics", "Lorg/valkyrienskies/core/impl/hooks/CoreHooksImpl;", "hooks", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;Lorg/valkyrienskies/core/impl/pipelines/VSGamePipelineStage;Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsPipelineStage;Lorg/valkyrienskies/core/impl/pipelines/VSNetworkPipelineStage;Lorg/valkyrienskies/core/impl/hooks/CoreHooksImpl;)V", "impl"})
@WorldScoped
public final class VSPipelineImpl
implements VSPipeline {
    @NotNull
    private final ShipObjectServerWorld shipWorld;
    @NotNull
    private final VSGamePipelineStage gameStage;
    @NotNull
    private final VSPhysicsPipelineStage physicsStage;
    @NotNull
    private final VSNetworkPipelineStage networkStage;
    private volatile boolean synchronizePhysics;
    @NotNull
    private final VSPhysicsPipelineBackgroundTask physicsPipelineBackgroundTask;
    private volatile boolean arePhysicsRunning;
    @NotNull
    private final Thread physicsThread;
    private boolean deleteResources;

    @Inject
    public VSPipelineImpl(@NotNull ShipObjectServerWorld shipWorld, @NotNull VSGamePipelineStage gameStage, @NotNull VSPhysicsPipelineStage physicsStage, @NotNull VSNetworkPipelineStage networkStage, @NotNull CoreHooksImpl hooks) {
        Intrinsics.checkNotNullParameter((Object)shipWorld, (String)"shipWorld");
        Intrinsics.checkNotNullParameter((Object)gameStage, (String)"gameStage");
        Intrinsics.checkNotNullParameter((Object)physicsStage, (String)"physicsStage");
        Intrinsics.checkNotNullParameter((Object)networkStage, (String)"networkStage");
        Intrinsics.checkNotNullParameter((Object)hooks, (String)"hooks");
        this.shipWorld = shipWorld;
        this.gameStage = gameStage;
        this.physicsStage = physicsStage;
        this.networkStage = networkStage;
        this.synchronizePhysics = VSCoreConfig.SERVER.getPt().getSynchronizePhysics();
        this.physicsPipelineBackgroundTask = new VSPhysicsPipelineBackgroundTask(this, 0, 2, null);
        this.arePhysicsRunning = !hooks.isPhysicalClient();
        this.physicsThread = ThreadsKt.thread$default((boolean)true, (boolean)false, null, (String)"Physics thread", (int)8, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ VSPipelineImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                VSPipelineImpl.access$getPhysicsPipelineBackgroundTask$p(this.this$0).run();
            }
        }), (int)6, null);
    }

    @Override
    @NotNull
    public ShipObjectServerWorld getShipWorld() {
        return this.shipWorld;
    }

    public final boolean getSynchronizePhysics() {
        return this.synchronizePhysics;
    }

    @Override
    public boolean getArePhysicsRunning() {
        return this.arePhysicsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArePhysicsRunning(boolean value) {
        this.arePhysicsRunning = value;
        if (value) {
            Lock lock = this.physicsPipelineBackgroundTask.getPauseLock();
            lock.lock();
            try {
                boolean bl = false;
                this.physicsPipelineBackgroundTask.getShouldUnpausePhysicsTick().signal();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public boolean getDeleteResources() {
        return this.deleteResources;
    }

    @Override
    public void setDeleteResources(boolean bl) {
        this.deleteResources = bl;
    }

    @Override
    public boolean isUsingDummyPhysics() {
        return this.physicsStage.isUsingDummy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preTickGame() {
        boolean prevSynchronizePhysics = this.synchronizePhysics;
        this.synchronizePhysics = VSCoreConfig.SERVER.getPt().getSynchronizePhysics();
        if (prevSynchronizePhysics) {
            Lock lock = this.physicsPipelineBackgroundTask.getSyncLock();
            lock.lock();
            try {
                boolean bl = false;
                this.physicsPipelineBackgroundTask.setPhysicsTicksSinceLastGameTick(0);
                this.physicsPipelineBackgroundTask.getShouldRunPhysicsTick().signal();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
        this.gameStage.preTickGame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postTickGame() {
        if (this.synchronizePhysics) {
            Lock lock = this.physicsPipelineBackgroundTask.getSyncLock();
            lock.lock();
            try {
                boolean bl = false;
                int physicsTicksPerGameTick = VSCoreConfig.SERVER.getPt().getPhysicsTicksPerGameTick();
                while (this.physicsPipelineBackgroundTask.getPhysicsTicksSinceLastGameTick() < physicsTicksPerGameTick) {
                    this.physicsPipelineBackgroundTask.getShouldRunGameTick().await();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
        VSGameFrame gameFrame = this.gameStage.postTickGame();
        this.physicsStage.pushGameFrame(gameFrame);
    }

    public final void tickPhysics(@NotNull Vector3dc gravity, double timeStep) {
        Intrinsics.checkNotNullParameter((Object)gravity, (String)"gravity");
        if (this.getDeleteResources()) {
            this.physicsStage.deleteResources();
            this.physicsPipelineBackgroundTask.tellTaskToKillItself();
            return;
        }
        VSPhysicsFrame physicsFrame = this.physicsStage.tickPhysics(gravity, timeStep, true);
        this.gameStage.pushPhysicsFrame(physicsFrame);
        this.networkStage.pushPhysicsFrame(physicsFrame);
    }

    @NotNull
    public final Vector3dc getPhysicsGravity() {
        return (Vector3dc)new Vector3d(0.0, -10.0, 0.0);
    }

    @Override
    public double computePhysTps() {
        return this.physicsPipelineBackgroundTask.computePhysicsTPS();
    }

    public static final /* synthetic */ VSPhysicsPipelineBackgroundTask access$getPhysicsPipelineBackgroundTask$p(VSPipelineImpl $this) {
        return $this.physicsPipelineBackgroundTask;
    }
}

