/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.pipelines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3ic;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.WingManagerChanges;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.constraints.VSAttachmentConstraint;
import org.valkyrienskies.core.apigame.constraints.VSAttachmentOrientationConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraintAndId;
import org.valkyrienskies.core.apigame.constraints.VSConstraintType;
import org.valkyrienskies.core.apigame.constraints.VSFixedOrientationConstraint;
import org.valkyrienskies.core.apigame.constraints.VSHingeOrientationConstraint;
import org.valkyrienskies.core.apigame.constraints.VSHingeSwingLimitsConstraint;
import org.valkyrienskies.core.apigame.constraints.VSHingeTargetAngleConstraint;
import org.valkyrienskies.core.apigame.constraints.VSPosDampingConstraint;
import org.valkyrienskies.core.apigame.constraints.VSRopeConstraint;
import org.valkyrienskies.core.apigame.constraints.VSRotDampingAxes;
import org.valkyrienskies.core.apigame.constraints.VSRotDampingConstraint;
import org.valkyrienskies.core.apigame.constraints.VSSlideConstraint;
import org.valkyrienskies.core.apigame.constraints.VSSphericalSwingLimitsConstraint;
import org.valkyrienskies.core.apigame.constraints.VSSphericalTwistLimitsConstraint;
import org.valkyrienskies.core.impl.api.ShipForcesInducer;
import org.valkyrienskies.core.impl.config.PhysicsConfig;
import org.valkyrienskies.core.impl.config.VSCoreConfig;
import org.valkyrienskies.core.impl.game.ships.PhysInertia;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.core.impl.game.ships.WingManagerImpl;
import org.valkyrienskies.core.impl.game.ships.WingPhysicsSolver;
import org.valkyrienskies.core.impl.pipelines.NewShipInGameFrameData;
import org.valkyrienskies.core.impl.pipelines.ShipInPhysicsFrameData;
import org.valkyrienskies.core.impl.pipelines.UpdateShipInGameFrameData;
import org.valkyrienskies.core.impl.pipelines.VSGameFrame;
import org.valkyrienskies.core.impl.pipelines.VSPhysicsFrame;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;
import org.valkyrienskies.physics_api.PhysicsWorldReference;
import org.valkyrienskies.physics_api.PoseVel;
import org.valkyrienskies.physics_api.RigidBodyInertiaData;
import org.valkyrienskies.physics_api.RigidBodyReference;
import org.valkyrienskies.physics_api.Segment;
import org.valkyrienskies.physics_api.SegmentTracker;
import org.valkyrienskies.physics_api.constraints.AttachmentConstraint;
import org.valkyrienskies.physics_api.constraints.Constraint;
import org.valkyrienskies.physics_api.constraints.ConstraintAndId;
import org.valkyrienskies.physics_api.constraints.FixedAttachmentOrientationConstraint;
import org.valkyrienskies.physics_api.constraints.FixedOrientationConstraint;
import org.valkyrienskies.physics_api.constraints.HingeOrientationConstraint;
import org.valkyrienskies.physics_api.constraints.HingeSwingLimitsConstraint;
import org.valkyrienskies.physics_api.constraints.PosDampingConstraint;
import org.valkyrienskies.physics_api.constraints.RopeConstraint;
import org.valkyrienskies.physics_api.constraints.RotDampingAxes;
import org.valkyrienskies.physics_api.constraints.RotDampingConstraint;
import org.valkyrienskies.physics_api.constraints.SlideConstraint;
import org.valkyrienskies.physics_api.constraints.SphericalSwingLimitsConstraint;
import org.valkyrienskies.physics_api.constraints.SphericalTwistLimitsConstraint;
import org.valkyrienskies.physics_api.dummy_impl.DummyPhysicsWorldReference;
import org.valkyrienskies.physics_api.voxel_updates.IVoxelShapeUpdate;
import org.valkyrienskies.physics_api.voxel_updates.VoxelRigidBodyShapeUpdates;
import org.valkyrienskies.physics_api_krunch.KrunchBootstrap;
import org.valkyrienskies.physics_api_krunch.KrunchPhysicsWorldSettings;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 >2\u00020\u0001:\u0001>B\t\b\u0007\u00a2\u0006\u0004\b=\u0010\u0016J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00060\u0007j\u0002`\n2\n\u0010\t\u001a\u00060\u0007j\u0002`\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0006J%\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0013\u0010\"\u001a\u00020!*\u00020 H\u0002\u00a2\u0006\u0004\b\"\u0010#R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R$\u0010(\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001c8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b(\u0010*R2\u00101\u001a\u001e\u0012\u001a\u0012\u0018\u0012\b\u0012\u00060-j\u0002`.\u0012\n\u0012\b\u0012\u0004\u0012\u0002000/0,0+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00103\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00105\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00104R\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R$\u0010;\u001a\u0012\u0012\b\u0012\u00060-j\u0002`.\u0012\u0004\u0012\u00020:098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<\u00a8\u0006?"}, d2={"Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsPipelineStage;", "", "Lorg/valkyrienskies/core/impl/pipelines/VSGameFrame;", "gameFrame", "", "applyGameFrame", "(Lorg/valkyrienskies/core/impl/pipelines/VSGameFrame;)V", "", "Lorg/valkyrienskies/core/apigame/constraints/VSConstraintId;", "vsConstraintId", "Lorg/valkyrienskies/physics_api/ConstraintId;", "convertVSConstraintIdToConstraintId", "(I)I", "Lorg/valkyrienskies/core/apigame/constraints/VSConstraint;", "vsConstraint", "Lorg/valkyrienskies/physics_api/constraints/Constraint;", "convertVSConstraintToPhysicsConstraint", "(Lorg/valkyrienskies/core/apigame/constraints/VSConstraint;)Lorg/valkyrienskies/physics_api/constraints/Constraint;", "Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsFrame;", "createPhysicsFrame", "()Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsFrame;", "deleteResources", "()V", "pushGameFrame", "Lorg/joml/Vector3dc;", "gravity", "", "timeStep", "", "simulatePhysics", "tickPhysics", "(Lorg/joml/Vector3dc;DZ)Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsFrame;", "Lorg/valkyrienskies/core/impl/config/PhysicsConfig;", "Lorg/valkyrienskies/physics_api_krunch/KrunchPhysicsWorldSettings;", "makeKrunchSettings", "(Lorg/valkyrienskies/core/impl/config/PhysicsConfig;)Lorg/valkyrienskies/physics_api_krunch/KrunchPhysicsWorldSettings;", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "gameFramesQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "<set-?>", "isUsingDummy", "Z", "()Z", "", "Lkotlin/Pair;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "", "Lorg/valkyrienskies/physics_api/voxel_updates/IVoxelShapeUpdate;", "pendingUpdates", "Ljava/util/List;", "pendingUpdatesSize", "I", "physTick", "Lorg/valkyrienskies/physics_api/PhysicsWorldReference;", "physicsEngine", "Lorg/valkyrienskies/physics_api/PhysicsWorldReference;", "", "Lorg/valkyrienskies/core/impl/game/ships/PhysShipImpl;", "shipIdToPhysShip", "Ljava/util/Map;", "<init>", "Companion", "impl"})
public final class VSPhysicsPipelineStage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentLinkedQueue<VSGameFrame> gameFramesQueue = new ConcurrentLinkedQueue();
    @NotNull
    private final PhysicsWorldReference physicsEngine;
    @NotNull
    private final Map<Long, PhysShipImpl> shipIdToPhysShip = new HashMap();
    private int physTick;
    @NotNull
    private List<Pair<Long, List<IVoxelShapeUpdate>>> pendingUpdates = new ArrayList();
    private int pendingUpdatesSize;
    private boolean isUsingDummy;
    private static final int MAX_UPDATES_PER_PHYS_TICK = 1000;
    private static final int MAX_PENDING_UPDATES_SIZE = 60000;
    @NotNull
    private static final Logger logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.pipelines.VSPhysicsPipelineStage$Companion.$$delegatedProperties[0]);

    @Inject
    public VSPhysicsPipelineStage() {
        PhysicsWorldReference physicsWorldReference;
        VSPhysicsPipelineStage vSPhysicsPipelineStage;
        VSPhysicsPipelineStage vSPhysicsPipelineStage2 = this;
        try {
            vSPhysicsPipelineStage = vSPhysicsPipelineStage2;
            PhysicsWorldReference temp = KrunchBootstrap.INSTANCE.createKrunchPhysicsWorld();
            KrunchBootstrap.INSTANCE.setKrunchSettings(temp, this.makeKrunchSettings(VSCoreConfig.SERVER.getPhysics()));
        }
        catch (Exception e) {
            vSPhysicsPipelineStage = vSPhysicsPipelineStage2;
            e.printStackTrace();
            this.isUsingDummy = true;
            physicsWorldReference = new DummyPhysicsWorldReference();
        }
        vSPhysicsPipelineStage.physicsEngine = physicsWorldReference;
    }

    public final boolean isUsingDummy() {
        return this.isUsingDummy;
    }

    public final void pushGameFrame(@NotNull VSGameFrame gameFrame) {
        Intrinsics.checkNotNullParameter((Object)gameFrame, (String)"gameFrame");
        if (this.gameFramesQueue.size() >= 100) {
            VSPhysicsPipelineStage.Companion.getLogger().warn("Too many game frames in the game frame queue. Is the physics stage broken?");
            Thread.sleep(1000L);
        }
        this.gameFramesQueue.add(gameFrame);
    }

    @NotNull
    public final VSPhysicsFrame tickPhysics(@NotNull Vector3dc gravity, double timeStep, boolean simulatePhysics) {
        Intrinsics.checkNotNullParameter((Object)gravity, (String)"gravity");
        while (!((Collection)this.gameFramesQueue).isEmpty()) {
            VSGameFrame gameFrame = (VSGameFrame)this.gameFramesQueue.remove();
            Intrinsics.checkNotNullExpressionValue((Object)gameFrame, (String)"gameFrame");
            this.applyGameFrame(gameFrame);
        }
        Iterable $this$forEach$iv = this.shipIdToPhysShip.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhysShipImpl it = (PhysShipImpl)element$iv;
            boolean bl = false;
            it.setPoseVel(it.getRigidBodyReference().getPoseVel());
        }
        $this$forEach$iv = this.shipIdToPhysShip.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhysShipImpl ship = (PhysShipImpl)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = ship.getForceInducers();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ShipForcesInducer it = (ShipForcesInducer)element$iv2;
                boolean bl2 = false;
                it.applyForces(ship);
                it.applyForcesAndLookupPhysShips(ship, (Function1<? super Long, ? extends PhysShip>)((Function1)new Function1<Long, PhysShip>(this){
                    final /* synthetic */ VSPhysicsPipelineStage this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final PhysShip invoke(long shipId) {
                        return (PhysShip)VSPhysicsPipelineStage.access$getShipIdToPhysShip$p(this.this$0).get(shipId);
                    }
                }));
            }
            ShipTransform shipTransform = ship.getTransform();
            PoseVel poseVel = ship.getPoseVel();
            WingManagerImpl wingManager = ship.getWingManager$impl();
            Matrix3dc momentOfInertia = ship.get_inertia().getMomentOfInertiaTensor();
            Pair<Vector3dc, Vector3dc> pair = WingPhysicsSolver.INSTANCE.applyWingForces(shipTransform, poseVel, wingManager, momentOfInertia);
            Vector3dc force = (Vector3dc)pair.component1();
            Vector3dc torque = (Vector3dc)pair.component2();
            ship.applyInvariantForce(force);
            ship.applyInvariantTorque(torque);
            ship.applyQueuedForces();
        }
        this.physicsEngine.tick(gravity, timeStep, simulatePhysics);
        return this.createPhysicsFrame();
    }

    public final void deleteResources() {
        if (this.physicsEngine.hasBeenDeleted()) {
            throw new IllegalStateException("Physics engine has already been deleted!");
        }
        this.physicsEngine.deletePhysicsWorldResources();
    }

    private final void applyGameFrame(VSGameFrame gameFrame) {
        VoxelRigidBodyShapeUpdates[] thisCollection$iv;
        VoxelRigidBodyShapeUpdates[] $this$toTypedArray$iv;
        int shipTeleportId;
        WingManagerChanges wingManagerChanges;
        boolean shipVoxelsFullyLoaded;
        boolean isStatic;
        PhysShipImpl shipRigidBodyReferenceAndId;
        Object element$iv;
        Object $this$forEach$iv = gameFrame.getDeletedShips();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            long deletedShipId = ((Number)element$iv).longValue();
            boolean bl = false;
            if (this.shipIdToPhysShip.get(deletedShipId) == null) {
                throw new IllegalStateException("Tried deleting rigid body from ship with UUID " + deletedShipId + ", but no rigid body exists for this ship!");
            }
            RigidBodyReference shipRigidBodyReference = shipRigidBodyReferenceAndId.getRigidBodyReference();
            this.physicsEngine.deleteRigidBody(shipRigidBodyReference.getRigidBodyId());
            this.shipIdToPhysShip.remove(deletedShipId);
        }
        $this$forEach$iv = gameFrame.getNewShips();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            NewShipInGameFrameData newShipInGameFrameData = (NewShipInGameFrameData)element$iv;
            boolean bl = false;
            long shipId = newShipInGameFrameData.getUuid();
            if (this.shipIdToPhysShip.containsKey(shipId)) {
                throw new IllegalStateException("Tried creating rigid body from ship with UUID " + shipId + ", but a rigid body already exists for this ship!");
            }
            int dimension = newShipInGameFrameData.getDimension();
            Vector3ic minDefined = newShipInGameFrameData.getMinDefined();
            Vector3ic maxDefined = newShipInGameFrameData.getMaxDefined();
            AABBic totalVoxelRegion = newShipInGameFrameData.getTotalVoxelRegion();
            PhysInertia inertiaData = newShipInGameFrameData.getInertiaData();
            PoseVel poseVel = newShipInGameFrameData.getPoseVel();
            SegmentTracker segments = newShipInGameFrameData.getSegments();
            isStatic = newShipInGameFrameData.isStatic();
            shipVoxelsFullyLoaded = newShipInGameFrameData.getShipVoxelsFullyLoaded();
            wingManagerChanges = newShipInGameFrameData.getWingManagerChanges();
            shipTeleportId = newShipInGameFrameData.getShipTeleportId();
            RigidBodyReference newRigidBodyReference = this.physicsEngine.createVoxelRigidBody(dimension, minDefined, maxDefined, totalVoxelRegion);
            newRigidBodyReference.setInertiaData(VSPhysicsPipelineStage.Companion.physInertiaToRigidBodyInertiaData(inertiaData));
            newRigidBodyReference.setPoseVel(poseVel);
            newRigidBodyReference.setCollisionShapeOffset(newShipInGameFrameData.getVoxelOffset());
            newRigidBodyReference.setStatic(isStatic);
            newRigidBodyReference.setVoxelTerrainFullyLoaded(shipVoxelsFullyLoaded);
            newRigidBodyReference.setSegmentDisplacement(0, ((Segment)CollectionsKt.first((Iterable)segments.getSegments().values())).getSegmentDisplacement());
            PhysShipImpl physShip = new PhysShipImpl(shipId, newRigidBodyReference, newShipInGameFrameData.getForcesInducers(), inertiaData, poseVel, segments, shipTeleportId, null, isStatic, 128, null);
            if (wingManagerChanges != null) {
                physShip.getWingManager$impl().applyChanges(wingManagerChanges);
            }
            Long l = shipId;
            this.shipIdToPhysShip.put(l, physShip);
        }
        $this$forEach$iv = gameFrame.getUpdatedShips();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            PoseVel poseVel;
            boolean updatePoseVelFromGame;
            PhysShipImpl physShip;
            Object newShipInGameFrameData = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            long shipId = ((Number)newShipInGameFrameData.getKey()).longValue();
            UpdateShipInGameFrameData shipUpdate = (UpdateShipInGameFrameData)newShipInGameFrameData.getValue();
            if (this.shipIdToPhysShip.get(shipId) == null) {
                throw new IllegalStateException("Tried updating rigid body from ship with UUID " + shipId + ", but no rigid body exists for this ship!");
            }
            RigidBodyReference shipRigidBody = physShip.getRigidBodyReference();
            PoseVel oldPoseVel = shipRigidBody.getPoseVel();
            Vector3dc oldVoxelOffset = shipRigidBody.getCollisionShapeOffset();
            Vector3dc newVoxelOffset = shipUpdate.getNewVoxelOffset();
            Vector3d deltaVoxelOffset = oldPoseVel.getRot().transform(newVoxelOffset.sub(oldVoxelOffset, new Vector3d()));
            isStatic = shipUpdate.isStatic();
            shipVoxelsFullyLoaded = shipUpdate.getShipVoxelsFullyLoaded();
            wingManagerChanges = shipUpdate.getWingManagerChanges();
            shipTeleportId = shipUpdate.getShipTeleportId();
            Vector3dc currentShipPos = shipUpdate.getCurrentShipPos();
            Quaterniondc currentShipRot = shipUpdate.getCurrentShipRot();
            Vector3dc currentShipVel = shipUpdate.getCurrentShipVel();
            Vector3dc currentShipOmega = shipUpdate.getCurrentShipOmega();
            boolean bl2 = updatePoseVelFromGame = physShip.getLastShipTeleportId$impl() != shipTeleportId;
            if (!updatePoseVelFromGame) {
                Vector3d vector3d = oldPoseVel.getPos().sub((Vector3dc)deltaVoxelOffset, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"oldPoseVel.pos.sub(deltaVoxelOffset, Vector3d())");
                poseVel = new PoseVel((Vector3dc)vector3d, oldPoseVel.getRot(), oldPoseVel.getVel(), oldPoseVel.getOmega());
            } else {
                poseVel = new PoseVel(currentShipPos, currentShipRot, currentShipVel, currentShipOmega);
            }
            PoseVel newShipPoseVel = poseVel;
            physShip.set_inertia(shipUpdate.getInertiaData());
            physShip.setForceInducers(shipUpdate.getForcesInducers());
            physShip.setPoseVel(newShipPoseVel);
            shipRigidBody.setCollisionShapeOffset(newVoxelOffset);
            shipRigidBody.setPoseVel(newShipPoseVel);
            shipRigidBody.setInertiaData(VSPhysicsPipelineStage.Companion.physInertiaToRigidBodyInertiaData(shipUpdate.getInertiaData()));
            shipRigidBody.setStatic(isStatic);
            shipRigidBody.setVoxelTerrainFullyLoaded(shipVoxelsFullyLoaded);
            if (wingManagerChanges != null) {
                physShip.getWingManager$impl().applyChanges(wingManagerChanges);
            }
            physShip.setLastShipTeleportId$impl(shipTeleportId);
            physShip.setStatic(isStatic);
        }
        $this$forEach$iv = gameFrame.getVoxelUpdatesMap();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            PhysShipImpl shipRigidBodyReferenceAndId2;
            Object newShipInGameFrameData = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            long shipId = ((Number)newShipInGameFrameData.getKey()).longValue();
            List voxelUpdatesList = (List)newShipInGameFrameData.getValue();
            if (this.shipIdToPhysShip.get(shipId) == null) {
                throw new IllegalStateException("Tried sending voxel updates to rigid body from ship with UUID " + shipId + ", but no rigid body exists for this ship!");
            }
            RigidBodyReference shipRigidBodyReference = shipRigidBodyReferenceAndId2.getRigidBodyReference();
            if (!shipRigidBodyReference.isStatic()) {
                $this$toTypedArray$iv = (VoxelRigidBodyShapeUpdates[])voxelUpdatesList;
                boolean $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                VoxelRigidBodyShapeUpdates voxelRigidBodyShapeUpdates = new VoxelRigidBodyShapeUpdates(shipRigidBodyReference.getRigidBodyId(), thisCollection$iv.toArray(new IVoxelShapeUpdate[0]));
                $this$toTypedArray$iv = new VoxelRigidBodyShapeUpdates[]{voxelRigidBodyShapeUpdates};
                this.physicsEngine.queueVoxelShapeUpdates($this$toTypedArray$iv);
                continue;
            }
            this.pendingUpdates.add((Pair<Long, List<IVoxelShapeUpdate>>)new Pair((Object)shipId, (Object)voxelUpdatesList));
            this.pendingUpdatesSize += voxelUpdatesList.size();
        }
        $this$forEach$iv = gameFrame.getConstraintsCreatedThisTick();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            VSConstraintAndId vsConstraintAndId = (VSConstraintAndId)element$iv;
            boolean bl = false;
            this.physicsEngine.addConstraint(new ConstraintAndId(vsConstraintAndId.getConstraintId(), this.convertVSConstraintToPhysicsConstraint(vsConstraintAndId.getVsConstraint())));
        }
        $this$forEach$iv = gameFrame.getConstraintsUpdatedThisTick();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            VSConstraintAndId vsConstraintAndId = (VSConstraintAndId)element$iv;
            boolean bl = false;
            this.physicsEngine.updateConstraint(new ConstraintAndId(vsConstraintAndId.getConstraintId(), this.convertVSConstraintToPhysicsConstraint(vsConstraintAndId.getVsConstraint())));
        }
        $this$forEach$iv = gameFrame.getConstraintsDeletedThisTick();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            int vsConstraintId = ((Number)element$iv).intValue();
            boolean bl = false;
            this.physicsEngine.removeConstraint(this.convertVSConstraintIdToConstraintId(vsConstraintId));
        }
        int updatesToSend = Math.max(Math.min(this.pendingUpdatesSize, 1000), this.pendingUpdatesSize - 60000);
        int updatesSent = 0;
        int n = this.pendingUpdates.size();
        for (int i = 0; i < n; ++i) {
            Pair<Long, List<IVoxelShapeUpdate>> curUpdate = this.pendingUpdates.get(i);
            long shipId = ((Number)curUpdate.getFirst()).longValue();
            if (this.shipIdToPhysShip.get(shipId) == null) {
                throw new IllegalStateException("Tried sending voxel updates to rigid body from ship with UUID " + shipId + ", but no rigid body exists for this ship!");
            }
            RigidBodyReference shipRigidBodyReference = shipRigidBodyReferenceAndId.getRigidBodyReference();
            boolean isAllOfISent = false;
            if (((List)curUpdate.getSecond()).size() <= updatesToSend - updatesSent) {
                $this$toTypedArray$iv = (Collection)curUpdate.getSecond();
                boolean $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                VoxelRigidBodyShapeUpdates voxelRigidBodyShapeUpdates = new VoxelRigidBodyShapeUpdates(shipRigidBodyReference.getRigidBodyId(), thisCollection$iv.toArray(new IVoxelShapeUpdate[0]));
                $this$toTypedArray$iv = new VoxelRigidBodyShapeUpdates[]{voxelRigidBodyShapeUpdates};
                this.physicsEngine.queueVoxelShapeUpdates($this$toTypedArray$iv);
                updatesSent += ((List)curUpdate.getSecond()).size();
                isAllOfISent = true;
            } else {
                List toSend = ((List)curUpdate.getSecond()).subList(0, updatesToSend - updatesSent);
                List toKeepForNextPhysTick = ((List)curUpdate.getSecond()).subList(updatesToSend - updatesSent, ((List)curUpdate.getSecond()).size());
                Collection $this$toTypedArray$iv2 = toSend;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                VoxelRigidBodyShapeUpdates voxelRigidBodyShapeUpdates = new VoxelRigidBodyShapeUpdates(shipRigidBodyReference.getRigidBodyId(), thisCollection$iv2.toArray(new IVoxelShapeUpdate[0]));
                VoxelRigidBodyShapeUpdates[] voxelRigidBodyShapeUpdatesArray = new VoxelRigidBodyShapeUpdates[]{voxelRigidBodyShapeUpdates};
                this.physicsEngine.queueVoxelShapeUpdates(voxelRigidBodyShapeUpdatesArray);
                updatesSent += toSend.size();
                this.pendingUpdates.set(i, (Pair<Long, List<IVoxelShapeUpdate>>)new Pair((Object)shipId, toKeepForNextPhysTick));
            }
            if (updatesSent != updatesToSend) continue;
            this.pendingUpdates = isAllOfISent ? (List)new ArrayList(this.pendingUpdates.subList(i + 1, this.pendingUpdates.size())) : (List)new ArrayList(this.pendingUpdates.subList(i, this.pendingUpdates.size()));
            break;
        }
        this.pendingUpdatesSize -= updatesSent;
    }

    private final VSPhysicsFrame createPhysicsFrame() {
        Map shipDataMap = new HashMap();
        Map voxelUpdatesMap = MapsKt.emptyMap();
        Map<Long, PhysShipImpl> $this$forEach$iv = this.shipIdToPhysShip;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, PhysShipImpl>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Long, PhysShipImpl> element$iv;
            Map.Entry<Long, PhysShipImpl> entry = element$iv = iterator2.next();
            boolean bl = false;
            long shipId = ((Number)entry.getKey()).longValue();
            PhysShipImpl shipIdAndRigidBodyReference = entry.getValue();
            RigidBodyReference rigidBodyReference = shipIdAndRigidBodyReference.getRigidBodyReference();
            RigidBodyInertiaData inertiaData = rigidBodyReference.getInertiaData();
            PoseVel poseVel = rigidBodyReference.getPoseVel();
            SegmentTracker segments = rigidBodyReference.getSegmentTracker();
            Vector3dc shipVoxelOffset = rigidBodyReference.getCollisionShapeOffset();
            AABBd aabb = new AABBd();
            rigidBodyReference.getAABB(aabb);
            int lastShipTeleportId = shipIdAndRigidBodyReference.getLastShipTeleportId$impl();
            Long l = shipId;
            shipDataMap.put(l, new ShipInPhysicsFrameData(shipId, inertiaData, poseVel, segments, shipVoxelOffset, (AABBdc)aabb, lastShipTeleportId));
        }
        int n = this.physTick;
        this.physTick = n + 1;
        return new VSPhysicsFrame(shipDataMap, voxelUpdatesMap, n);
    }

    private final KrunchPhysicsWorldSettings makeKrunchSettings(PhysicsConfig $this$makeKrunchSettings) {
        KrunchPhysicsWorldSettings settings = new KrunchPhysicsWorldSettings(0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, null, 0, 0.0, 0.0, 0, 4095, null);
        settings.setSubSteps($this$makeKrunchSettings.getSubSteps());
        settings.setSolverType($this$makeKrunchSettings.getSolver());
        settings.setIterations($this$makeKrunchSettings.getIterations());
        settings.setMaxDePenetrationSpeed($this$makeKrunchSettings.getMaxDePenetrationSpeed());
        settings.setMaxVoxelShapeCollisionPoints($this$makeKrunchSettings.getLodDetail());
        return settings;
    }

    private final Constraint convertVSConstraintToPhysicsConstraint(VSConstraint vsConstraint) {
        Constraint constraint;
        PhysShipImpl physShipImpl = this.shipIdToPhysShip.get(vsConstraint.getShipId0());
        Intrinsics.checkNotNull((Object)physShipImpl);
        int body0Id = physShipImpl.getRigidBodyReference().getRigidBodyId();
        PhysShipImpl physShipImpl2 = this.shipIdToPhysShip.get(vsConstraint.getShipId1());
        Intrinsics.checkNotNull((Object)physShipImpl2);
        int body1Id = physShipImpl2.getRigidBodyReference().getRigidBodyId();
        int segment0Id = 0;
        int segment1Id = 0;
        switch (WhenMappings.$EnumSwitchMapping$1[vsConstraint.getConstraintType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSAttachmentConstraint");
                VSAttachmentConstraint attachmentConstraint = (VSAttachmentConstraint)vsConstraint;
                constraint = new AttachmentConstraint(body0Id, body1Id, segment0Id, segment1Id, attachmentConstraint.getCompliance(), attachmentConstraint.getLocalPos0(), attachmentConstraint.getLocalPos1(), attachmentConstraint.getMaxForce(), attachmentConstraint.getFixedDistance());
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSAttachmentOrientationConstraint");
                VSAttachmentOrientationConstraint fixedAttachmentOrientationConstraint = (VSAttachmentOrientationConstraint)vsConstraint;
                constraint = new FixedAttachmentOrientationConstraint(body0Id, body1Id, segment0Id, segment1Id, fixedAttachmentOrientationConstraint.getCompliance(), fixedAttachmentOrientationConstraint.getLocalRot0(), fixedAttachmentOrientationConstraint.getLocalRot1(), fixedAttachmentOrientationConstraint.getMaxTorque(), fixedAttachmentOrientationConstraint.getLocalPos0(), fixedAttachmentOrientationConstraint.getLocalPos1(), fixedAttachmentOrientationConstraint.getMaxForce());
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSFixedOrientationConstraint");
                VSFixedOrientationConstraint fixedOrientationConstraint = (VSFixedOrientationConstraint)vsConstraint;
                constraint = new FixedOrientationConstraint(body0Id, body1Id, segment0Id, segment1Id, fixedOrientationConstraint.getCompliance(), fixedOrientationConstraint.getLocalRot0(), fixedOrientationConstraint.getLocalRot1(), fixedOrientationConstraint.getMaxTorque());
                break;
            }
            case 4: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSHingeOrientationConstraint");
                VSHingeOrientationConstraint hingeOrientationConstraint = (VSHingeOrientationConstraint)vsConstraint;
                constraint = new HingeOrientationConstraint(body0Id, body1Id, segment0Id, segment1Id, hingeOrientationConstraint.getCompliance(), hingeOrientationConstraint.getLocalRot0(), hingeOrientationConstraint.getLocalRot1(), hingeOrientationConstraint.getMaxTorque());
                break;
            }
            case 5: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSHingeSwingLimitsConstraint");
                VSHingeSwingLimitsConstraint hingeSwingLimitsConstraint = (VSHingeSwingLimitsConstraint)vsConstraint;
                constraint = new HingeSwingLimitsConstraint(body0Id, body1Id, segment0Id, segment1Id, hingeSwingLimitsConstraint.getCompliance(), hingeSwingLimitsConstraint.getLocalRot0(), hingeSwingLimitsConstraint.getLocalRot1(), hingeSwingLimitsConstraint.getMaxTorque(), hingeSwingLimitsConstraint.getMinSwingAngle(), hingeSwingLimitsConstraint.getMaxSwingAngle());
                break;
            }
            case 6: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSHingeTargetAngleConstraint");
                VSHingeTargetAngleConstraint hingeTargetAngleConstraint = (VSHingeTargetAngleConstraint)vsConstraint;
                constraint = new HingeSwingLimitsConstraint(body0Id, body1Id, segment0Id, segment1Id, hingeTargetAngleConstraint.getCompliance(), hingeTargetAngleConstraint.getLocalRot0(), hingeTargetAngleConstraint.getLocalRot1(), hingeTargetAngleConstraint.getMaxTorque(), hingeTargetAngleConstraint.getTargetAngle(), hingeTargetAngleConstraint.getNextTickTargetAngle());
                break;
            }
            case 7: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSPosDampingConstraint");
                VSPosDampingConstraint posDampingConstraint = (VSPosDampingConstraint)vsConstraint;
                constraint = new PosDampingConstraint(body0Id, body1Id, segment0Id, segment1Id, posDampingConstraint.getCompliance(), posDampingConstraint.getLocalPos0(), posDampingConstraint.getLocalPos1(), posDampingConstraint.getMaxForce(), posDampingConstraint.getPosDamping());
                break;
            }
            case 8: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSRopeConstraint");
                VSRopeConstraint ropeConstraint = (VSRopeConstraint)vsConstraint;
                constraint = new RopeConstraint(body0Id, body1Id, segment0Id, segment1Id, ropeConstraint.getCompliance(), ropeConstraint.getLocalPos0(), ropeConstraint.getLocalPos1(), ropeConstraint.getMaxForce(), ropeConstraint.getRopeLength());
                break;
            }
            case 9: {
                RotDampingAxes rotDampingAxes;
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSRotDampingConstraint");
                VSRotDampingConstraint rotDampingConstraint = (VSRotDampingConstraint)vsConstraint;
                switch (WhenMappings.$EnumSwitchMapping$0[rotDampingConstraint.getRotDampingAxes().ordinal()]) {
                    case 1: {
                        rotDampingAxes = RotDampingAxes.PARALLEL;
                        break;
                    }
                    case 2: {
                        rotDampingAxes = RotDampingAxes.PERPENDICULAR;
                        break;
                    }
                    case 3: {
                        rotDampingAxes = RotDampingAxes.ALL_AXES;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                RotDampingAxes rotDampingAxes2 = rotDampingAxes;
                constraint = new RotDampingConstraint(body0Id, body1Id, segment0Id, segment1Id, rotDampingConstraint.getCompliance(), rotDampingConstraint.getLocalRot0(), rotDampingConstraint.getLocalRot1(), rotDampingConstraint.getMaxTorque(), rotDampingConstraint.getRotDamping(), rotDampingAxes2);
                break;
            }
            case 10: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSSlideConstraint");
                VSSlideConstraint slideConstraint = (VSSlideConstraint)vsConstraint;
                constraint = new SlideConstraint(body0Id, body1Id, segment0Id, segment1Id, slideConstraint.getCompliance(), slideConstraint.getLocalPos0(), slideConstraint.getLocalPos1(), slideConstraint.getMaxForce(), slideConstraint.getLocalSlideAxis0(), slideConstraint.getMaxDistBetweenPoints());
                break;
            }
            case 11: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSSphericalSwingLimitsConstraint");
                VSSphericalSwingLimitsConstraint sphericalSwingLimitsConstraint = (VSSphericalSwingLimitsConstraint)vsConstraint;
                constraint = new SphericalSwingLimitsConstraint(body0Id, body1Id, segment0Id, segment1Id, sphericalSwingLimitsConstraint.getCompliance(), sphericalSwingLimitsConstraint.getLocalRot0(), sphericalSwingLimitsConstraint.getLocalRot1(), sphericalSwingLimitsConstraint.getMaxTorque(), sphericalSwingLimitsConstraint.getMinSwingAngle(), sphericalSwingLimitsConstraint.getMaxSwingAngle());
                break;
            }
            case 12: {
                Intrinsics.checkNotNull((Object)vsConstraint, (String)"null cannot be cast to non-null type org.valkyrienskies.core.apigame.constraints.VSSphericalTwistLimitsConstraint");
                VSSphericalTwistLimitsConstraint sphericalTwistLimitsConstraint = (VSSphericalTwistLimitsConstraint)vsConstraint;
                constraint = new SphericalTwistLimitsConstraint(body0Id, body1Id, segment0Id, segment1Id, sphericalTwistLimitsConstraint.getCompliance(), sphericalTwistLimitsConstraint.getLocalRot0(), sphericalTwistLimitsConstraint.getLocalRot1(), sphericalTwistLimitsConstraint.getMaxTorque(), sphericalTwistLimitsConstraint.getMinTwistAngle(), sphericalTwistLimitsConstraint.getMaxTwistAngle());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown constraint type " + (Object)((Object)vsConstraint.getConstraintType()));
            }
        }
        return constraint;
    }

    private final int convertVSConstraintIdToConstraintId(int vsConstraintId) {
        return vsConstraintId;
    }

    public static final /* synthetic */ Map access$getShipIdToPhysShip$p(VSPhysicsPipelineStage $this) {
        return $this.shipIdToPhysShip;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u001b\u0010\u0010\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsPipelineStage$Companion;", "", "Lorg/valkyrienskies/core/impl/game/ships/PhysInertia;", "inertia", "Lorg/valkyrienskies/physics_api/RigidBodyInertiaData;", "physInertiaToRigidBodyInertiaData", "(Lorg/valkyrienskies/core/impl/game/ships/PhysInertia;)Lorg/valkyrienskies/physics_api/RigidBodyInertiaData;", "", "MAX_PENDING_UPDATES_SIZE", "I", "MAX_UPDATES_PER_PHYS_TICK", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V", "impl"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final RigidBodyInertiaData physInertiaToRigidBodyInertiaData(PhysInertia inertia) {
            double invMass = 1.0 / inertia.getShipMass();
            double d = invMass;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                throw new IllegalStateException("invMass is not finite!");
            }
            Matrix3d invInertiaMatrix = inertia.getMomentOfInertiaTensor().invert(new Matrix3d());
            if (!invInertiaMatrix.isFinite()) {
                throw new IllegalStateException("invInertiaMatrix is not finite!");
            }
            Intrinsics.checkNotNullExpressionValue((Object)invInertiaMatrix, (String)"invInertiaMatrix");
            return new RigidBodyInertiaData(invMass, (Matrix3dc)invInertiaMatrix);
        }

        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VSRotDampingAxes.values().length];
            try {
                nArray[VSRotDampingAxes.PARALLEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSRotDampingAxes.PERPENDICULAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSRotDampingAxes.ALL_AXES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VSConstraintType.values().length];
            try {
                nArray[VSConstraintType.ATTACHMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.FIXED_ATTACHMENT_ORIENTATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.FIXED_ORIENTATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.HINGE_ORIENTATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.HINGE_SWING_LIMITS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.HINGE_TARGET_ANGLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.POS_DAMPING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.ROPE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.ROT_DAMPING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.SLIDE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.SPHERICAL_SWING_LIMITS.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VSConstraintType.SPHERICAL_TWIST_LIMITS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

