/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.pipelines;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.impl.config.VSCoreConfig;
import org.valkyrienskies.core.impl.pipelines.VSPipelineImpl;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;
import org.valkyrienskies.core.impl.util.ThreadHints;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 82\u00020\u0001:\u00018B\u0019\u0012\u0006\u00104\u001a\u000203\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b6\u00107J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0010\u0010\u0007J\u000f\u0010\u0011\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0007R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0016\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001b\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0014\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u001f\u0010)\u001a\n (*\u0004\u0018\u00010'0'8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001f\u0010-\u001a\n (*\u0004\u0018\u00010'0'8\u0006\u00a2\u0006\f\n\u0004\b-\u0010*\u001a\u0004\b.\u0010,R\u001f\u0010/\u001a\n (*\u0004\u0018\u00010'0'8\u0006\u00a2\u0006\f\n\u0004\b/\u0010*\u001a\u0004\b0\u0010,R\u0017\u00101\u001a\u00020\u001a8\u0006\u00a2\u0006\f\n\u0004\b1\u0010\u001c\u001a\u0004\b2\u0010\u001eR\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u00069"}, d2={"Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsPipelineBackgroundTask;", "Ljava/lang/Runnable;", "", "computePhysicsTPS", "()D", "", "run", "()V", "", "sleepTimeNanos", "sleepExact", "(J)V", "timeToSimulateNs", "timeToRunPhysTick", "sleepOnLostTime", "(DJ)V", "tellTaskToKillItself", "trackTickEnd", "", "idealPhysicsTps", "I", "", "killTask", "Z", "lostTime", "J", "Ljava/util/concurrent/locks/ReentrantLock;", "pauseLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getPauseLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "physicsTicksSinceLastGameTick", "getPhysicsTicksSinceLastGameTick", "()I", "setPhysicsTicksSinceLastGameTick", "(I)V", "Ljava/util/Queue;", "prevPhysTicksTimeMillis", "Ljava/util/Queue;", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "shouldRunGameTick", "Ljava/util/concurrent/locks/Condition;", "getShouldRunGameTick", "()Ljava/util/concurrent/locks/Condition;", "shouldRunPhysicsTick", "getShouldRunPhysicsTick", "shouldUnpausePhysicsTick", "getShouldUnpausePhysicsTick", "syncLock", "getSyncLock", "Lorg/valkyrienskies/core/impl/pipelines/VSPipelineImpl;", "vsPipeline", "Lorg/valkyrienskies/core/impl/pipelines/VSPipelineImpl;", "<init>", "(Lorg/valkyrienskies/core/impl/pipelines/VSPipelineImpl;I)V", "Companion", "impl"})
public final class VSPhysicsPipelineBackgroundTask
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VSPipelineImpl vsPipeline;
    private int idealPhysicsTps;
    private boolean killTask;
    private long lostTime;
    @NotNull
    private final Queue<Long> prevPhysTicksTimeMillis;
    private volatile int physicsTicksSinceLastGameTick;
    @NotNull
    private final ReentrantLock syncLock;
    private final Condition shouldRunGameTick;
    private final Condition shouldRunPhysicsTick;
    @NotNull
    private final ReentrantLock pauseLock;
    private final Condition shouldUnpausePhysicsTick;
    private static final long MAX_LOST_TIME = 1000000000L;
    private static final int PHYS_TICK_AVERAGE_WINDOW_MS = 5000;
    @NotNull
    private static final Logger logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.pipelines.VSPhysicsPipelineBackgroundTask$Companion.$$delegatedProperties[0]);

    public VSPhysicsPipelineBackgroundTask(@NotNull VSPipelineImpl vsPipeline, int idealPhysicsTps) {
        Intrinsics.checkNotNullParameter((Object)vsPipeline, (String)"vsPipeline");
        this.vsPipeline = vsPipeline;
        this.idealPhysicsTps = idealPhysicsTps;
        this.prevPhysTicksTimeMillis = new LinkedList();
        this.syncLock = new ReentrantLock();
        this.shouldRunGameTick = this.syncLock.newCondition();
        this.shouldRunPhysicsTick = this.syncLock.newCondition();
        this.pauseLock = new ReentrantLock();
        this.shouldUnpausePhysicsTick = this.pauseLock.newCondition();
    }

    public /* synthetic */ VSPhysicsPipelineBackgroundTask(VSPipelineImpl vSPipelineImpl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 60;
        }
        this(vSPipelineImpl, n);
    }

    public final int getPhysicsTicksSinceLastGameTick() {
        return this.physicsTicksSinceLastGameTick;
    }

    public final void setPhysicsTicksSinceLastGameTick(int n) {
        this.physicsTicksSinceLastGameTick = n;
    }

    @NotNull
    public final ReentrantLock getSyncLock() {
        return this.syncLock;
    }

    public final Condition getShouldRunGameTick() {
        return this.shouldRunGameTick;
    }

    public final Condition getShouldRunPhysicsTick() {
        return this.shouldRunPhysicsTick;
    }

    @NotNull
    public final ReentrantLock getPauseLock() {
        return this.pauseLock;
    }

    public final Condition getShouldUnpausePhysicsTick() {
        return this.shouldUnpausePhysicsTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.killTask) {
                if (this.vsPipeline.getSynchronizePhysics()) {
                    int physicsTicksPerGameTick = VSCoreConfig.SERVER.getPt().getPhysicsTicksPerGameTick();
                    double timeStep = 1.0 / (double)(20 * physicsTicksPerGameTick);
                    Lock lock = this.syncLock;
                    lock.lock();
                    try {
                        boolean $i$a$-withLock-VSPhysicsPipelineBackgroundTask$run$32 = false;
                        while (this.physicsTicksSinceLastGameTick >= physicsTicksPerGameTick) {
                            this.shouldRunPhysicsTick.await();
                        }
                        this.vsPipeline.tickPhysics(this.vsPipeline.getPhysicsGravity(), timeStep);
                        int n = this.physicsTicksSinceLastGameTick;
                        this.physicsTicksSinceLastGameTick = n + 1;
                        if (this.physicsTicksSinceLastGameTick >= physicsTicksPerGameTick) {
                            this.shouldRunGameTick.signal();
                        }
                        Unit $i$a$-withLock-VSPhysicsPipelineBackgroundTask$run$32 = Unit.INSTANCE;
                        continue;
                    }
                    finally {
                        lock.unlock();
                        continue;
                    }
                }
                if (!this.vsPipeline.getArePhysicsRunning()) {
                    this.lostTime = 0L;
                    this.prevPhysTicksTimeMillis.clear();
                    Lock physicsTicksPerGameTick = this.pauseLock;
                    physicsTicksPerGameTick.lock();
                    try {
                        boolean bl = false;
                        while (!this.vsPipeline.getArePhysicsRunning()) {
                            this.shouldUnpausePhysicsTick.await();
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        physicsTicksPerGameTick.unlock();
                    }
                }
                double timeToSimulateNs = 1.0E9 / (double)this.idealPhysicsTps;
                double timeStep = timeToSimulateNs / 1.0E9;
                boolean $i$f$measureNanoTime = false;
                long start$iv = System.nanoTime();
                boolean bl = false;
                this.vsPipeline.tickPhysics(this.vsPipeline.getPhysicsGravity(), timeStep);
                long timeToRunPhysTick = System.nanoTime() - start$iv;
                this.trackTickEnd();
                this.sleepOnLostTime(timeToSimulateNs, timeToRunPhysTick);
            }
        }
        catch (Exception e) {
            VSPhysicsPipelineBackgroundTask.Companion.getLogger().error("Error in physics pipeline background task", (Throwable)e);
            int n = 10;
            int n2 = 0;
            while (n2 < n) {
                int it = n2++;
                boolean bl = false;
                VSPhysicsPipelineBackgroundTask.Companion.getLogger().error("!!!!!!! VS PHYSICS THREAD CRASHED !!!!!!!");
            }
        }
        VSPhysicsPipelineBackgroundTask.Companion.getLogger().warn("Physics pipeline ending");
    }

    public final void tellTaskToKillItself() {
        this.killTask = true;
    }

    private final void trackTickEnd() {
        long currentTimeMillis = System.currentTimeMillis();
        this.prevPhysTicksTimeMillis.add(currentTimeMillis);
        while (!((Collection)this.prevPhysTicksTimeMillis).isEmpty() && ((Number)this.prevPhysTicksTimeMillis.peek()).longValue() + (long)5000 < currentTimeMillis) {
            this.prevPhysTicksTimeMillis.remove();
        }
    }

    private final void sleepOnLostTime(double timeToSimulateNs, long timeToRunPhysTick) {
        double timeDif = timeToSimulateNs - (double)timeToRunPhysTick;
        if (timeDif < 0.0) {
            this.lostTime = Math.min(this.lostTime - (long)timeDif, 1000000000L);
        } else if ((double)this.lostTime > timeDif) {
            this.lostTime -= (long)timeDif;
        } else {
            double timeToWait = timeDif - (double)this.lostTime;
            this.lostTime = 0L;
            this.sleepExact((long)timeToWait);
        }
    }

    private final void sleepExact(long sleepTimeNanos) {
        long startTime = System.nanoTime();
        long timeToSleep = sleepTimeNanos - (long)1000000;
        LockSupport.parkNanos(timeToSleep);
        while (System.nanoTime() - startTime < sleepTimeNanos) {
            ThreadHints.onSpinWait();
        }
    }

    public final double computePhysicsTPS() {
        return (double)this.prevPhysTicksTimeMillis.size() / 5.0;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u001b\u0010\r\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsPipelineBackgroundTask$Companion;", "", "", "MAX_LOST_TIME", "J", "", "PHYS_TICK_AVERAGE_WINDOW_MS", "I", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V", "impl"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

