/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.pipelines;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.api.ServerShipInternal;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.core.impl.networking.PacketType;
import org.valkyrienskies.core.impl.networking.Packets;
import org.valkyrienskies.core.impl.networking.VSNetworking;
import org.valkyrienskies.core.impl.pipelines.ShipInPhysicsFrameData;
import org.valkyrienskies.core.impl.pipelines.VSGamePipelineStage;
import org.valkyrienskies.core.impl.pipelines.VSPhysicsFrame;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;
import org.valkyrienskies.core.impl.util.VSCoreUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\b\u0007\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\"\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lorg/valkyrienskies/core/impl/pipelines/VSNetworkPipelineStage;", "", "Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsFrame;", "physicsFrame", "", "pushPhysicsFrame", "(Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsFrame;)V", "Lorg/valkyrienskies/core/impl/networking/VSNetworking;", "networking", "Lorg/valkyrienskies/core/impl/networking/VSNetworking;", "", "noSkip", "Z", "getNoSkip", "()Z", "setNoSkip", "(Z)V", "Lorg/valkyrienskies/core/impl/networking/Packets;", "packets", "Lorg/valkyrienskies/core/impl/networking/Packets;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", "shipWorld", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/ShipObjectServerWorld;Lorg/valkyrienskies/core/impl/networking/VSNetworking;Lorg/valkyrienskies/core/impl/networking/Packets;)V", "Companion", "impl"})
public final class VSNetworkPipelineStage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ShipObjectServerWorld shipWorld;
    @NotNull
    private final VSNetworking networking;
    @NotNull
    private final Packets packets;
    private boolean noSkip;
    public static final int TRANSFORM_SIZE = 128;
    @NotNull
    private static final Logger logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.pipelines.VSNetworkPipelineStage$Companion.$$delegatedProperties[0]);

    @Inject
    public VSNetworkPipelineStage(@NotNull ShipObjectServerWorld shipWorld, @NotNull VSNetworking networking, @NotNull Packets packets) {
        Intrinsics.checkNotNullParameter((Object)shipWorld, (String)"shipWorld");
        Intrinsics.checkNotNullParameter((Object)networking, (String)"networking");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        this.shipWorld = shipWorld;
        this.networking = networking;
        this.packets = packets;
        this.noSkip = true;
    }

    public final boolean getNoSkip() {
        return this.noSkip;
    }

    public final void setNoSkip(boolean bl) {
        this.noSkip = bl;
    }

    public final void pushPhysicsFrame(@NotNull VSPhysicsFrame physicsFrame) {
        Intrinsics.checkNotNullParameter((Object)physicsFrame, (String)"physicsFrame");
        boolean bl = this.noSkip = !this.noSkip;
        if (this.noSkip) {
            return;
        }
        Map $this$forEach$iv = (Map)this.shipWorld.getPlayersToTrackedShips();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl2 = false;
            IPlayer player = (IPlayer)entry.getKey();
            ImmutableSet trackedShips = (ImmutableSet)entry.getValue();
            ByteBuf buf = Unpooled.buffer();
            if (this.networking.getServerUsesUDP()) {
                Intrinsics.checkNotNullExpressionValue((Object)trackedShips, (String)"trackedShips");
                Iterable $this$forEach$iv2 = CollectionsKt.chunked((Iterable)((Iterable)trackedShips), (int)3);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    List p0 = (List)element$iv2;
                    boolean bl3 = false;
                    VSNetworkPipelineStage.pushPhysicsFrame$lambda$0$send(buf, physicsFrame, this, player, p0);
                }
                continue;
            }
            ImmutableList immutableList = trackedShips.asList();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"trackedShips.asList()");
            VSNetworkPipelineStage.pushPhysicsFrame$lambda$0$send(buf, physicsFrame, this, player, (List)immutableList);
        }
    }

    private static final void pushPhysicsFrame$lambda$0$send(ByteBuf buf, VSPhysicsFrame $physicsFrame, VSNetworkPipelineStage this$0, IPlayer player, List<? extends ServerShipInternal> shipDatas) {
        buf.clear();
        Intrinsics.checkNotNullExpressionValue((Object)buf, (String)"buf");
        Companion.writePacket(buf, shipDatas, $physicsFrame);
        PacketType packetType = this$0.packets.getUDP_SHIP_TRANSFORM();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        packetType.sendToClient(buf, player);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J+\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001b\u0010\u0014\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/valkyrienskies/core/impl/pipelines/VSNetworkPipelineStage$Companion;", "", "Lio/netty/buffer/ByteBuf;", "buf", "", "Lorg/valkyrienskies/core/impl/api/ServerShipInternal;", "shipDatas", "Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsFrame;", "frame", "", "writePacket", "(Lio/netty/buffer/ByteBuf;Ljava/util/List;Lorg/valkyrienskies/core/impl/pipelines/VSPhysicsFrame;)V", "", "TRANSFORM_SIZE", "I", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V", "impl"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        public final void writePacket(@NotNull ByteBuf buf, @NotNull List<? extends ServerShipInternal> shipDatas, @NotNull VSPhysicsFrame frame) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter(shipDatas, (String)"shipDatas");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Map<Long, ShipInPhysicsFrameData> ships = frame.getShipDataMap();
            buf.writeInt(frame.getPhysTickNumber());
            Iterable $this$forEach$iv = shipDatas;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ShipInPhysicsFrameData physicsFrameData;
                ServerShipInternal shipData = (ServerShipInternal)element$iv;
                boolean bl = false;
                if (ships.get(shipData.getId()) == null) continue;
                ShipTransform transform = VSGamePipelineStage.Companion.generateTransformFromPhysicsFrameData(physicsFrameData, shipData);
                buf.writeLong(shipData.getId());
                VSCoreUtilKt.writeVec3d(buf, transform.getPositionInShip());
                VSCoreUtilKt.writeVec3AsFloat(buf, transform.getShipToWorldScaling());
                VSCoreUtilKt.writeNormQuatdAs3F(buf, transform.getShipToWorldRotation());
                VSCoreUtilKt.writeVec3d(buf, transform.getPositionInWorld());
                VSCoreUtilKt.writeVec3AsFloat(buf, shipData.getVelocity());
                VSCoreUtilKt.writeVec3AsFloat(buf, shipData.getOmega());
                AABBic aABBic = shipData.getShipAABB();
                if (aABBic == null) {
                    aABBic = (AABBic)new AABBi(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
                }
                AABBic shipAABB = aABBic;
                VSCoreUtilKt.writeAABBi(buf, shipAABB);
            }
        }

        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

