/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.networking.simple;

import dagger.Lazy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty;
import kotlin.reflect.full.KClasses;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.networking.NetworkChannel;
import org.valkyrienskies.core.impl.networking.Packet;
import org.valkyrienskies.core.impl.networking.PacketType;
import org.valkyrienskies.core.impl.networking.RegisteredHandler;
import org.valkyrienskies.core.impl.networking.VSNetworking;
import org.valkyrienskies.core.impl.networking.simple.SimplePacket;
import org.valkyrienskies.core.impl.networking.simple.SimplePacketNetworking;
import org.valkyrienskies.core.impl.networking.simple.SimplePacketNetworkingImpl;
import org.valkyrienskies.core.impl.networking.simple.SimplePackets;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 12\u00020\u0001:\u000212B\u0019\b\u0007\u0012\u000e\b\u0001\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050,\u00a2\u0006\u0004\b/\u00100J1\u0010\n\u001a\u00020\t2\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ;\u0010\u0010\u001a\u00020\u000f\"\b\b\u0000\u0010\f*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011JA\u0010\u0014\u001a\u00020\u000f\"\b\b\u0000\u0010\f*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\t0\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ+\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00032\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u001c\"\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b \u0010\u0018J\u001b\u0010#\u001a\u00020\"*\n\u0012\u0006\b\u0001\u0012\u00020\u00030!H\u0002\u00a2\u0006\u0004\b#\u0010$J\u001b\u0010&\u001a\u00020%*\n\u0012\u0006\b\u0001\u0012\u00020\u00030!H\u0002\u00a2\u0006\u0004\b&\u0010'R@\u0010*\u001a.\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030!\u0012\u0004\u0012\u00020%0(j\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00030!\u0012\u0004\u0012\u00020%`)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u00063"}, d2={"Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworkingImpl;", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;", "Lkotlin/reflect/KClass;", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacket;", "klass", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "channel", "", "name", "", "register", "(Lkotlin/reflect/KClass;Lorg/valkyrienskies/core/impl/networking/NetworkChannel;Ljava/lang/String;)V", "T", "Lkotlin/Function1;", "handler", "Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "registerClientHandler", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function1;)Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "Lkotlin/Function2;", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "registerServerHandler", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function2;)Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "packet", "sendToAllClients", "(Lorg/valkyrienskies/core/impl/networking/simple/SimplePacket;)V", "player", "sendToClient", "(Lorg/valkyrienskies/core/impl/networking/simple/SimplePacket;Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "", "players", "sendToClients", "(Lorg/valkyrienskies/core/impl/networking/simple/SimplePacket;[Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "sendToServer", "Ljava/lang/Class;", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "getPacketType", "(Ljava/lang/Class;)Lorg/valkyrienskies/core/impl/networking/PacketType;", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworkingImpl$SimplePacketInfo;", "getSimplePacketInfo", "(Ljava/lang/Class;)Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworkingImpl$SimplePacketInfo;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "classToPacket", "Ljava/util/HashMap;", "Ldagger/Lazy;", "defaultChannel", "Ldagger/Lazy;", "<init>", "(Ldagger/Lazy;)V", "Companion", "SimplePacketInfo", "impl"})
public class SimplePacketNetworkingImpl
implements SimplePacketNetworking {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy<NetworkChannel> defaultChannel;
    @NotNull
    private final HashMap<Class<? extends SimplePacket>, SimplePacketInfo> classToPacket;
    @NotNull
    private static final Logger logger$delegate = LoggingKt.logger("Simple Packet");

    @Inject
    public SimplePacketNetworkingImpl(@VSNetworking.NetworkingModule.TCP @NotNull Lazy<NetworkChannel> defaultChannel) {
        Intrinsics.checkNotNullParameter(defaultChannel, (String)"defaultChannel");
        this.defaultChannel = defaultChannel;
        this.classToPacket = new HashMap();
    }

    private final SimplePacketInfo getSimplePacketInfo(Class<? extends SimplePacket> $this$getSimplePacketInfo) {
        SimplePacketInfo simplePacketInfo = this.classToPacket.get($this$getSimplePacketInfo);
        if (simplePacketInfo == null) {
            boolean bl = false;
            String string = "SimplePacket (" + $this$getSimplePacketInfo + ") not registered";
            throw new IllegalArgumentException(string.toString());
        }
        return simplePacketInfo;
    }

    private final PacketType getPacketType(Class<? extends SimplePacket> $this$getPacketType) {
        return this.getSimplePacketInfo($this$getPacketType).getType();
    }

    @Override
    @NotNull
    public <T extends SimplePacket> RegisteredHandler registerServerHandler(@NotNull KClass<T> klass, @NotNull Function2<? super T, ? super IPlayer, Unit> handler) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.getSimplePacketInfo(JvmClassMappingKt.getJavaClass(klass)).getServerHandlers().add((Function2<SimplePacket, IPlayer, Unit>)((Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(handler, (int)2)));
        return () -> SimplePacketNetworkingImpl.registerServerHandler$lambda$1(this, klass, handler);
    }

    @Override
    @NotNull
    public <T extends SimplePacket> RegisteredHandler registerClientHandler(@NotNull KClass<T> klass, @NotNull Function1<? super T, Unit> handler) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.getSimplePacketInfo(JvmClassMappingKt.getJavaClass(klass)).getClientHandlers().add((Function1<SimplePacket, Unit>)((Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(handler, (int)1)));
        return () -> SimplePacketNetworkingImpl.registerClientHandler$lambda$2(this, klass, handler);
    }

    @Override
    public void sendToServer(@NotNull SimplePacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this.getPacketType(packet.getClass()).sendToServer(SimplePackets.serialize(packet));
    }

    @Override
    public void sendToClient(@NotNull SimplePacket packet, @NotNull IPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.getPacketType(packet.getClass()).sendToClient(SimplePackets.serialize(packet), player);
    }

    @Override
    public void sendToClients(@NotNull SimplePacket packet, IPlayer ... players) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)players, (String)"players");
        if (!(!(players.length == 0))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.getPacketType(packet.getClass()).sendToClients(SimplePackets.serialize(packet), Arrays.copyOf(players, players.length));
    }

    @Override
    public void sendToAllClients(@NotNull SimplePacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this.getPacketType(packet.getClass()).sendToAllClients(SimplePackets.serialize(packet));
    }

    @Override
    public void register(@NotNull KClass<? extends SimplePacket> klass, @Nullable NetworkChannel channel, @NotNull String name) {
        boolean bl;
        block11: {
            KFunction it;
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block10: {
                Intrinsics.checkNotNullParameter(klass, (String)"klass");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                if (!klass.isData()) {
                    boolean $i$a$-check-SimplePacketNetworkingImpl$register$22 = false;
                    String $i$a$-check-SimplePacketNetworkingImpl$register$22 = "SimplePacket (" + JvmClassMappingKt.getJavaClass(klass) + ") must be a data class!";
                    throw new IllegalStateException($i$a$-check-SimplePacketNetworkingImpl$register$22.toString());
                }
                NetworkChannel networkChannel = channel;
                if (networkChannel == null) {
                    networkChannel = (NetworkChannel)this.defaultChannel.get();
                }
                NetworkChannel channel2 = networkChannel;
                PacketType packetType = channel2.registerPacket(name);
                SimplePacketInfo packetInfo = new SimplePacketInfo(packetType, null, null, 6, null);
                ((Map)this.classToPacket).put(JvmClassMappingKt.getJavaClass(klass), packetInfo);
                packetType.registerClientHandler(arg_0 -> SimplePacketNetworkingImpl.register$lambda$5(klass, packetInfo, packetType, arg_0));
                packetType.registerServerHandler((arg_0, arg_1) -> SimplePacketNetworkingImpl.register$lambda$7(klass, packetInfo, packetType, arg_0, arg_1));
                $this$any$iv = KClasses.getDeclaredMemberFunctions(klass);
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KFunction)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"receivedByClient")) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                this.registerClientHandler1(klass, register.5.INSTANCE);
            }
            $this$any$iv = KClasses.getDeclaredMemberFunctions(klass);
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KFunction)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"receivedByServer")) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            this.registerServerHandler1(klass, register.7.INSTANCE);
        }
    }

    private static final void registerServerHandler$lambda$1(SimplePacketNetworkingImpl this$0, KClass $klass, Function2 $handler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$klass, (String)"$klass");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        this$0.getSimplePacketInfo(JvmClassMappingKt.getJavaClass((KClass)$klass)).getServerHandlers().remove($handler);
    }

    private static final void registerClientHandler$lambda$2(SimplePacketNetworkingImpl this$0, KClass $klass, Function1 $handler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$klass, (String)"$klass");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        this$0.getSimplePacketInfo(JvmClassMappingKt.getJavaClass((KClass)$klass)).getClientHandlers().remove($handler);
    }

    private static final void register$lambda$5(KClass $klass, SimplePacketInfo $packetInfo, PacketType $packetType, Packet packet) {
        Intrinsics.checkNotNullParameter((Object)$klass, (String)"$klass");
        Intrinsics.checkNotNullParameter((Object)$packetInfo, (String)"$packetInfo");
        Intrinsics.checkNotNullParameter((Object)$packetType, (String)"$packetType");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Object data = SimplePackets.deserialize($klass, packet.getData());
        Iterable $this$forEach$iv = $packetInfo.getClientHandlers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke(data);
        }
        if ($packetInfo.getClientHandlers().isEmpty()) {
            SimplePacketNetworkingImpl.Companion.getLogger().warn("No client handlers registered for the received SimplePacket (" + $packetType + ')');
        }
    }

    private static final void register$lambda$7(KClass $klass, SimplePacketInfo $packetInfo, PacketType $packetType, Packet packet, IPlayer player) {
        Intrinsics.checkNotNullParameter((Object)$klass, (String)"$klass");
        Intrinsics.checkNotNullParameter((Object)$packetInfo, (String)"$packetInfo");
        Intrinsics.checkNotNullParameter((Object)$packetType, (String)"$packetType");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object data = SimplePackets.deserialize($klass, packet.getData());
        Iterable $this$forEach$iv = $packetInfo.getServerHandlers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke(data, (Object)player);
        }
        if ($packetInfo.getServerHandlers().isEmpty()) {
            SimplePacketNetworkingImpl.Companion.getLogger().warn("No server handlers registered for the received SimplePacket (" + $packetType + ')');
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u001b\u0010\u0007\u001a\u00020\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworkingImpl$Companion;", "", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V", "impl"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u0012 \b\u0002\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u0012\u001a\b\u0002\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\f0\u0005\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\"\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\f0\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000bJX\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u000e\u001a\u00020\u00022 \b\u0002\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u00052\u001a\b\u0002\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\f0\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR)\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\f0\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u001d\u001a\u0004\b\u001e\u0010\u000bR/\u0010\u000f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001d\u001a\u0004\b\u001f\u0010\u000bR\u0017\u0010\u000e\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010 \u001a\u0004\b!\u0010\u0004\u00a8\u0006$"}, d2={"Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworkingImpl$SimplePacketInfo;", "", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "component1", "()Lorg/valkyrienskies/core/impl/networking/PacketType;", "", "Lkotlin/Function2;", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacket;", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "", "component2", "()Ljava/util/List;", "Lkotlin/Function1;", "component3", "type", "serverHandlers", "clientHandlers", "copy", "(Lorg/valkyrienskies/core/impl/networking/PacketType;Ljava/util/List;Ljava/util/List;)Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworkingImpl$SimplePacketInfo;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getClientHandlers", "getServerHandlers", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "getType", "<init>", "(Lorg/valkyrienskies/core/impl/networking/PacketType;Ljava/util/List;Ljava/util/List;)V", "impl"})
    private static final class SimplePacketInfo {
        @NotNull
        private final PacketType type;
        @NotNull
        private final List<Function2<SimplePacket, IPlayer, Unit>> serverHandlers;
        @NotNull
        private final List<Function1<SimplePacket, Unit>> clientHandlers;

        public SimplePacketInfo(@NotNull PacketType type, @NotNull List<Function2<SimplePacket, IPlayer, Unit>> serverHandlers, @NotNull List<Function1<SimplePacket, Unit>> clientHandlers) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(serverHandlers, (String)"serverHandlers");
            Intrinsics.checkNotNullParameter(clientHandlers, (String)"clientHandlers");
            this.type = type;
            this.serverHandlers = serverHandlers;
            this.clientHandlers = clientHandlers;
        }

        public /* synthetic */ SimplePacketInfo(PacketType packetType, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = new ArrayList();
            }
            if ((n & 4) != 0) {
                list2 = new ArrayList();
            }
            this(packetType, list, list2);
        }

        @NotNull
        public final PacketType getType() {
            return this.type;
        }

        @NotNull
        public final List<Function2<SimplePacket, IPlayer, Unit>> getServerHandlers() {
            return this.serverHandlers;
        }

        @NotNull
        public final List<Function1<SimplePacket, Unit>> getClientHandlers() {
            return this.clientHandlers;
        }

        @NotNull
        public final PacketType component1() {
            return this.type;
        }

        @NotNull
        public final List<Function2<SimplePacket, IPlayer, Unit>> component2() {
            return this.serverHandlers;
        }

        @NotNull
        public final List<Function1<SimplePacket, Unit>> component3() {
            return this.clientHandlers;
        }

        @NotNull
        public final SimplePacketInfo copy(@NotNull PacketType type, @NotNull List<Function2<SimplePacket, IPlayer, Unit>> serverHandlers, @NotNull List<Function1<SimplePacket, Unit>> clientHandlers) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(serverHandlers, (String)"serverHandlers");
            Intrinsics.checkNotNullParameter(clientHandlers, (String)"clientHandlers");
            return new SimplePacketInfo(type, serverHandlers, clientHandlers);
        }

        public static /* synthetic */ SimplePacketInfo copy$default(SimplePacketInfo simplePacketInfo, PacketType packetType, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                packetType = simplePacketInfo.type;
            }
            if ((n & 2) != 0) {
                list = simplePacketInfo.serverHandlers;
            }
            if ((n & 4) != 0) {
                list2 = simplePacketInfo.clientHandlers;
            }
            return simplePacketInfo.copy(packetType, list, list2);
        }

        @NotNull
        public String toString() {
            return "SimplePacketInfo(type=" + this.type + ", serverHandlers=" + this.serverHandlers + ", clientHandlers=" + this.clientHandlers + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + ((Object)this.serverHandlers).hashCode();
            result = result * 31 + ((Object)this.clientHandlers).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SimplePacketInfo)) {
                return false;
            }
            SimplePacketInfo simplePacketInfo = (SimplePacketInfo)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)simplePacketInfo.type)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.serverHandlers, simplePacketInfo.serverHandlers)) {
                return false;
            }
            return Intrinsics.areEqual(this.clientHandlers, simplePacketInfo.clientHandlers);
        }
    }
}

