/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.networking;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.lang.annotation.Documented;
import java.lang.annotation.RetentionPolicy;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import javax.crypto.SecretKey;
import javax.inject.Inject;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.MustBeDocumented;
import kotlin.annotation.Retention;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.config.VSConfigClass;
import org.valkyrienskies.core.impl.config.VSCoreConfig;
import org.valkyrienskies.core.impl.networking.NetworkChannel;
import org.valkyrienskies.core.impl.networking.Packet;
import org.valkyrienskies.core.impl.networking.PacketType;
import org.valkyrienskies.core.impl.networking.Packets;
import org.valkyrienskies.core.impl.networking.RegisteredHandler;
import org.valkyrienskies.core.impl.networking.UdpClientImpl;
import org.valkyrienskies.core.impl.networking.UdpServerImpl;
import org.valkyrienskies.core.impl.networking.impl.PacketRequestUdp;
import org.valkyrienskies.core.impl.networking.impl.PacketUdpState;
import org.valkyrienskies.core.impl.networking.simple.SimplePacketNetworking;
import org.valkyrienskies.core.impl.networking.simple.SimplePacketNetworkingImpl;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;

@Singleton
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001;B-\b\u0007\u0012\b\b\u0001\u0010 \u001a\u00020\u0018\u0012\b\b\u0001\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u00108\u001a\u000207\u0012\u0006\u00105\u001a\u000204\u00a2\u0006\u0004\b9\u0010:J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010\u0004J%\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0019\u001a\u00020\u00188\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\u00020\u00188\u0006\u00a2\u0006\f\n\u0004\b \u0010\u001a\u001a\u0004\b!\u0010\u001cR\"\u0010\"\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001b\u0010-\u001a\u00020(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u0018\u0010/\u001a\u0004\u0018\u00010.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\"\u00101\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u0010#\u001a\u0004\b2\u0010%\"\u0004\b3\u0010'R\u0014\u00105\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106\u00a8\u0006<"}, d2={"Lorg/valkyrienskies/core/impl/networking/VSNetworking;", "", "", "init", "()V", "setupFallback", "Ljava/net/SocketAddress;", "socketAddress", "", "id", "", "setupUdpClient", "(Ljava/net/SocketAddress;J)Z", "tcp4udpFallback", "server", "Ljavax/crypto/SecretKey;", "secretKey", "Lit/unimi/dsi/fastutil/booleans/BooleanConsumer;", "supportsUdp", "tryUdpClient", "(Ljava/net/SocketAddress;Ljavax/crypto/SecretKey;Lit/unimi/dsi/fastutil/booleans/BooleanConsumer;)V", "Lorg/valkyrienskies/core/impl/networking/UdpServerImpl;", "tryUdpServer", "()Lorg/valkyrienskies/core/impl/networking/UdpServerImpl;", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "TCP", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "getTCP", "()Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "TCP_UDP_FALLBACK", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "UDP", "getUDP", "clientUsesUDP", "Z", "getClientUsesUDP", "()Z", "setClientUsesUDP", "(Z)V", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "prevStateHandler", "Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "serverUsesUDP", "getServerUsesUDP", "setServerUsesUDP", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;", "simplePackets", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;", "Lorg/valkyrienskies/core/impl/networking/Packets;", "packets", "<init>", "(Lorg/valkyrienskies/core/impl/networking/NetworkChannel;Lorg/valkyrienskies/core/impl/networking/NetworkChannel;Lorg/valkyrienskies/core/impl/networking/Packets;Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;)V", "NetworkingModule", "impl"})
public final class VSNetworking {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final NetworkChannel UDP;
    @NotNull
    private final NetworkChannel TCP;
    @NotNull
    private final SimplePacketNetworking simplePackets;
    @NotNull
    private final PacketType TCP_UDP_FALLBACK;
    private boolean clientUsesUDP;
    private boolean serverUsesUDP;
    @Nullable
    private RegisteredHandler prevStateHandler;
    @NotNull
    private final Logger logger$delegate;

    @Inject
    public VSNetworking(@NetworkingModule.UDP @NotNull NetworkChannel UDP2, @NetworkingModule.TCP @NotNull NetworkChannel TCP2, @NotNull Packets packets, @NotNull SimplePacketNetworking simplePackets) {
        Intrinsics.checkNotNullParameter((Object)UDP2, (String)"UDP");
        Intrinsics.checkNotNullParameter((Object)TCP2, (String)"TCP");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        Intrinsics.checkNotNullParameter((Object)simplePackets, (String)"simplePackets");
        this.UDP = UDP2;
        this.TCP = TCP2;
        this.simplePackets = simplePackets;
        this.TCP_UDP_FALLBACK = this.TCP.registerPacket("UDP fallback");
        this.logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(this, $$delegatedProperties[0]);
    }

    @NotNull
    public final NetworkChannel getUDP() {
        return this.UDP;
    }

    @NotNull
    public final NetworkChannel getTCP() {
        return this.TCP;
    }

    public final boolean getClientUsesUDP() {
        return this.clientUsesUDP;
    }

    public final void setClientUsesUDP(boolean bl) {
        this.clientUsesUDP = bl;
    }

    public final boolean getServerUsesUDP() {
        return this.serverUsesUDP;
    }

    public final void setServerUsesUDP(boolean bl) {
        this.serverUsesUDP = bl;
    }

    public final void init() {
        VSConfigClass.Companion.registerNetworkHandlers();
        this.setupFallback();
    }

    @Nullable
    public final UdpServerImpl tryUdpServer() {
        if (VSCoreConfig.SERVER.getEnableUdp()) {
            try {
                DatagramSocket udpSocket = new DatagramSocket(VSCoreConfig.SERVER.getUdpPort());
                UdpServerImpl udpServer = new UdpServerImpl(udpSocket, this.UDP, this.TCP_UDP_FALLBACK);
                this.serverUsesUDP = true;
                SimplePacketNetworking $this$tryUdpServer_u24lambda_u240 = this.simplePackets;
                boolean bl = false;
                $this$tryUdpServer_u24lambda_u240.registerServerHandler1(Reflection.getOrCreateKotlinClass(PacketRequestUdp.class), (Function2)new Function2<PacketRequestUdp, IPlayer, Unit>(udpServer, $this$tryUdpServer_u24lambda_u240, udpSocket, this){
                    final /* synthetic */ UdpServerImpl $udpServer;
                    final /* synthetic */ SimplePacketNetworking $this_with;
                    final /* synthetic */ DatagramSocket $udpSocket;
                    final /* synthetic */ VSNetworking this$0;
                    {
                        this.$udpServer = $udpServer;
                        this.$this_with = $receiver;
                        this.$udpSocket = $udpSocket;
                        this.this$0 = $receiver2;
                        super(2);
                    }

                    public final void invoke(@NotNull PacketRequestUdp packet, @NotNull IPlayer player) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                            Long l = this.$udpServer.prepareIdentifier(player, packet);
                            if (l == null) break block0;
                            Long l2 = l;
                            SimplePacketNetworking simplePacketNetworking = this.$this_with;
                            DatagramSocket datagramSocket = this.$udpSocket;
                            VSNetworking vSNetworking = this.this$0;
                            long it = ((Number)l2).longValue();
                            boolean bl = false;
                            simplePacketNetworking.sendToClient1(new PacketUdpState(datagramSocket.getLocalPort(), vSNetworking.getServerUsesUDP(), it), player);
                        }
                    }
                });
                return udpServer;
            }
            catch (SocketException e) {
                this.getLogger().error("Tried to bind to " + VSCoreConfig.SERVER.getUdpPort() + " but failed!", (Throwable)e);
            }
            catch (Exception e) {
                this.getLogger().error("Tried to setup udp with port: " + VSCoreConfig.SERVER.getUdpPort() + " but failed!", (Throwable)e);
            }
        }
        this.tcp4udpFallback();
        return null;
    }

    public final void tryUdpClient(@NotNull SocketAddress server, @NotNull SecretKey secretKey, @NotNull BooleanConsumer supportsUdp) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        Intrinsics.checkNotNullParameter((Object)supportsUdp, (String)"supportsUdp");
        RegisteredHandler registeredHandler = this.prevStateHandler;
        if (registeredHandler != null) {
            registeredHandler.unregister();
        }
        SimplePacketNetworking $this$tryUdpClient_u24lambda_u241 = this.simplePackets;
        boolean bl = false;
        this.prevStateHandler = $this$tryUdpClient_u24lambda_u241.registerClientHandler1(Reflection.getOrCreateKotlinClass(PacketUdpState.class), (Function1)new Function1<PacketUdpState, Unit>(supportsUdp, server, this){
            final /* synthetic */ BooleanConsumer $supportsUdp;
            final /* synthetic */ SocketAddress $server;
            final /* synthetic */ VSNetworking this$0;
            {
                this.$supportsUdp = $supportsUdp;
                this.$server = $server;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull PacketUdpState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$supportsUdp.accept(it.getState());
                if (it.getState()) {
                    SocketAddress server = this.$server;
                    if (server instanceof InetSocketAddress && ((InetSocketAddress)server).getPort() != it.getPort()) {
                        server = new InetSocketAddress(((InetSocketAddress)server).getAddress(), it.getPort());
                    }
                    if (!VSNetworking.access$setupUdpClient(this.this$0, server, it.getId())) {
                        VSNetworking.access$tcp4udpFallback(this.this$0);
                    }
                }
            }
        });
        byte[] byArray = secretKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secretKey.encoded");
        $this$tryUdpClient_u24lambda_u241.sendToServer1(new PacketRequestUdp(0, byArray));
    }

    private final boolean setupUdpClient(SocketAddress socketAddress, long id) {
        try {
            DatagramSocket udpSocket = new DatagramSocket();
            new UdpClientImpl(udpSocket, this.UDP, socketAddress, id, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ VSNetworking this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.setClientUsesUDP(true);
                }
            }));
            return true;
        }
        catch (Exception e) {
            this.getLogger().error("Tried to setup udp client with socket address: " + socketAddress + " but failed!", (Throwable)e);
            return false;
        }
    }

    private final void tcp4udpFallback() {
        this.getLogger().info("We are not using UDP, falling back to TCP");
        this.clientUsesUDP = false;
        this.serverUsesUDP = false;
        SimplePacketNetworking $this$tcp4udpFallback_u24lambda_u242 = this.simplePackets;
        boolean bl = false;
        $this$tcp4udpFallback_u24lambda_u242.registerServerHandler1(Reflection.getOrCreateKotlinClass(PacketRequestUdp.class), (Function2)new Function2<PacketRequestUdp, IPlayer, Unit>($this$tcp4udpFallback_u24lambda_u242, this){
            final /* synthetic */ SimplePacketNetworking $this_with;
            final /* synthetic */ VSNetworking this$0;
            {
                this.$this_with = $receiver;
                this.this$0 = $receiver2;
                super(2);
            }

            public final void invoke(@NotNull PacketRequestUdp packet, @NotNull IPlayer player) {
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                this.$this_with.sendToClient1(new PacketUdpState(-1, this.this$0.getServerUsesUDP(), -1L), player);
            }
        });
        this.UDP.setRawSendToClient((Function2<? super ByteBuf, ? super IPlayer, Unit>)((Function2)new Function2<ByteBuf, IPlayer, Unit>(this){
            final /* synthetic */ VSNetworking this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ByteBuf data, @NotNull IPlayer player) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                VSNetworking.access$getTCP_UDP_FALLBACK$p(this.this$0).sendToClient(data, player);
            }
        }));
        this.UDP.setRawSendToServer((Function1<? super ByteBuf, Unit>)((Function1)new Function1<ByteBuf, Unit>(this){
            final /* synthetic */ VSNetworking this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ByteBuf data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                VSNetworking.access$getTCP_UDP_FALLBACK$p(this.this$0).sendToServer(data);
            }
        }));
    }

    private final void setupFallback() {
        this.TCP.registerClientHandler(this.TCP_UDP_FALLBACK, arg_0 -> VSNetworking.setupFallback$lambda$3(this, arg_0));
        this.TCP.registerServerHandler(this.TCP_UDP_FALLBACK, (arg_0, arg_1) -> VSNetworking.setupFallback$lambda$4(this, arg_0, arg_1));
    }

    private final Logger getLogger() {
        return ClassLogger.getValue-impl(this.logger$delegate, this, $$delegatedProperties[0]);
    }

    private static final void setupFallback$lambda$3(VSNetworking this$0, Packet packet) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        this$0.UDP.onReceiveClient(packet.getData());
    }

    private static final void setupFallback$lambda$4(VSNetworking this$0, Packet packet, IPlayer player) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this$0.UDP.onReceiveServer(packet.getData(), player);
    }

    public static final /* synthetic */ PacketType access$getTCP_UDP_FALLBACK$p(VSNetworking $this) {
        return $this.TCP_UDP_FALLBACK;
    }

    public static final /* synthetic */ boolean access$setupUdpClient(VSNetworking $this, SocketAddress socketAddress, long id) {
        return $this.setupUdpClient(socketAddress, id);
    }

    public static final /* synthetic */ void access$tcp4udpFallback(VSNetworking $this) {
        $this.tcp4udpFallback();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(VSNetworking.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Module
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u0000 \t2\u00020\u0001:\u0003\t\n\u000bB\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H'\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0003"}, d2={"Lorg/valkyrienskies/core/impl/networking/VSNetworking$NetworkingModule;", "", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworkingImpl;", "impl", "Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;", "simplePacketNetworking", "(Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworkingImpl;)Lorg/valkyrienskies/core/impl/networking/simple/SimplePacketNetworking;", "<init>", "()V", "Companion", "TCP", "UDP"})
    public static abstract class NetworkingModule {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Binds
        @Singleton
        @NotNull
        public abstract SimplePacketNetworking simplePacketNetworking(@NotNull SimplePacketNetworkingImpl var1);

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0004\u00a8\u0006\b"}, d2={"Lorg/valkyrienskies/core/impl/networking/VSNetworking$NetworkingModule$Companion;", "", "Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "tcp", "()Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "udp", "<init>", "()V", "impl"})
        public static final class Companion {
            private Companion() {
            }

            @Provides
            @Singleton
            @TCP
            @NotNull
            public final NetworkChannel tcp() {
                return new NetworkChannel();
            }

            @Provides
            @Singleton
            @UDP
            @NotNull
            public final NetworkChannel udp() {
                return new NetworkChannel();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Qualifier
        @MustBeDocumented
        @Retention(value=AnnotationRetention.BINARY)
        @Documented
        @java.lang.annotation.Retention(value=RetentionPolicy.CLASS)
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/valkyrienskies/core/impl/networking/VSNetworking$NetworkingModule$TCP;", "", "<init>", "()V", "impl"})
        public static @interface TCP {
        }

        @Qualifier
        @MustBeDocumented
        @Retention(value=AnnotationRetention.BINARY)
        @Documented
        @java.lang.annotation.Retention(value=RetentionPolicy.CLASS)
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/valkyrienskies/core/impl/networking/VSNetworking$NetworkingModule$UDP;", "", "<init>", "()V", "impl"})
        public static @interface UDP {
        }
    }
}

