/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.networking;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.networking.PacketType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\t\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001d\u001a\u0004\b\u001e\u0010\u0007R\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010\u0004\u00a8\u0006#"}, d2={"Lorg/valkyrienskies/core/impl/networking/Packet;", "", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "component1", "()Lorg/valkyrienskies/core/impl/networking/PacketType;", "Lio/netty/buffer/ByteBuf;", "component2", "()Lio/netty/buffer/ByteBuf;", "type", "data", "copy", "(Lorg/valkyrienskies/core/impl/networking/PacketType;Lio/netty/buffer/ByteBuf;)Lorg/valkyrienskies/core/impl/networking/Packet;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "player", "", "sendToClient", "(Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "sendToServer", "()V", "", "toString", "()Ljava/lang/String;", "Lio/netty/buffer/ByteBuf;", "getData", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "getType", "<init>", "(Lorg/valkyrienskies/core/impl/networking/PacketType;Lio/netty/buffer/ByteBuf;)V", "impl"})
public final class Packet {
    @NotNull
    private final PacketType type;
    @NotNull
    private final ByteBuf data;

    public Packet(@NotNull PacketType type, @NotNull ByteBuf data) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.type = type;
        this.data = data;
    }

    @NotNull
    public final PacketType getType() {
        return this.type;
    }

    @NotNull
    public final ByteBuf getData() {
        return this.data;
    }

    public final void sendToServer() {
        this.type.sendToServer(this.data);
    }

    public final void sendToClient(@NotNull IPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.type.sendToClient(this.data, player);
    }

    @NotNull
    public final PacketType component1() {
        return this.type;
    }

    @NotNull
    public final ByteBuf component2() {
        return this.data;
    }

    @NotNull
    public final Packet copy(@NotNull PacketType type, @NotNull ByteBuf data) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new Packet(type, data);
    }

    public static /* synthetic */ Packet copy$default(Packet packet, PacketType packetType, ByteBuf byteBuf, int n, Object object) {
        if ((n & 1) != 0) {
            packetType = packet.type;
        }
        if ((n & 2) != 0) {
            byteBuf = packet.data;
        }
        return packet.copy(packetType, byteBuf);
    }

    @NotNull
    public String toString() {
        return "Packet(type=" + this.type + ", data=" + this.data + ')';
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.data.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Packet)) {
            return false;
        }
        Packet packet = (Packet)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)packet.type)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.data, (Object)packet.data);
    }
}

