/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships.serialization.shiptransform;

import dagger.Reusable;
import javax.inject.Inject;
import javax.inject.Named;
import org.joml.Quaterniondc;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.impl.game.ships.serialization.shiptransform.ShipTransformConverter;
import org.valkyrienskies.core.impl.game.ships.serialization.shiptransform.dto.ShipTransformDataV0;

@Reusable
@Named
public class ShipTransformConverterImpl
implements ShipTransformConverter {
    @Inject
    public ShipTransformConverterImpl() {
    }

    @Override
    public ShipTransformImpl convertToModel(ShipTransformDataV0 data) {
        if (data == null) {
            return null;
        }
        Vector3dc positionInShip = null;
        Vector3dc positionInWorld = null;
        Quaterniondc shipToWorldRotation = null;
        Vector3dc shipToWorldScaling = null;
        positionInShip = data.getShipPositionInShipCoordinates();
        positionInWorld = data.getShipPositionInWorldCoordinates();
        shipToWorldRotation = data.getShipCoordinatesToWorldCoordinatesRotation();
        shipToWorldScaling = data.getShipCoordinatesToWorldCoordinatesScaling();
        ShipTransformImpl shipTransformImpl = new ShipTransformImpl(positionInWorld, positionInShip, shipToWorldRotation, shipToWorldScaling);
        return shipTransformImpl;
    }

    @Override
    public ShipTransformDataV0 convertToDto(ShipTransform model) {
        if (model == null) {
            return null;
        }
        Vector3dc shipPositionInShipCoordinates = null;
        Vector3dc shipPositionInWorldCoordinates = null;
        Quaterniondc shipCoordinatesToWorldCoordinatesRotation = null;
        Vector3dc shipCoordinatesToWorldCoordinatesScaling = null;
        shipPositionInShipCoordinates = model.getPositionInShip();
        shipPositionInWorldCoordinates = model.getPositionInWorld();
        shipCoordinatesToWorldCoordinatesRotation = model.getShipToWorldRotation();
        shipCoordinatesToWorldCoordinatesScaling = model.getShipToWorldScaling();
        ShipTransformDataV0 shipTransformDataV0 = new ShipTransformDataV0(shipPositionInWorldCoordinates, shipPositionInShipCoordinates, shipCoordinatesToWorldCoordinatesRotation, shipCoordinatesToWorldCoordinatesScaling);
        return shipTransformDataV0;
    }
}

