/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships.serialization.shipserver;

import com.google.common.collect.MutableClassToInstanceMap;
import dagger.Reusable;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.ShipData;
import org.valkyrienskies.core.impl.game.ships.ShipInertiaDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipPhysicsData;
import org.valkyrienskies.core.impl.game.ships.serialization.shipinertia.ShipInertiaConverter;
import org.valkyrienskies.core.impl.game.ships.serialization.shipserver.ServerShipDataConverter;
import org.valkyrienskies.core.impl.game.ships.serialization.shipserver.dto.ServerShipDataV3;
import org.valkyrienskies.core.impl.game.ships.serialization.shiptransform.ShipTransformConverter;

@Reusable
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/ServerShipDataConverterImpl;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/ServerShipDataConverter;", "Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "model", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/dto/ServerShipDataV3;", "convertToDto", "(Lorg/valkyrienskies/core/impl/game/ships/ShipData;)Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/dto/ServerShipDataV3;", "dto", "convertToModel", "(Lorg/valkyrienskies/core/impl/game/ships/serialization/shipserver/dto/ServerShipDataV3;)Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipinertia/ShipInertiaConverter;", "inertiaConverter", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shipinertia/ShipInertiaConverter;", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shiptransform/ShipTransformConverter;", "transformConverter", "Lorg/valkyrienskies/core/impl/game/ships/serialization/shiptransform/ShipTransformConverter;", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/serialization/shipinertia/ShipInertiaConverter;Lorg/valkyrienskies/core/impl/game/ships/serialization/shiptransform/ShipTransformConverter;)V", "impl"})
public final class ServerShipDataConverterImpl
implements ServerShipDataConverter {
    @NotNull
    private final ShipInertiaConverter inertiaConverter;
    @NotNull
    private final ShipTransformConverter transformConverter;

    @Inject
    public ServerShipDataConverterImpl(@NotNull ShipInertiaConverter inertiaConverter, @NotNull ShipTransformConverter transformConverter) {
        Intrinsics.checkNotNullParameter((Object)inertiaConverter, (String)"inertiaConverter");
        Intrinsics.checkNotNullParameter((Object)transformConverter, (String)"transformConverter");
        this.inertiaConverter = inertiaConverter;
        this.transformConverter = transformConverter;
    }

    @Override
    @NotNull
    public ServerShipDataV3 convertToDto(@NotNull ShipData model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        long l = model.getId();
        String string = model.getSlug();
        if (string == null) {
            string = "";
        }
        return new ServerShipDataV3(l, string, model.getChunkClaim(), model.getChunkClaimDimension(), model.getPhysicsData().getLinearVelocity(), model.getPhysicsData().getAngularVelocity(), this.inertiaConverter.convertToDto(model.getInertiaData()), this.transformConverter.convertToDto(model.getTransform()), this.transformConverter.convertToDto(model.getPrevTickTransform()), model.getWorldAABB(), model.getShipAABB(), model.getActiveChunksSet(), model.isStatic(), model.getPersistentAttachedData());
    }

    @Override
    @NotNull
    public ShipData convertToModel(@NotNull ServerShipDataV3 dto) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        long l = dto.getId();
        String string = Intrinsics.areEqual((Object)dto.getName(), (Object)"") ? null : dto.getName();
        ChunkClaim chunkClaim = dto.getChunkClaim();
        String string2 = dto.getChunkClaimDimension();
        ShipPhysicsData shipPhysicsData = new ShipPhysicsData(dto.getVelocity(), dto.getOmega());
        ShipInertiaDataImpl shipInertiaDataImpl = this.inertiaConverter.convertToModel(dto.getInertiaData());
        ShipTransform shipTransform = this.transformConverter.convertToModel(dto.getTransform());
        ShipTransform shipTransform2 = this.transformConverter.convertToModel(dto.getPrevTickTransform());
        AABBdc aABBdc = dto.getWorldAABB();
        AABBic aABBic = dto.getShipAABB();
        IShipActiveChunksSet iShipActiveChunksSet = dto.getActiveChunks();
        boolean bl = dto.isStatic();
        MutableClassToInstanceMap mutableClassToInstanceMap = MutableClassToInstanceMap.create((Map)((Map)dto.getPersistentAttachedData()));
        Intrinsics.checkNotNullExpressionValue((Object)mutableClassToInstanceMap, (String)"create(dto.persistentAttachedData)");
        return new ShipData(l, string, chunkClaim, string2, shipPhysicsData, shipInertiaDataImpl, shipTransform, shipTransform2, aABBdc, aABBic, iShipActiveChunksSet, bl, (MutableClassToInstanceMap<Object>)mutableClassToInstanceMap);
    }
}

