/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Wing;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.datastructures.BlockPos2ObjectOpenHashMap;
import org.valkyrienskies.core.impl.game.ships.WingGroupImpl;
import org.valkyrienskies.core.impl.game.ships.WingManagerImpl;
import org.valkyrienskies.physics_api.PoseVel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ9\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/WingPhysicsSolver;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "shipTransform", "Lorg/valkyrienskies/physics_api/PoseVel;", "poseVel", "Lorg/valkyrienskies/core/impl/game/ships/WingManagerImpl;", "wingManager", "Lorg/joml/Matrix3dc;", "momentOfInertia", "Lkotlin/Pair;", "Lorg/joml/Vector3dc;", "applyWingForces", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/physics_api/PoseVel;Lorg/valkyrienskies/core/impl/game/ships/WingManagerImpl;Lorg/joml/Matrix3dc;)Lkotlin/Pair;", "<init>", "()V", "impl"})
public final class WingPhysicsSolver {
    @NotNull
    public static final WingPhysicsSolver INSTANCE = new WingPhysicsSolver();

    private WingPhysicsSolver() {
    }

    @NotNull
    public final Pair<Vector3dc, Vector3dc> applyWingForces(@NotNull ShipTransform shipTransform, @NotNull PoseVel poseVel, @NotNull WingManagerImpl wingManager, @NotNull Matrix3dc momentOfInertia) {
        Intrinsics.checkNotNullParameter((Object)shipTransform, (String)"shipTransform");
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"poseVel");
        Intrinsics.checkNotNullParameter((Object)wingManager, (String)"wingManager");
        Intrinsics.checkNotNullParameter((Object)momentOfInertia, (String)"momentOfInertia");
        Vector3d netShipForce = new Vector3d();
        Vector3d netShipTorque = new Vector3d();
        Vector3dc vel = poseVel.getVel();
        Vector3dc omega = poseVel.getOmega();
        WingManagerImpl this_$iv = wingManager;
        boolean $i$f$forEachWing$impl = false;
        ObjectIterator objectIterator = ((ObjectCollection)WingManagerImpl.access$getWingGroups$p(this_$iv).values()).iterator();
        while (objectIterator.hasNext()) {
            Vector3d torque;
            Vector3dc totalForce;
            Vector3dc dragForceVector;
            double dragForceMagnitude;
            double dragCoefficient;
            Vector3dc liftForceVector;
            double liftForce;
            double liftCoefficient;
            Vector3d dragDirection;
            double angleOfAttack;
            Vector3dc liftVelDirection;
            Vector3dc liftVel;
            Vector3dc wingNormalGlobal;
            Vector3dc velAtWingGlobal;
            Vector3dc tDir;
            Vector3dc localPos;
            int posZ;
            int posY;
            int posX;
            Vector3dc wingNormalLocal;
            Wing wing;
            boolean bl;
            Matrix4dc wingTransform;
            int posY$iv;
            int posZ$iv;
            Wing wing$iv;
            boolean bl2;
            int posX$iv;
            WingGroupImpl wingGroup$iv;
            WingGroupImpl this_$iv$iv = wingGroup$iv = (WingGroupImpl)objectIterator.next();
            boolean $i$f$forEachWing$impl2 = false;
            BlockPos2ObjectOpenHashMap this_$iv$iv$iv = WingGroupImpl.access$getWingsMap$p(this_$iv$iv);
            boolean $i$f$forEach = false;
            if (this_$iv$iv$iv.getContainsNullKey()) {
                Wing wing2 = (Wing)this_$iv$iv$iv.getValues()[this_$iv$iv$iv.getN()];
                int n = this_$iv$iv$iv.getKeys()[this_$iv$iv$iv.getN() * 3 + 2];
                int n2 = this_$iv$iv$iv.getKeys()[this_$iv$iv$iv.getN() * 3 + 1];
                posX$iv = this_$iv$iv$iv.getKeys()[this_$iv$iv$iv.getN() * 3];
                bl2 = false;
                Wing wing3 = wing$iv;
                void var23_25 = posZ$iv;
                void var24_26 = posY$iv;
                int n3 = posX$iv;
                wingTransform = wingGroup$iv.getWingTransform();
                bl = false;
                Vector3d vector3d = wingTransform.transformDirection(new Vector3d(wing.getWingNormal()));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"wingTransform.transformD\u2026ector3d(wing.wingNormal))");
                wingNormalLocal = (Vector3dc)vector3d;
                Vector3d vector3d2 = wingTransform.transformPosition(new Vector3d((double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"wingTransform.transformP\u2026 posY + 0.5, posZ + 0.5))");
                localPos = (Vector3dc)vector3d2;
                Vector3d vector3d3 = shipTransform.getShipToWorld().transformPosition(localPos, new Vector3d()).sub(shipTransform.getPositionInWorld());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"shipTransform.shipToWorl\u2026ransform.positionInWorld)");
                tDir = (Vector3dc)vector3d3;
                Vector3d vector3d4 = new Vector3d(omega).cross(tDir).add(vel);
                Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"Vector3d(omega).cross(tDir)).add(vel)");
                velAtWingGlobal = (Vector3dc)vector3d4;
                Vector3d vector3d5 = shipTransform.getShipToWorld().transformDirection(wingNormalLocal, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"shipTransform.shipToWorl\u2026gNormalLocal, Vector3d())");
                wingNormalGlobal = (Vector3dc)vector3d5;
                Vector3d vector3d6 = velAtWingGlobal.sub((Vector3dc)new Vector3d(wingNormalGlobal).mul(wingNormalGlobal.dot(velAtWingGlobal)), new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"velAtWingGlobal.sub(Vect\u2026WingGlobal)), Vector3d())");
                liftVel = (Vector3dc)vector3d6;
                if (liftVel.lengthSquared() > 1.0E-12) {
                    Vector3d vector3d7 = new Vector3d(liftVel).normalize();
                    Intrinsics.checkNotNullExpressionValue((Object)vector3d7, (String)"Vector3d(liftVel).normalize()");
                    liftVelDirection = (Vector3dc)vector3d7;
                    angleOfAttack = liftVelDirection.angle(velAtWingGlobal) * -Math.signum(wingNormalGlobal.dot(velAtWingGlobal)) + wing.getWingCamberAttackAngleBias();
                    dragDirection = velAtWingGlobal.mul(-1.0, new Vector3d());
                    if (!(dragDirection.lengthSquared() < 1.0E-12)) {
                        dragDirection.normalize();
                        Intrinsics.checkNotNull((Object)dragDirection, (String)"null cannot be cast to non-null type org.joml.Vector3dc");
                        Vector3dc cfr_ignored_0 = (Vector3dc)dragDirection;
                        liftCoefficient = Math.sin(2.0 * angleOfAttack);
                        liftForce = RangesKt.coerceIn((double)(wing.getWingLiftPower() * liftCoefficient * liftVel.lengthSquared()), (double)-1.0E7, (double)1.0E7);
                        Vector3d vector3d8 = wingNormalGlobal.mul(liftForce, new Vector3d());
                        Intrinsics.checkNotNullExpressionValue((Object)vector3d8, (String)"wingNormalGlobal.mul(liftForce, Vector3d())");
                        liftForceVector = (Vector3dc)vector3d8;
                        dragCoefficient = 1.0 - Math.cos(2.0 * angleOfAttack);
                        dragForceMagnitude = wing.getWingDragPower() * dragCoefficient * velAtWingGlobal.lengthSquared();
                        Vector3d vector3d9 = dragDirection.mul(dragForceMagnitude, new Vector3d());
                        Intrinsics.checkNotNullExpressionValue((Object)vector3d9, (String)"dragDirection.mul(dragForceMagnitude, Vector3d())");
                        dragForceVector = (Vector3dc)vector3d9;
                        Vector3d vector3d10 = liftForceVector.add(dragForceVector, new Vector3d());
                        Intrinsics.checkNotNullExpressionValue((Object)vector3d10, (String)"liftForceVector.add(dragForceVector, Vector3d())");
                        totalForce = (Vector3dc)vector3d10;
                        if (!(totalForce.lengthSquared() > 1.0E16)) {
                            torque = tDir.cross(totalForce, new Vector3d());
                            netShipForce.add(totalForce);
                            netShipTorque.add((Vector3dc)torque);
                        }
                    }
                }
            }
            for (int pos$iv$iv$iv = this_$iv$iv$iv.getN(); -1 < pos$iv$iv$iv; --pos$iv$iv$iv) {
                if (this_$iv$iv$iv.getKeys()[pos$iv$iv$iv * 3] == 0 && this_$iv$iv$iv.getKeys()[pos$iv$iv$iv * 3 + 1] == 0 && this_$iv$iv$iv.getKeys()[pos$iv$iv$iv * 3 + 2] == 0) continue;
                wing$iv = (Wing)this_$iv$iv$iv.getValues()[pos$iv$iv$iv];
                posZ$iv = this_$iv$iv$iv.getKeys()[pos$iv$iv$iv * 3 + 2];
                posY$iv = this_$iv$iv$iv.getKeys()[pos$iv$iv$iv * 3 + 1];
                posX$iv = this_$iv$iv$iv.getKeys()[pos$iv$iv$iv * 3];
                bl2 = false;
                wing = wing$iv;
                posZ = posZ$iv;
                posY = posY$iv;
                posX = posX$iv;
                wingTransform = wingGroup$iv.getWingTransform();
                bl = false;
                Vector3d vector3d = wingTransform.transformDirection(new Vector3d(wing.getWingNormal()));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"wingTransform.transformD\u2026ector3d(wing.wingNormal))");
                wingNormalLocal = (Vector3dc)vector3d;
                Vector3d vector3d11 = wingTransform.transformPosition(new Vector3d((double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d11, (String)"wingTransform.transformP\u2026 posY + 0.5, posZ + 0.5))");
                localPos = (Vector3dc)vector3d11;
                Vector3d vector3d12 = shipTransform.getShipToWorld().transformPosition(localPos, new Vector3d()).sub(shipTransform.getPositionInWorld());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d12, (String)"shipTransform.shipToWorl\u2026ransform.positionInWorld)");
                tDir = (Vector3dc)vector3d12;
                Vector3d vector3d13 = new Vector3d(omega).cross(tDir).add(vel);
                Intrinsics.checkNotNullExpressionValue((Object)vector3d13, (String)"Vector3d(omega).cross(tDir)).add(vel)");
                velAtWingGlobal = (Vector3dc)vector3d13;
                Vector3d vector3d14 = shipTransform.getShipToWorld().transformDirection(wingNormalLocal, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d14, (String)"shipTransform.shipToWorl\u2026gNormalLocal, Vector3d())");
                wingNormalGlobal = (Vector3dc)vector3d14;
                Vector3d vector3d15 = velAtWingGlobal.sub((Vector3dc)new Vector3d(wingNormalGlobal).mul(wingNormalGlobal.dot(velAtWingGlobal)), new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d15, (String)"velAtWingGlobal.sub(Vect\u2026WingGlobal)), Vector3d())");
                liftVel = (Vector3dc)vector3d15;
                if (!(liftVel.lengthSquared() > 1.0E-12)) continue;
                Vector3d vector3d16 = new Vector3d(liftVel).normalize();
                Intrinsics.checkNotNullExpressionValue((Object)vector3d16, (String)"Vector3d(liftVel).normalize()");
                liftVelDirection = (Vector3dc)vector3d16;
                angleOfAttack = liftVelDirection.angle(velAtWingGlobal) * -Math.signum(wingNormalGlobal.dot(velAtWingGlobal)) + wing.getWingCamberAttackAngleBias();
                dragDirection = velAtWingGlobal.mul(-1.0, new Vector3d());
                if (dragDirection.lengthSquared() < 1.0E-12) continue;
                dragDirection.normalize();
                Intrinsics.checkNotNull((Object)dragDirection, (String)"null cannot be cast to non-null type org.joml.Vector3dc");
                Vector3dc cfr_ignored_1 = (Vector3dc)dragDirection;
                liftCoefficient = Math.sin(2.0 * angleOfAttack);
                liftForce = RangesKt.coerceIn((double)(wing.getWingLiftPower() * liftCoefficient * liftVel.lengthSquared()), (double)-1.0E7, (double)1.0E7);
                Vector3d vector3d17 = wingNormalGlobal.mul(liftForce, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d17, (String)"wingNormalGlobal.mul(liftForce, Vector3d())");
                liftForceVector = (Vector3dc)vector3d17;
                dragCoefficient = 1.0 - Math.cos(2.0 * angleOfAttack);
                dragForceMagnitude = wing.getWingDragPower() * dragCoefficient * velAtWingGlobal.lengthSquared();
                Vector3d vector3d18 = dragDirection.mul(dragForceMagnitude, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d18, (String)"dragDirection.mul(dragForceMagnitude, Vector3d())");
                dragForceVector = (Vector3dc)vector3d18;
                Vector3d vector3d19 = liftForceVector.add(dragForceVector, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d19, (String)"liftForceVector.add(dragForceVector, Vector3d())");
                totalForce = (Vector3dc)vector3d19;
                if (totalForce.lengthSquared() > 1.0E16) continue;
                torque = tDir.cross(totalForce, new Vector3d());
                netShipForce.add(totalForce);
                netShipTorque.add((Vector3dc)torque);
            }
        }
        Matrix3d invMOI = momentOfInertia.invert(new Matrix3d());
        Vector3d deltaOmegaInLocal = invMOI.transform(shipTransform.getWorldToShip().transformDirection((Vector3dc)netShipTorque, new Vector3d()));
        double maxRotation = Math.PI * 4;
        if (deltaOmegaInLocal.length() > maxRotation) {
            netShipTorque.mul(maxRotation / deltaOmegaInLocal.length());
        }
        return new Pair((Object)netShipForce, (Object)netShipTorque);
    }
}

