/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014B'\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b2\u00103J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0004J8\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010!\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010$\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b$\u0010\"R\u001a\u0010\u000b\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010%\u001a\u0004\b&\u0010\u0004R\u001a\u0010\n\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010%\u001a\u0004\b'\u0010\u0004R\u001a\u0010)\u001a\u00020(8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010\f\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010-\u001a\u0004\b.\u0010\bR\u001a\u0010\r\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\r\u0010%\u001a\u0004\b/\u0010\u0004R\u001a\u00100\u001a\u00020(8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b0\u0010*\u001a\u0004\b1\u0010,\u00a8\u00065"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipTransformImpl;", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "Lorg/joml/Vector3dc;", "component1", "()Lorg/joml/Vector3dc;", "component2", "Lorg/joml/Quaterniondc;", "component3", "()Lorg/joml/Quaterniondc;", "component4", "positionInWorld", "positionInShip", "shipToWorldRotation", "shipToWorldScaling", "copy", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;Lorg/joml/Vector3dc;)Lorg/valkyrienskies/core/impl/game/ships/ShipTransformImpl;", "Lorg/joml/primitives/AABBdc;", "createEmptyAABB", "()Lorg/joml/primitives/AABBdc;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "directionInShip", "Lorg/joml/Vector3d;", "dest", "transformDirectionNoScalingFromShipToWorld", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "directionInWorld", "transformDirectionNoScalingFromWorldToShip", "Lorg/joml/Vector3dc;", "getPositionInShip", "getPositionInWorld", "Lorg/joml/Matrix4dc;", "shipToWorld", "Lorg/joml/Matrix4dc;", "getShipToWorld", "()Lorg/joml/Matrix4dc;", "Lorg/joml/Quaterniondc;", "getShipToWorldRotation", "getShipToWorldScaling", "worldToShip", "getWorldToShip", "<init>", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;Lorg/joml/Vector3dc;)V", "Companion", "impl"})
public final class ShipTransformImpl
implements ShipTransform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector3dc positionInWorld;
    @NotNull
    private final Vector3dc positionInShip;
    @NotNull
    private final Quaterniondc shipToWorldRotation;
    @NotNull
    private final Vector3dc shipToWorldScaling;
    @NotNull
    private final Matrix4dc shipToWorld;
    @NotNull
    private final Matrix4dc worldToShip;
    @NotNull
    private static final Quaterniondc ZERO_ROTATION = (Quaterniondc)new Quaterniond();
    @NotNull
    private static final Vector3dc UNIT_SCALING = (Vector3dc)new Vector3d(1.0, 1.0, 1.0);
    @NotNull
    private static final Vector3dc ZERO = (Vector3dc)new Vector3d();

    public ShipTransformImpl(@NotNull Vector3dc positionInWorld, @NotNull Vector3dc positionInShip, @NotNull Quaterniondc shipToWorldRotation, @NotNull Vector3dc shipToWorldScaling) {
        Intrinsics.checkNotNullParameter((Object)positionInWorld, (String)"positionInWorld");
        Intrinsics.checkNotNullParameter((Object)positionInShip, (String)"positionInShip");
        Intrinsics.checkNotNullParameter((Object)shipToWorldRotation, (String)"shipToWorldRotation");
        Intrinsics.checkNotNullParameter((Object)shipToWorldScaling, (String)"shipToWorldScaling");
        this.positionInWorld = positionInWorld;
        this.positionInShip = positionInShip;
        this.shipToWorldRotation = shipToWorldRotation;
        this.shipToWorldScaling = shipToWorldScaling;
        Matrix4d matrix4d = new Matrix4d().translate(this.getPositionInWorld()).rotate(this.getShipToWorldRotation()).scale(this.getShipToWorldScaling()).translate(-this.getPositionInShip().x(), -this.getPositionInShip().y(), -this.getPositionInShip().z());
        Intrinsics.checkNotNullExpressionValue((Object)matrix4d, (String)"Matrix4d()\n            .\u2026nInShip.z()\n            )");
        this.shipToWorld = (Matrix4dc)matrix4d;
        Matrix4d matrix4d2 = this.getShipToWorld().invert(new Matrix4d());
        Intrinsics.checkNotNullExpressionValue((Object)matrix4d2, (String)"shipToWorld.invert(Matrix4d())");
        this.worldToShip = (Matrix4dc)matrix4d2;
    }

    @NotNull
    public Vector3dc getPositionInWorld() {
        return this.positionInWorld;
    }

    @NotNull
    public Vector3dc getPositionInShip() {
        return this.positionInShip;
    }

    @NotNull
    public Quaterniondc getShipToWorldRotation() {
        return this.shipToWorldRotation;
    }

    @NotNull
    public Vector3dc getShipToWorldScaling() {
        return this.shipToWorldScaling;
    }

    @NotNull
    public Matrix4dc getShipToWorld() {
        return this.shipToWorld;
    }

    @NotNull
    public Matrix4dc getWorldToShip() {
        return this.worldToShip;
    }

    @NotNull
    public Vector3d transformDirectionNoScalingFromShipToWorld(@NotNull Vector3dc directionInShip, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)directionInShip, (String)"directionInShip");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Vector3d vector3d = this.getShipToWorldRotation().transform(directionInShip, dest);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"shipToWorldRotation.tran\u2026rm(directionInShip, dest)");
        return vector3d;
    }

    @NotNull
    public Vector3d transformDirectionNoScalingFromWorldToShip(@NotNull Vector3dc directionInWorld, @NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)directionInWorld, (String)"directionInWorld");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Vector3d vector3d = this.getShipToWorldRotation().transformInverse(directionInWorld, dest);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"shipToWorldRotation.tran\u2026e(directionInWorld, dest)");
        return vector3d;
    }

    @NotNull
    public AABBdc createEmptyAABB() {
        return (AABBdc)new AABBd(this.getPositionInWorld(), this.getPositionInWorld());
    }

    @NotNull
    public final Vector3dc component1() {
        return this.getPositionInWorld();
    }

    @NotNull
    public final Vector3dc component2() {
        return this.getPositionInShip();
    }

    @NotNull
    public final Quaterniondc component3() {
        return this.getShipToWorldRotation();
    }

    @NotNull
    public final Vector3dc component4() {
        return this.getShipToWorldScaling();
    }

    @NotNull
    public final ShipTransformImpl copy(@NotNull Vector3dc positionInWorld, @NotNull Vector3dc positionInShip, @NotNull Quaterniondc shipToWorldRotation, @NotNull Vector3dc shipToWorldScaling) {
        Intrinsics.checkNotNullParameter((Object)positionInWorld, (String)"positionInWorld");
        Intrinsics.checkNotNullParameter((Object)positionInShip, (String)"positionInShip");
        Intrinsics.checkNotNullParameter((Object)shipToWorldRotation, (String)"shipToWorldRotation");
        Intrinsics.checkNotNullParameter((Object)shipToWorldScaling, (String)"shipToWorldScaling");
        return new ShipTransformImpl(positionInWorld, positionInShip, shipToWorldRotation, shipToWorldScaling);
    }

    public static /* synthetic */ ShipTransformImpl copy$default(ShipTransformImpl shipTransformImpl, Vector3dc vector3dc, Vector3dc vector3dc2, Quaterniondc quaterniondc, Vector3dc vector3dc3, int n, Object object) {
        if ((n & 1) != 0) {
            vector3dc = shipTransformImpl.getPositionInWorld();
        }
        if ((n & 2) != 0) {
            vector3dc2 = shipTransformImpl.getPositionInShip();
        }
        if ((n & 4) != 0) {
            quaterniondc = shipTransformImpl.getShipToWorldRotation();
        }
        if ((n & 8) != 0) {
            vector3dc3 = shipTransformImpl.getShipToWorldScaling();
        }
        return shipTransformImpl.copy(vector3dc, vector3dc2, quaterniondc, vector3dc3);
    }

    @NotNull
    public String toString() {
        return "ShipTransformImpl(positionInWorld=" + this.getPositionInWorld() + ", positionInShip=" + this.getPositionInShip() + ", shipToWorldRotation=" + this.getShipToWorldRotation() + ", shipToWorldScaling=" + this.getShipToWorldScaling() + ')';
    }

    public int hashCode() {
        int result = this.getPositionInWorld().hashCode();
        result = result * 31 + this.getPositionInShip().hashCode();
        result = result * 31 + this.getShipToWorldRotation().hashCode();
        result = result * 31 + this.getShipToWorldScaling().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShipTransformImpl)) {
            return false;
        }
        ShipTransformImpl shipTransformImpl = (ShipTransformImpl)other;
        if (!Intrinsics.areEqual((Object)this.getPositionInWorld(), (Object)shipTransformImpl.getPositionInWorld())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPositionInShip(), (Object)shipTransformImpl.getPositionInShip())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getShipToWorldRotation(), (Object)shipTransformImpl.getShipToWorldRotation())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getShipToWorldScaling(), (Object)shipTransformImpl.getShipToWorldScaling());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001d\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ-\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\fJ\r\u0010\r\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u0017\u0010\u001b\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipTransformImpl$Companion;", "", "Lorg/joml/Vector3dc;", "centerCoordinateInWorld", "centerCoordinateInShip", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "create", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "Lorg/joml/Quaterniondc;", "shipRotation", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;)Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "shipScaling", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/joml/Quaterniondc;Lorg/joml/Vector3dc;)Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "createEmpty", "()Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "prevTransform", "curTransform", "", "alpha", "createFromSlerp", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;D)Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "UNIT_SCALING", "Lorg/joml/Vector3dc;", "getUNIT_SCALING", "()Lorg/joml/Vector3dc;", "ZERO", "getZERO", "ZERO_ROTATION", "Lorg/joml/Quaterniondc;", "getZERO_ROTATION", "()Lorg/joml/Quaterniondc;", "<init>", "()V", "impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Quaterniondc getZERO_ROTATION() {
            return ZERO_ROTATION;
        }

        @NotNull
        public final Vector3dc getUNIT_SCALING() {
            return UNIT_SCALING;
        }

        @NotNull
        public final Vector3dc getZERO() {
            return ZERO;
        }

        @NotNull
        public final ShipTransform createEmpty() {
            return this.create(this.getZERO(), this.getZERO());
        }

        @NotNull
        public final ShipTransform create(@NotNull Vector3dc centerCoordinateInWorld, @NotNull Vector3dc centerCoordinateInShip) {
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInWorld, (String)"centerCoordinateInWorld");
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInShip, (String)"centerCoordinateInShip");
            return this.create(centerCoordinateInWorld, centerCoordinateInShip, this.getZERO_ROTATION());
        }

        @NotNull
        public final ShipTransform create(@NotNull Vector3dc centerCoordinateInWorld, @NotNull Vector3dc centerCoordinateInShip, @NotNull Quaterniondc shipRotation) {
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInWorld, (String)"centerCoordinateInWorld");
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInShip, (String)"centerCoordinateInShip");
            Intrinsics.checkNotNullParameter((Object)shipRotation, (String)"shipRotation");
            return new ShipTransformImpl(centerCoordinateInWorld, centerCoordinateInShip, shipRotation, this.getUNIT_SCALING());
        }

        @NotNull
        public final ShipTransform create(@NotNull Vector3dc centerCoordinateInWorld, @NotNull Vector3dc centerCoordinateInShip, @NotNull Quaterniondc shipRotation, @NotNull Vector3dc shipScaling) {
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInWorld, (String)"centerCoordinateInWorld");
            Intrinsics.checkNotNullParameter((Object)centerCoordinateInShip, (String)"centerCoordinateInShip");
            Intrinsics.checkNotNullParameter((Object)shipRotation, (String)"shipRotation");
            Intrinsics.checkNotNullParameter((Object)shipScaling, (String)"shipScaling");
            return new ShipTransformImpl(centerCoordinateInWorld, centerCoordinateInShip, shipRotation, shipScaling);
        }

        @NotNull
        public final ShipTransform createFromSlerp(@NotNull ShipTransform prevTransform, @NotNull ShipTransform curTransform, double alpha) {
            Intrinsics.checkNotNullParameter((Object)prevTransform, (String)"prevTransform");
            Intrinsics.checkNotNullParameter((Object)curTransform, (String)"curTransform");
            Vector3dc newCenterCoords = curTransform.getPositionInShip();
            Vector3d centerCoordDif = curTransform.getPositionInShip().sub(prevTransform.getPositionInShip(), new Vector3d());
            Vector3d oldWorldPosWithRespectToNewCenter = prevTransform.getShipToWorld().transformDirection((Vector3dc)centerCoordDif, new Vector3d()).add(prevTransform.getPositionInWorld());
            Vector3d newWorldCoords = oldWorldPosWithRespectToNewCenter.lerp(curTransform.getPositionInWorld(), alpha, new Vector3d());
            Quaterniond newRotation = prevTransform.getShipToWorldRotation().slerp(curTransform.getShipToWorldRotation(), alpha, new Quaterniond()).normalize();
            Vector3d newScaling = prevTransform.getShipToWorldScaling().lerp(curTransform.getShipToWorldScaling(), alpha, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)newWorldCoords, (String)"newWorldCoords");
            Vector3dc vector3dc = (Vector3dc)newWorldCoords;
            Intrinsics.checkNotNullExpressionValue((Object)newRotation, (String)"newRotation");
            Quaterniondc quaterniondc = (Quaterniondc)newRotation;
            Intrinsics.checkNotNullExpressionValue((Object)newScaling, (String)"newScaling");
            return this.create(vector3dc, newCenterCoords, quaterniondc, (Vector3dc)newScaling);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

