/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.world.ServerShipWorld;
import org.valkyrienskies.core.api.world.ShipWorld;
import org.valkyrienskies.core.apigame.world.chunks.BlockType;
import org.valkyrienskies.core.impl.api.ShipInternal;
import org.valkyrienskies.core.impl.game.ChunkAllocatorProvider;
import org.valkyrienskies.core.impl.game.ships.ShipObject;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;
import org.valkyrienskies.core.impl.util.coroutines.TickableCoroutineDispatcher;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u0000 K*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u0001KB\u000f\u0012\u0006\u0010/\u001a\u00020.\u00a2\u0006\u0004\bI\u0010JJ\u000f\u0010\u0005\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ3\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\n\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J+\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\n\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019JS\u0010#\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\n\u0010\u0012\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 H\u0016\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010%\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b%\u0010\u0006R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020*0)8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0017\u00102\u001a\u0002018\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u0017\u00107\u001a\u0002068\u0006\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b9\u0010:R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000)8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010,R*\u0010C\u001a\u0012\u0012\b\u0012\u00060>j\u0002`?\u0012\u0004\u0012\u00028\u00000=8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bB\u0010\u0006\u001a\u0004\b@\u0010AR$\u0010E\u001a\u00020\f2\u0006\u0010D\u001a\u00020\f8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bE\u0010F\u001a\u0004\bG\u0010H\u00a8\u0006L"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipObjectWorld;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObject;", "ShipObjectType", "Lorg/valkyrienskies/core/api/world/ShipWorld;", "", "destroyWorld", "()V", "Lorg/joml/primitives/AABBdc;", "aabb", "", "getShipObjectsIntersecting", "(Lorg/joml/primitives/AABBdc;)Ljava/util/List;", "", "blockX", "blockY", "blockZ", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "dimensionId", "", "isBlockInShipyard", "(IIILjava/lang/String;)Z", "chunkX", "chunkZ", "isChunkInShipyard", "(IILjava/lang/String;)Z", "posX", "posY", "posZ", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;", "oldBlockType", "newBlockType", "", "oldBlockMass", "newBlockMass", "onSetBlock", "(IIILjava/lang/String;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;DD)V", "preTick", "Lorg/valkyrienskies/core/impl/util/coroutines/TickableCoroutineDispatcher;", "_dispatcher", "Lorg/valkyrienskies/core/impl/util/coroutines/TickableCoroutineDispatcher;", "Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "Lorg/valkyrienskies/core/impl/api/ShipInternal;", "getAllShips", "()Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "allShips", "Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;", "chunkAllocators", "Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;", "Lkotlinx/coroutines/CoroutineScope;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "Lkotlinx/coroutines/CoroutineDispatcher;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "getLoadedShips", "loadedShips", "", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "getShipObjects", "()Ljava/util/Map;", "getShipObjects$annotations", "shipObjects", "<set-?>", "tickNumber", "I", "getTickNumber", "()I", "<init>", "(Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;)V", "Companion", "impl"})
public abstract class ShipObjectWorld<ShipObjectType extends ShipObject>
implements ShipWorld {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChunkAllocatorProvider chunkAllocators;
    @NotNull
    private final TickableCoroutineDispatcher _dispatcher;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final CoroutineScope coroutineScope;
    private int tickNumber;
    @NotNull
    private static final Logger logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.game.ships.ShipObjectWorld$Companion.$$delegatedProperties[0]);

    public ShipObjectWorld(@NotNull ChunkAllocatorProvider chunkAllocators) {
        Intrinsics.checkNotNullParameter((Object)chunkAllocators, (String)"chunkAllocators");
        this.chunkAllocators = chunkAllocators;
        this._dispatcher = new TickableCoroutineDispatcher();
        this.dispatcher = this._dispatcher;
        this.coroutineScope = CoroutineScopeKt.plus((CoroutineScope)CoroutineScopeKt.MainScope(), (CoroutineContext)((CoroutineContext)this._dispatcher));
    }

    @NotNull
    public abstract QueryableShipData<ShipInternal> getAllShips();

    @NotNull
    public abstract QueryableShipData<ShipObjectType> getLoadedShips();

    @NotNull
    public final Map<Long, ShipObjectType> getShipObjects() {
        return this.getLoadedShips().getIdToShipData();
    }

    @Deprecated(message="use loadedShips", replaceWith=@ReplaceWith(expression="loadedShips", imports={}))
    public static /* synthetic */ void getShipObjects$annotations() {
    }

    @NotNull
    public final CoroutineDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    public final int getTickNumber() {
        return this.tickNumber;
    }

    public boolean isChunkInShipyard(int chunkX, int chunkZ, @NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        return this.chunkAllocators.forDimension(dimensionId).isChunkInShipyard(chunkX, chunkZ);
    }

    public boolean isBlockInShipyard(int blockX, int blockY, int blockZ, @NotNull String dimensionId) {
        Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
        return this.chunkAllocators.forDimension(dimensionId).isBlockInShipyard(blockX, blockY, blockZ);
    }

    public void preTick() {
        try {
            this._dispatcher.tick();
        }
        catch (Exception ex) {
            ShipObjectWorld.Companion.getLogger().error("Error while ticking ships", (Throwable)ex);
        }
        int n = this.tickNumber;
        this.tickNumber = n + 1;
    }

    public void onSetBlock(int posX, int posY, int posZ, @NotNull String dimensionId, @NotNull BlockType oldBlockType, @NotNull BlockType newBlockType, double oldBlockMass, double newBlockMass) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)dimensionId, (String)"dimensionId");
            Intrinsics.checkNotNullParameter((Object)oldBlockType, (String)"oldBlockType");
            Intrinsics.checkNotNullParameter((Object)newBlockType, (String)"newBlockType");
            ShipInternal shipInternal = (ShipInternal)this.getAllShips().getByChunkPos(posX >> 4, posZ >> 4, dimensionId);
            if (shipInternal == null) break block0;
            shipInternal.onSetBlock(posX, posY, posZ, oldBlockType, newBlockType, oldBlockMass, newBlockMass, this instanceof ServerShipWorld);
        }
    }

    @Deprecated(message="redundant", replaceWith=@ReplaceWith(expression="loadedShips.getShipDataIntersecting(aabb)", imports={}))
    @NotNull
    public List<ShipObjectType> getShipObjectsIntersecting(@NotNull AABBdc aabb) {
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        return CollectionsKt.toList((Iterable)this.getLoadedShips().getShipDataIntersecting(aabb));
    }

    public abstract void destroyWorld();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u001b\u0010\u0007\u001a\u00020\u00028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipObjectWorld$Companion;", "", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V", "impl"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

