/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import java.net.SocketAddress;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.ships.MutableQueryableShipData;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.core.impl.game.ChunkAllocatorProvider;
import org.valkyrienskies.core.impl.game.ships.QueryableShipDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClient;
import org.valkyrienskies.core.impl.game.ships.ShipObjectWorld;
import org.valkyrienskies.core.impl.game.ships.networking.ShipObjectNetworkManagerClient;
import org.valkyrienskies.core.impl.hooks.VSEvents;
import org.valkyrienskies.core.impl.util.WorldScoped;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\b\u0007\u0012\u0006\u0010)\u001a\u00020(\u0012\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0019\u0010\u000f\u001a\u00020\u00062\n\u0010\u000e\u001a\u00060\fj\u0002`\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010!\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001eR\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006."}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClientWorld;", "Lorg/valkyrienskies/core/apigame/world/ClientShipWorldCore;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectWorld;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClient;", "Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "ship", "", "addShip", "(Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;)V", "destroyWorld", "()V", "postTick", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipId", "removeShip", "(J)V", "Ljava/net/SocketAddress;", "server", "tickNetworking", "(Ljava/net/SocketAddress;)V", "", "partialTicks", "updateRenderTransforms", "(D)V", "Lorg/valkyrienskies/core/apigame/ships/MutableQueryableShipData;", "_loadedShips", "Lorg/valkyrienskies/core/apigame/ships/MutableQueryableShipData;", "Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "getAllShips", "()Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "allShips", "", "isSyncedWithServer", "()Z", "getLoadedShips", "loadedShips", "Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerClient;", "networkManager", "Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerClient;", "Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerClient$Factory;", "networkManagerFactory", "Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;", "chunkAllocators", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/networking/ShipObjectNetworkManagerClient$Factory;Lorg/valkyrienskies/core/impl/game/ChunkAllocatorProvider;)V", "impl"})
@WorldScoped
public final class ShipObjectClientWorld
extends ShipObjectWorld<ShipObjectClient>
implements ClientShipWorldCore {
    @NotNull
    private final MutableQueryableShipData<ShipObjectClient> _loadedShips;
    @NotNull
    private final ShipObjectNetworkManagerClient networkManager;

    @Inject
    public ShipObjectClientWorld(@NotNull ShipObjectNetworkManagerClient.Factory networkManagerFactory, @NotNull ChunkAllocatorProvider chunkAllocators) {
        Intrinsics.checkNotNullParameter((Object)networkManagerFactory, (String)"networkManagerFactory");
        Intrinsics.checkNotNullParameter((Object)chunkAllocators, (String)"chunkAllocators");
        super(chunkAllocators);
        this._loadedShips = new QueryableShipDataImpl(null, 1, null);
        this.networkManager = networkManagerFactory.make(this);
        this.networkManager.registerPacketListeners();
    }

    @Override
    @NotNull
    public QueryableShipData<ShipObjectClient> getAllShips() {
        return this.getLoadedShips();
    }

    @Override
    public boolean isSyncedWithServer() {
        return this.networkManager.getHasReceivedInitialShips();
    }

    @Override
    @NotNull
    public QueryableShipData<ShipObjectClient> getLoadedShips() {
        return this._loadedShips;
    }

    public final void addShip(@NotNull ShipDataCommon ship) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        ShipObjectClient shipObject = new ShipObjectClient(ship, null, 2, null);
        this._loadedShips.addShipData((ShipObjectClient)((Ship)shipObject));
        VSEvents.INSTANCE.getShipLoadEventClient().emit(new VSEvents.ShipLoadEventClient(shipObject));
    }

    public final void removeShip(long shipId) {
        this._loadedShips.removeShipData(shipId);
    }

    @Override
    public void tickNetworking(@NotNull SocketAddress server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.networkManager.tick(server);
    }

    @Override
    public void postTick() {
        super.preTick();
        Iterable $this$forEach$iv = (Iterable)this.getLoadedShips();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShipObjectClient it = (ShipObjectClient)element$iv;
            boolean bl = false;
            it.tickUpdateShipTransform();
        }
    }

    @Override
    public void updateRenderTransforms(double partialTicks) {
        Iterable $this$forEach$iv = (Iterable)this.getLoadedShips();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShipObjectClient it = (ShipObjectClient)element$iv;
            boolean bl = false;
            it.updateRenderShipTransform(partialTicks);
        }
    }

    @Override
    public void destroyWorld() {
        this.networkManager.onDestroy();
    }
}

