/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.chunks.BlockType;
import org.valkyrienskies.core.impl.api.ServerShipInternal;
import org.valkyrienskies.core.impl.api.ServerShipUser;
import org.valkyrienskies.core.impl.chunk_tracking.ShipActiveChunksSet;
import org.valkyrienskies.core.impl.datastructures.DynamicBlockPosSetAABB;
import org.valkyrienskies.core.impl.datastructures.IBlockPosSetAABB;
import org.valkyrienskies.core.impl.game.BlockTypeImpl;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.game.ships.ShipInertiaDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipPhysicsData;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.impl.util.serialization.PacketIgnore;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 V2\u00020\u00012\u00020\u0002:\u0001VB\u0085\u0001\u0012\n\u0010C\u001a\u00060Aj\u0002`B\u0012\b\u0010E\u001a\u0004\u0018\u00010D\u0012\u0006\u0010G\u001a\u00020F\u0012\n\u0010I\u001a\u00060Dj\u0002`H\u0012\u0006\u0010K\u001a\u00020J\u0012\u0006\u0010'\u001a\u00020&\u0012\u0006\u0010M\u001a\u00020L\u0012\u0006\u0010N\u001a\u00020L\u0012\u0006\u0010P\u001a\u00020O\u0012\b\u0010R\u001a\u0004\u0018\u00010Q\u0012\u0006\u0010S\u001a\u00020/\u0012\b\b\u0002\u0010+\u001a\u00020\u0003\u0012\u000e\b\u0002\u00104\u001a\b\u0012\u0004\u0012\u00020302\u00a2\u0006\u0004\bT\u0010UJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u000b\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012JO\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0012J-\u0010!\u001a\u00020\u0010\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\b\u0010 \u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b!\u0010\"J/\u0010$\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b$\u0010%R\u001a\u0010'\u001a\u00020&8\u0016X\u0097\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\"\u0010+\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b+\u0010\u0005\"\u0004\b-\u0010.R\u0014\u00100\u001a\u00020/8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001d\u00104\u001a\b\u0012\u0004\u0012\u000203028\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R\u0014\u00109\u001a\u0002088\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0014\u0010>\u001a\u00020;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0014\u0010@\u001a\u00020;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010=\u00a8\u0006W"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "Lorg/valkyrienskies/core/impl/api/ServerShipInternal;", "", "areVoxelsFullyLoaded", "()Z", "asShipDataCommon", "()Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "T", "Ljava/lang/Class;", "clazz", "getAttachment", "(Ljava/lang/Class;)Ljava/lang/Object;", "", "chunkX", "chunkZ", "", "onLoadChunk", "(II)V", "posX", "posY", "posZ", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;", "oldBlockType", "newBlockType", "", "oldBlockMass", "newBlockMass", "isRunningOnServer", "onSetBlock", "(IIILorg/valkyrienskies/core/apigame/world/chunks/BlockType;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;DDZ)V", "onUnloadChunk", "value", "saveAttachment", "(Ljava/lang/Class;Ljava/lang/Object;)V", "set", "updateShipAABBGenerator", "(IIIZ)V", "Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "inertiaData", "Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "getInertiaData", "()Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "isStatic", "Z", "setStatic", "(Z)V", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "missingLoadedChunks", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "Lcom/google/common/collect/MutableClassToInstanceMap;", "", "persistentAttachedData", "Lcom/google/common/collect/MutableClassToInstanceMap;", "getPersistentAttachedData", "()Lcom/google/common/collect/MutableClassToInstanceMap;", "Lorg/valkyrienskies/core/impl/datastructures/IBlockPosSetAABB;", "shipAABBGenerator", "Lorg/valkyrienskies/core/impl/datastructures/IBlockPosSetAABB;", "Lorg/joml/Matrix4dc;", "getShipToWorld", "()Lorg/joml/Matrix4dc;", "shipToWorld", "getWorldToShip", "worldToShip", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "id", "", "slug", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "chunkClaim", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "chunkClaimDimension", "Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;", "physicsData", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "shipTransform", "prevTickShipTransform", "Lorg/joml/primitives/AABBdc;", "shipAABB", "Lorg/joml/primitives/AABBic;", "shipVoxelAABB", "shipActiveChunksSet", "<init>", "(JLjava/lang/String;Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;Ljava/lang/String;Lorg/valkyrienskies/core/impl/game/ships/ShipPhysicsData;Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/joml/primitives/AABBdc;Lorg/joml/primitives/AABBic;Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;ZLcom/google/common/collect/MutableClassToInstanceMap;)V", "Companion", "impl"})
public final class ShipData
extends ShipDataCommon
implements ServerShipInternal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @PacketIgnore
    @NotNull
    private final ShipInertiaDataImpl inertiaData;
    private boolean isStatic;
    @NotNull
    private final MutableClassToInstanceMap<Object> persistentAttachedData;
    @JsonIgnore
    @NotNull
    private final IShipActiveChunksSet missingLoadedChunks;
    @JsonIgnore
    @NotNull
    private final IBlockPosSetAABB shipAABBGenerator;

    public ShipData(long id, @Nullable String slug, @NotNull ChunkClaim chunkClaim, @NotNull String chunkClaimDimension, @NotNull ShipPhysicsData physicsData, @NotNull ShipInertiaDataImpl inertiaData, @NotNull ShipTransform shipTransform, @NotNull ShipTransform prevTickShipTransform, @NotNull AABBdc shipAABB, @Nullable AABBic shipVoxelAABB, @NotNull IShipActiveChunksSet shipActiveChunksSet, boolean isStatic, @NotNull MutableClassToInstanceMap<Object> persistentAttachedData) {
        Intrinsics.checkNotNullParameter((Object)chunkClaim, (String)"chunkClaim");
        Intrinsics.checkNotNullParameter((Object)chunkClaimDimension, (String)"chunkClaimDimension");
        Intrinsics.checkNotNullParameter((Object)physicsData, (String)"physicsData");
        Intrinsics.checkNotNullParameter((Object)inertiaData, (String)"inertiaData");
        Intrinsics.checkNotNullParameter((Object)shipTransform, (String)"shipTransform");
        Intrinsics.checkNotNullParameter((Object)prevTickShipTransform, (String)"prevTickShipTransform");
        Intrinsics.checkNotNullParameter((Object)shipAABB, (String)"shipAABB");
        Intrinsics.checkNotNullParameter((Object)shipActiveChunksSet, (String)"shipActiveChunksSet");
        Intrinsics.checkNotNullParameter(persistentAttachedData, (String)"persistentAttachedData");
        super(id, slug, chunkClaim, chunkClaimDimension, physicsData, shipTransform, prevTickShipTransform, shipAABB, shipVoxelAABB, shipActiveChunksSet);
        this.inertiaData = inertiaData;
        this.isStatic = isStatic;
        this.persistentAttachedData = persistentAttachedData;
        this.missingLoadedChunks = ShipActiveChunksSet.Companion.create();
        this.shipAABBGenerator = new DynamicBlockPosSetAABB(null, 1, null);
        shipActiveChunksSet.forEach((arg_0, arg_1) -> ShipData._init_$lambda$0(this, arg_0, arg_1));
        for (Map.Entry attachment : ((Map)this.persistentAttachedData).entrySet()) {
            if (!ServerShipUser.class.isAssignableFrom((Class)attachment.getKey()) || attachment.getValue() == null) continue;
            Object v = attachment.getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.api.ServerShipUser");
            if (((ServerShipUser)v).getShip() != null) continue;
            Object v2 = attachment.getValue();
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.api.ServerShipUser");
            ((ServerShipUser)v2).setShip(this);
        }
    }

    public /* synthetic */ ShipData(long l, String string, ChunkClaim chunkClaim, String string2, ShipPhysicsData shipPhysicsData, ShipInertiaDataImpl shipInertiaDataImpl, ShipTransform shipTransform, ShipTransform shipTransform2, AABBdc aABBdc, AABBic aABBic, IShipActiveChunksSet iShipActiveChunksSet, boolean bl, MutableClassToInstanceMap mutableClassToInstanceMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x800) != 0) {
            bl = false;
        }
        if ((n & 0x1000) != 0) {
            MutableClassToInstanceMap mutableClassToInstanceMap2 = MutableClassToInstanceMap.create();
            Intrinsics.checkNotNullExpressionValue((Object)mutableClassToInstanceMap2, (String)"create()");
            mutableClassToInstanceMap = mutableClassToInstanceMap2;
        }
        this(l, string, chunkClaim, string2, shipPhysicsData, shipInertiaDataImpl, shipTransform, shipTransform2, aABBdc, aABBic, iShipActiveChunksSet, bl, (MutableClassToInstanceMap<Object>)mutableClassToInstanceMap);
    }

    @NotNull
    public ShipInertiaDataImpl getInertiaData() {
        return this.inertiaData;
    }

    public final boolean isStatic() {
        return this.isStatic;
    }

    public final void setStatic(boolean bl) {
        this.isStatic = bl;
    }

    @NotNull
    public final MutableClassToInstanceMap<Object> getPersistentAttachedData() {
        return this.persistentAttachedData;
    }

    @Override
    @NotNull
    public Matrix4dc getShipToWorld() {
        return this.getTransform().getShipToWorld();
    }

    @Override
    @NotNull
    public Matrix4dc getWorldToShip() {
        return this.getTransform().getWorldToShip();
    }

    @Override
    public void onSetBlock(int posX, int posY, int posZ, @NotNull BlockType oldBlockType, @NotNull BlockType newBlockType, double oldBlockMass, double newBlockMass, boolean isRunningOnServer) {
        Intrinsics.checkNotNullParameter((Object)oldBlockType, (String)"oldBlockType");
        Intrinsics.checkNotNullParameter((Object)newBlockType, (String)"newBlockType");
        super.onSetBlock(posX, posY, posZ, oldBlockType, newBlockType, oldBlockMass, newBlockMass, isRunningOnServer);
        this.getInertiaData().onSetBlockUseSphereMOI(posX, posY, posZ, oldBlockMass, newBlockMass);
        if (isRunningOnServer) {
            this.updateShipAABBGenerator(posX, posY, posZ, !Intrinsics.areEqual((Object)newBlockType, (Object)BlockTypeImpl.Companion.getAIR()));
        }
    }

    @Override
    public void updateShipAABBGenerator(int posX, int posY, int posZ, boolean set) {
        if (set) {
            this.shipAABBGenerator.add(posX, posY, posZ);
        } else {
            this.shipAABBGenerator.remove(posX, posY, posZ);
        }
        AABBi rawVoxelAABB = this.shipAABBGenerator.makeAABB();
        if (rawVoxelAABB != null) {
            ++rawVoxelAABB.maxX;
            ++rawVoxelAABB.maxY;
            ++rawVoxelAABB.maxZ;
        }
        this.setShipAABB((AABBic)rawVoxelAABB);
    }

    @Override
    public void onLoadChunk(int chunkX, int chunkZ) {
        if (this.getChunkClaim().contains(chunkX, chunkZ)) {
            this.missingLoadedChunks.remove(chunkX, chunkZ);
        }
    }

    @Override
    public void onUnloadChunk(int chunkX, int chunkZ) {
        if (this.getChunkClaim().contains(chunkX, chunkZ) && this.getActiveChunksSet().contains(chunkX, chunkZ)) {
            this.missingLoadedChunks.add(chunkX, chunkZ);
        }
    }

    @Override
    public boolean areVoxelsFullyLoaded() {
        return this.missingLoadedChunks.getSize() == 0;
    }

    @Override
    @NotNull
    public ShipDataCommon asShipDataCommon() {
        return this;
    }

    public <T> void saveAttachment(@NotNull Class<T> clazz, @Nullable T value) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (value instanceof ServerShipUser && ((ServerShipUser)value).getShip() == null) {
            ((ServerShipUser)value).setShip(this);
        }
        if (value == null) {
            this.persistentAttachedData.remove(clazz);
        } else {
            ((Map)this.persistentAttachedData).put(clazz, value);
        }
    }

    @Nullable
    public <T> T getAttachment(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)this.persistentAttachedData.getInstance(clazz);
    }

    private static final void _init_$lambda$0(ShipData this$0, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.missingLoadedChunks.add(chunkX, chunkZ);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016JY\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00022\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\b\u001a\u00020\u00072\n\u0010\n\u001a\u00060\u0002j\u0002`\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipData$Companion;", "", "", "slug", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipId", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "chunkClaim", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "chunkClaimDimension", "Lorg/joml/Vector3dc;", "shipCenterInWorldCoordinates", "shipCenterInShipCoordinates", "", "scaling", "", "isStatic", "Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "createEmpty", "(Ljava/lang/String;JLorg/valkyrienskies/core/api/ships/properties/ChunkClaim;Ljava/lang/String;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;DZ)Lorg/valkyrienskies/core/impl/game/ships/ShipData;", "<init>", "()V", "impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShipData createEmpty(@NotNull String slug, long shipId, @NotNull ChunkClaim chunkClaim, @NotNull String chunkClaimDimension, @NotNull Vector3dc shipCenterInWorldCoordinates, @NotNull Vector3dc shipCenterInShipCoordinates, double scaling, boolean isStatic) {
            Intrinsics.checkNotNullParameter((Object)slug, (String)"slug");
            Intrinsics.checkNotNullParameter((Object)chunkClaim, (String)"chunkClaim");
            Intrinsics.checkNotNullParameter((Object)chunkClaimDimension, (String)"chunkClaimDimension");
            Intrinsics.checkNotNullParameter((Object)shipCenterInWorldCoordinates, (String)"shipCenterInWorldCoordinates");
            Intrinsics.checkNotNullParameter((Object)shipCenterInShipCoordinates, (String)"shipCenterInShipCoordinates");
            Quaterniond quaterniond = new Quaterniond().fromAxisAngleDeg(0.0, 1.0, 0.0, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)quaterniond, (String)"Quaterniond().fromAxisAngleDeg(0.0, 1.0, 0.0, 0.0)");
            ShipTransform shipTransform = ShipTransformImpl.Companion.create(shipCenterInWorldCoordinates, shipCenterInShipCoordinates, (Quaterniondc)quaterniond, (Vector3dc)new Vector3d(scaling));
            return new ShipData(shipId, slug, chunkClaim, chunkClaimDimension, ShipPhysicsData.Companion.createEmpty(), ShipInertiaDataImpl.Companion.newEmptyShipInertiaData(), shipTransform, shipTransform, shipTransform.createEmptyAABB(), null, ShipActiveChunksSet.Companion.create(), isStatic, null, 4096, null);
        }

        public static /* synthetic */ ShipData createEmpty$default(Companion companion, String string, long l, ChunkClaim chunkClaim, String string2, Vector3dc vector3dc, Vector3dc vector3dc2, double d, boolean bl, int n, Object object) {
            if ((n & 0x40) != 0) {
                d = 1.0;
            }
            if ((n & 0x80) != 0) {
                bl = false;
            }
            return companion.createEmpty(string, l, chunkClaim, string2, vector3dc, vector3dc2, d, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

