/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.chunks.BlockType;
import org.valkyrienskies.core.impl.api.ShipInternal;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.util.AABBdUtilKt;
import org.valkyrienskies.core.impl.util.serialization.DeltaIgnore;
import org.valkyrienskies.core.impl.util.serialization.PacketIgnore;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\bP\u0010QJ\u001a\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJO\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010 \u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010%\u001a\u00060!j\u0002`\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0018\u0010-\u001a\u00060)j\u0002`*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u00101\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R$\u00104\u001a\u0002022\u0006\u00103\u001a\u0002028\u0016@RX\u0097\u000e\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R\u0016\u0010;\u001a\u0004\u0018\u0001088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0014\u0010?\u001a\u00020<8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0016\u0010A\u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010$R*\u0010C\u001a\u0002022\u0006\u0010B\u001a\u0002028\u0016@VX\u0097\u000e\u00a2\u0006\u0012\n\u0004\bC\u00105\u001a\u0004\bD\u00107\"\u0004\bE\u0010FR\u0014\u0010H\u001a\u00020.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u00100R$\u0010J\u001a\u00020I2\u0006\u00103\u001a\u00020I8\u0016@RX\u0097\u000e\u00a2\u0006\f\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010MR\u0014\u0010O\u001a\u00020<8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010>\u00a8\u0006R"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/AbstractUnloadedShip;", "Lorg/valkyrienskies/core/impl/api/ShipInternal;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "posX", "posY", "posZ", "Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;", "oldBlockType", "newBlockType", "", "oldBlockMass", "newBlockMass", "isRunningOnServer", "", "onSetBlock", "(IIILorg/valkyrienskies/core/apigame/world/chunks/BlockType;Lorg/valkyrienskies/core/apigame/world/chunks/BlockType;DDZ)V", "updatePrevTickShipTransform", "()V", "Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "getActiveChunksSet", "()Lorg/valkyrienskies/core/api/ships/properties/IShipActiveChunksSet;", "activeChunksSet", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "getChunkClaim", "()Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "chunkClaim", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "getChunkClaimDimension", "()Ljava/lang/String;", "chunkClaimDimension", "Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "data", "Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "getId", "()J", "id", "Lorg/joml/Vector3dc;", "getOmega", "()Lorg/joml/Vector3dc;", "omega", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "<set-?>", "prevTickTransform", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "getPrevTickTransform", "()Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "Lorg/joml/primitives/AABBic;", "getShipAABB", "()Lorg/joml/primitives/AABBic;", "shipAABB", "Lorg/joml/Matrix4dc;", "getShipToWorld", "()Lorg/joml/Matrix4dc;", "shipToWorld", "getSlug", "slug", "shipTransform", "transform", "getTransform", "setTransform", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;)V", "getVelocity", "velocity", "Lorg/joml/primitives/AABBdc;", "worldAABB", "Lorg/joml/primitives/AABBdc;", "getWorldAABB", "()Lorg/joml/primitives/AABBdc;", "getWorldToShip", "worldToShip", "<init>", "(Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;)V", "impl"})
public final class AbstractUnloadedShip
implements ShipInternal {
    @NotNull
    private final ShipDataCommon data;
    @DeltaIgnore
    @NotNull
    private ShipTransform transform;
    @PacketIgnore
    @NotNull
    private ShipTransform prevTickTransform;
    @DeltaIgnore
    @NotNull
    private AABBdc worldAABB;

    public AbstractUnloadedShip(@NotNull ShipDataCommon data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.transform = this.getShipTransform();
        this.prevTickTransform = this.data.getPrevTickTransform();
        this.worldAABB = this.data.getWorldAABB();
    }

    @NotNull
    public Vector3dc getVelocity() {
        return this.data.getPhysicsData().getLinearVelocity();
    }

    @NotNull
    public Vector3dc getOmega() {
        return this.data.getPhysicsData().getAngularVelocity();
    }

    @NotNull
    public IShipActiveChunksSet getActiveChunksSet() {
        return this.data.getActiveChunksSet();
    }

    public long getId() {
        return this.data.getId();
    }

    @Nullable
    public String getSlug() {
        return this.data.getSlug();
    }

    @NotNull
    public ShipTransform getTransform() {
        return this.transform;
    }

    public void setTransform(@NotNull ShipTransform shipTransform) {
        Intrinsics.checkNotNullParameter((Object)shipTransform, (String)"shipTransform");
        this.transform = shipTransform;
        AABBic aABBic = this.getShipAABB();
        AABBd aABBd = aABBic != null && (aABBic = AABBdUtilKt.toAABBd(aABBic, new AABBd())) != null ? aABBic.transform(shipTransform.getShipToWorld(), new AABBd()) : null;
        this.worldAABB = aABBd == null ? shipTransform.createEmptyAABB() : (AABBdc)aABBd;
    }

    @NotNull
    public ShipTransform getPrevTickTransform() {
        return this.prevTickTransform;
    }

    @NotNull
    public ChunkClaim getChunkClaim() {
        return this.data.getChunkClaim();
    }

    @NotNull
    public String getChunkClaimDimension() {
        return this.data.getChunkClaimDimension();
    }

    @NotNull
    public AABBdc getWorldAABB() {
        return this.worldAABB;
    }

    @Nullable
    public AABBic getShipAABB() {
        return this.data.getShipAABB();
    }

    public final void updatePrevTickShipTransform() {
        this.prevTickTransform = this.getTransform();
    }

    @Override
    public void onSetBlock(int posX, int posY, int posZ, @NotNull BlockType oldBlockType, @NotNull BlockType newBlockType, double oldBlockMass, double newBlockMass, boolean isRunningOnServer) {
        Intrinsics.checkNotNullParameter((Object)oldBlockType, (String)"oldBlockType");
        Intrinsics.checkNotNullParameter((Object)newBlockType, (String)"newBlockType");
        if (!this.getChunkClaim().contains(posX >> 4, posZ >> 4)) {
            boolean bl = false;
            String string = "Block at <" + posX + ", " + posY + ", " + posZ + "> is not in the chunk claim belonging to " + this;
            throw new IllegalArgumentException(string.toString());
        }
        this.getActiveChunksSet().add(posX >> 4, posZ >> 4);
        this.getActiveChunksSet().add((posX >> 4) - 1, posZ >> 4);
        this.getActiveChunksSet().add((posX >> 4) + 1, posZ >> 4);
        this.getActiveChunksSet().add(posX >> 4, (posZ >> 4) - 1);
        this.getActiveChunksSet().add(posX >> 4, (posZ >> 4) + 1);
    }

    @NotNull
    public Matrix4dc getShipToWorld() {
        return this.getTransform().getShipToWorld();
    }

    @NotNull
    public Matrix4dc getWorldToShip() {
        return this.getTransform().getWorldToShip();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.game.ships.ShipDataCommon");
        ShipDataCommon cfr_ignored_0 = (ShipDataCommon)other;
        return this.getId() == ((ShipDataCommon)other).getId();
    }

    public int hashCode() {
        return Long.hashCode(this.getId());
    }
}

