/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.primitives.AABBi;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.core.api.world.LevelYRange;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIncludeProperties(value={"xIndex", "zIndex"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0087\b\u0018\u0000 72\u00020\u0001:\u00017B\u0017\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b5\u00106J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ$\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0004J\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010\"\u001a\u00020!H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010\u0004R\u001a\u0010'\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b'\u0010%\u001a\u0004\b(\u0010\u0004R\u001a\u0010\u000b\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010%\u001a\u0004\b)\u0010\u0004R\u001a\u0010*\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b*\u0010%\u001a\u0004\b+\u0010\u0004R\u001a\u0010,\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b,\u0010%\u001a\u0004\b-\u0010\u0004R\u001a\u0010.\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b.\u0010%\u001a\u0004\b/\u0010\u0004R\u001a\u0010\f\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010%\u001a\u0004\b0\u0010\u0004R\u001a\u00101\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b1\u0010%\u001a\u0004\b2\u0010\u0004R\u001a\u00103\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b3\u0010%\u001a\u0004\b4\u0010\u0004\u00a8\u00068"}, d2={"Lorg/valkyrienskies/core/impl/game/ChunkClaimImpl;", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "", "component1", "()I", "component2", "x", "z", "", "contains", "(II)Z", "xIndex", "zIndex", "copy", "(II)Lorg/valkyrienskies/core/impl/game/ChunkClaimImpl;", "", "other", "equals", "(Ljava/lang/Object;)Z", "Lorg/valkyrienskies/core/api/world/LevelYRange;", "yRange", "Lorg/joml/Vector3i;", "destination", "getBlockSize", "(Lorg/valkyrienskies/core/api/world/LevelYRange;Lorg/joml/Vector3i;)Lorg/joml/Vector3i;", "getCenterBlockCoordinates", "Lorg/joml/primitives/AABBi;", "getTotalVoxelRegion", "(Lorg/valkyrienskies/core/api/world/LevelYRange;Lorg/joml/primitives/AABBi;)Lorg/joml/primitives/AABBi;", "hashCode", "", "toLong", "()J", "", "toString", "()Ljava/lang/String;", "size", "I", "getSize", "xEnd", "getXEnd", "getXIndex", "xMiddle", "getXMiddle", "xStart", "getXStart", "zEnd", "getZEnd", "getZIndex", "zMiddle", "getZMiddle", "zStart", "getZStart", "<init>", "(II)V", "Companion", "impl"})
public final class ChunkClaimImpl
implements ChunkClaim {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int xIndex;
    private final int zIndex;
    private final int xStart;
    private final int xEnd;
    private final int zStart;
    private final int zEnd;
    private final int xMiddle;
    private final int zMiddle;
    private final int size;

    public ChunkClaimImpl(int xIndex, int zIndex) {
        this.xIndex = xIndex;
        this.zIndex = zIndex;
        this.xStart = this.getXIndex() * 256;
        this.xEnd = this.getXIndex() * 256 + 256 - 1;
        this.zStart = this.getZIndex() * 256;
        this.zEnd = this.getZIndex() * 256 + 256 - 1;
        this.xMiddle = this.getXStart() + 128;
        this.zMiddle = this.getZStart() + 128;
        this.size = (this.getXEnd() - this.getXStart() + 1) * (this.getZEnd() - this.getZStart() + 1);
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public int getXStart() {
        return this.xStart;
    }

    public int getXEnd() {
        return this.xEnd;
    }

    public int getZStart() {
        return this.zStart;
    }

    public int getZEnd() {
        return this.zEnd;
    }

    public int getXMiddle() {
        return this.xMiddle;
    }

    public int getZMiddle() {
        return this.zMiddle;
    }

    public int getSize() {
        return this.size;
    }

    public long toLong() {
        return ChunkClaim.Companion.claimToLong(this.getXIndex(), this.getZIndex());
    }

    public boolean contains(int x, int z) {
        int n = this.getXStart();
        boolean bl = x <= this.getXEnd() ? n <= x : false;
        n = this.getZStart();
        return bl & (z <= this.getZEnd() ? n <= z : false);
    }

    @NotNull
    public Vector3i getCenterBlockCoordinates(@NotNull LevelYRange yRange, @NotNull Vector3i destination) {
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        int minBlockX = this.getXStart() << 4;
        int maxBlockX = (this.getXEnd() << 4) + 15;
        int minBlockZ = this.getZStart() << 4;
        int maxBlockZ = (this.getZEnd() << 4) + 15;
        int centerX = (minBlockX + maxBlockX) / 2;
        int centerY = yRange.getCenter();
        int centerZ = (minBlockZ + maxBlockZ) / 2;
        Vector3i vector3i = destination.set(centerX, centerY, centerZ);
        Intrinsics.checkNotNullExpressionValue((Object)vector3i, (String)"destination.set(centerX, centerY, centerZ)");
        return vector3i;
    }

    @NotNull
    public Vector3i getBlockSize(@NotNull LevelYRange yRange, @NotNull Vector3i destination) {
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        int xSize = (this.getXEnd() - this.getXStart() + 1) * 16;
        int ySize = 256;
        int zSize = (this.getZEnd() - this.getZStart() + 1) * 16;
        Vector3i vector3i = destination.set(xSize, ySize, zSize);
        Intrinsics.checkNotNullExpressionValue((Object)vector3i, (String)"destination.set(xSize, ySize, zSize)");
        return vector3i;
    }

    @NotNull
    public AABBi getTotalVoxelRegion(@NotNull LevelYRange yRange, @NotNull AABBi destination) {
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        destination.minX = this.getXStart() << 4;
        destination.minY = yRange.getMinY();
        destination.minZ = this.getZStart() << 4;
        destination.maxX = (this.getXEnd() << 4) + 15;
        destination.maxY = yRange.getMaxY();
        destination.maxZ = (this.getZEnd() << 4) + 15;
        return destination;
    }

    public final int component1() {
        return this.getXIndex();
    }

    public final int component2() {
        return this.getZIndex();
    }

    @NotNull
    public final ChunkClaimImpl copy(int xIndex, int zIndex) {
        return new ChunkClaimImpl(xIndex, zIndex);
    }

    public static /* synthetic */ ChunkClaimImpl copy$default(ChunkClaimImpl chunkClaimImpl, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = chunkClaimImpl.getXIndex();
        }
        if ((n3 & 2) != 0) {
            n2 = chunkClaimImpl.getZIndex();
        }
        return chunkClaimImpl.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "ChunkClaimImpl(xIndex=" + this.getXIndex() + ", zIndex=" + this.getZIndex() + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.getXIndex());
        result = result * 31 + Integer.hashCode(this.getZIndex());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChunkClaimImpl)) {
            return false;
        }
        ChunkClaimImpl chunkClaimImpl = (ChunkClaimImpl)other;
        if (this.getXIndex() != chunkClaimImpl.getXIndex()) {
            return false;
        }
        return this.getZIndex() == chunkClaimImpl.getZIndex();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/core/impl/game/ChunkClaimImpl$Companion;", "", "", "chunkX", "chunkZ", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "getClaim", "(II)Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "<init>", "()V", "impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChunkClaim getClaim(int chunkX, int chunkZ) {
            return new ChunkClaimImpl(ChunkClaim.Companion.getClaimXIndex(chunkX), ChunkClaim.Companion.getClaimZIndex(chunkZ));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

