/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.datastructures;

public class FastMinMaxMap {
    private final int[] backing;
    private final int capacity;
    private int front;
    private int back;
    private int size;

    public FastMinMaxMap(int capacity) {
        this.backing = new int[capacity * 3];
        this.capacity = capacity;
        this.front = -1;
        this.back = -1;
        this.size = 0;
        this.clear();
    }

    public void increment(int key) throws IllegalArgumentException {
        int curValue = this.getValue(key);
        if (this.size == 0) {
            this.front = this.back = key;
            this.setPrev(key, -1);
            this.setNext(key, -1);
        } else if (curValue == 0) {
            if (key < this.front) {
                this.setPrev(this.front, key);
                this.setNext(key, this.front);
                this.front = key;
            } else if (key > this.back) {
                this.setNext(this.back, key);
                this.setPrev(key, this.back);
                this.back = key;
            } else {
                int leftKey = -1;
                for (int i = key - 1; i >= 0; --i) {
                    if (this.getValue(i) == 0) continue;
                    leftKey = i;
                    break;
                }
                int leftsNext = this.getNext(leftKey);
                this.setNext(key, leftsNext);
                this.setPrev(key, leftKey);
                this.setNext(leftKey, key);
                this.setPrev(leftsNext, key);
            }
        }
        this.setValue(key, curValue + 1);
        ++this.size;
    }

    public void decrement(int key) throws IllegalArgumentException {
        if (this.size <= 0) {
            throw new IllegalArgumentException("Cannot decrement when list is empty");
        }
        int curValue = this.getValue(key);
        if (curValue <= 0) {
            throw new IllegalArgumentException("Cannot store negative values");
        }
        if (curValue == 1) {
            if (this.size == 1) {
                this.setNext(key, -1);
                this.setPrev(key, -1);
                this.front = -1;
                this.back = -1;
            } else if (key == this.front) {
                int frontNext = this.getNext(this.front);
                this.setNext(this.front, -1);
                this.setPrev(frontNext, -1);
                this.front = frontNext;
            } else if (key == this.back) {
                int backPrev = this.getPrev(this.back);
                this.setPrev(this.back, -1);
                this.setNext(backPrev, -1);
                this.back = backPrev;
            } else {
                int prevPtr = this.getPrev(key);
                int nextPtr = this.getNext(key);
                this.setNext(prevPtr, nextPtr);
                this.setPrev(nextPtr, prevPtr);
            }
            this.setValue(key, 0);
        } else {
            this.setValue(key, curValue - 1);
        }
        --this.size;
    }

    private void setValue(int key, int value) {
        this.ensureCapacity(key * 3);
        this.backing[key * 3] = value;
    }

    private void setPrev(int key, int prev2) {
        this.ensureCapacity(key * 3 + 1);
        this.backing[key * 3 + 1] = prev2;
    }

    private void setNext(int key, int next) {
        this.ensureCapacity(key * 3 + 2);
        this.backing[key * 3 + 2] = next;
    }

    private int getValue(int key) {
        this.ensureCapacity(key * 3);
        return this.backing[key * 3];
    }

    private int getPrev(int key) {
        this.ensureCapacity(key * 3 + 1);
        return this.backing[key * 3 + 1];
    }

    private int getNext(int key) {
        this.ensureCapacity(key * 3 + 2);
        return this.backing[key * 3 + 2];
    }

    private void ensureCapacity(int key) {
        if (key < 0 || key > this.capacity * 3) {
            throw new IllegalArgumentException("Cannot store key of value " + key);
        }
    }

    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.capacity; ++i) {
            this.setValue(i, 0);
            this.setPrev(i, -1);
            this.setNext(i, -1);
        }
    }

    public int getFront() {
        return this.front;
    }

    public int getBack() {
        return this.back;
    }
}

