/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.datastructures;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\"\u0010\u0006\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0086\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0006\u001a\u0004\u0018\u00018\u00002\u0006\u0010\t\u001a\u00020\bH\u0086\u0002\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/valkyrienskies/core/impl/datastructures/ChunkClaimMap;", "T", "", "", "chunkX", "chunkZ", "get", "(II)Ljava/lang/Object;", "Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;", "chunkClaim", "(Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;)Ljava/lang/Object;", "", "remove", "(Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;)V", "data", "set", "(Lorg/valkyrienskies/core/api/ships/properties/ChunkClaim;Ljava/lang/Object;)V", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "backingMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "<init>", "()V", "impl"})
public final class ChunkClaimMap<T> {
    @NotNull
    private final Long2ObjectMap<T> backingMap = (Long2ObjectMap)new Long2ObjectOpenHashMap();

    public final void set(@NotNull ChunkClaim chunkClaim, T data) {
        Intrinsics.checkNotNullParameter((Object)chunkClaim, (String)"chunkClaim");
        long claimAsLong = chunkClaim.toLong();
        if (this.backingMap.containsKey(claimAsLong)) {
            throw new IllegalArgumentException("Tried adding " + data + " at " + chunkClaim + ", but a value already exists at " + chunkClaim);
        }
        this.backingMap.put(claimAsLong, data);
    }

    public final void remove(@NotNull ChunkClaim chunkClaim) {
        Intrinsics.checkNotNullParameter((Object)chunkClaim, (String)"chunkClaim");
        long claimAsLong = chunkClaim.toLong();
        if (this.backingMap.remove(claimAsLong) == null) {
            throw new IllegalArgumentException("Tried to remove data at " + chunkClaim + ", but that claim wasn't in the chunk claim map!");
        }
    }

    @Nullable
    public final T get(@NotNull ChunkClaim chunkClaim) {
        Intrinsics.checkNotNullParameter((Object)chunkClaim, (String)"chunkClaim");
        return (T)this.backingMap.get(chunkClaim.toLong());
    }

    @Nullable
    public final T get(int chunkX, int chunkZ) {
        long chunkPosToClaimAsLong = ChunkClaim.Companion.getClaimThenToLong(chunkX, chunkZ);
        return (T)this.backingMap.get(chunkPosToClaimAsLong);
    }
}

