/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.collision;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.impl.collision.CollisionRange;
import org.valkyrienskies.core.impl.collision.CollisionRangec;
import org.valkyrienskies.core.impl.collision.CollisionResult;
import org.valkyrienskies.core.impl.collision.CollisionResultTimeToCollision;
import org.valkyrienskies.core.impl.collision.CollisionResultTimeToCollisionc;
import org.valkyrienskies.core.impl.collision.ConvexPolygonCollider;
import org.valkyrienskies.core.impl.collision.ConvexPolygonc;
import org.valkyrienskies.core.impl.collision.ConvexPolygoncKt;
import org.valkyrienskies.core.impl.util.VectorConversionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007JO\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J5\u0010\u0017\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0017\u0010\u0018J?\u0010\u001a\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJW\u0010\u001e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJE\u0010 \u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b \u0010!J=\u0010#\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\u0004\b#\u0010$J5\u0010&\u001a\u00020%2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016\u00a2\u0006\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Lorg/valkyrienskies/core/impl/collision/SATConvexPolygonCollider;", "Lorg/valkyrienskies/core/impl/collision/ConvexPolygonCollider;", "Lorg/joml/Vector3dc;", "a", "b", "", "angleCosHorizontalComponents", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)D", "Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;", "firstPolygon", "secondPolygon", "", "normals", "Lorg/valkyrienskies/core/impl/collision/CollisionResult;", "collisionResult", "Lorg/valkyrienskies/core/impl/collision/CollisionRange;", "temp1", "temp2", "forcedResponseNormal", "", "checkIfColliding", "(Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Ljava/util/Iterator;Lorg/valkyrienskies/core/impl/collision/CollisionResult;Lorg/valkyrienskies/core/impl/collision/CollisionRange;Lorg/valkyrienskies/core/impl/collision/CollisionRange;Lorg/joml/Vector3dc;)V", "normal", "computeCollisionResponseAlongNormal", "(Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/impl/collision/CollisionRange;Lorg/valkyrienskies/core/impl/collision/CollisionRange;)D", "firstPolygonVel", "computeCollisionResponseAlongNormalWithVel", "(Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/impl/collision/CollisionRange;Lorg/valkyrienskies/core/impl/collision/CollisionRange;)D", "maxSlopeClimbAngle", "forcedResponseNormalFromCaller", "computeResponseMinimizingChangesToVel", "(Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Ljava/util/Iterator;Lorg/valkyrienskies/core/impl/collision/CollisionRange;Lorg/valkyrienskies/core/impl/collision/CollisionRange;DLorg/joml/Vector3dc;)Lorg/joml/Vector3dc;", "computeResponseMinimizingChangesToVelHorOnly", "(Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Ljava/util/Iterator;Lorg/valkyrienskies/core/impl/collision/CollisionRange;Lorg/valkyrienskies/core/impl/collision/CollisionRange;)Lorg/joml/Vector3dc;", "firstPolygonVelocity", "computeTimeToCollisionAlongNormal", "(Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;Lorg/valkyrienskies/core/impl/collision/CollisionRange;Lorg/valkyrienskies/core/impl/collision/CollisionRange;)D", "Lorg/valkyrienskies/core/impl/collision/CollisionResultTimeToCollisionc;", "timeToCollision", "(Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;Lorg/joml/Vector3dc;Ljava/util/Iterator;)Lorg/valkyrienskies/core/impl/collision/CollisionResultTimeToCollisionc;", "<init>", "()V", "impl"})
public final class SATConvexPolygonCollider
implements ConvexPolygonCollider {
    @NotNull
    public static final SATConvexPolygonCollider INSTANCE = new SATConvexPolygonCollider();

    private SATConvexPolygonCollider() {
    }

    @Override
    public void checkIfColliding(@NotNull ConvexPolygonc firstPolygon, @NotNull ConvexPolygonc secondPolygon, @NotNull Iterator<? extends Vector3dc> normals, @NotNull CollisionResult collisionResult, @NotNull CollisionRange temp1, @NotNull CollisionRange temp2, @Nullable Vector3dc forcedResponseNormal) {
        Intrinsics.checkNotNullParameter((Object)firstPolygon, (String)"firstPolygon");
        Intrinsics.checkNotNullParameter((Object)secondPolygon, (String)"secondPolygon");
        Intrinsics.checkNotNullParameter(normals, (String)"normals");
        Intrinsics.checkNotNullParameter((Object)collisionResult, (String)"collisionResult");
        Intrinsics.checkNotNullParameter((Object)temp1, (String)"temp1");
        Intrinsics.checkNotNullParameter((Object)temp2, (String)"temp2");
        double minCollisionDepth = Double.MAX_VALUE;
        collisionResult.set_colliding(true);
        Iterator<? extends Vector3dc> iterator2 = normals;
        while (iterator2.hasNext()) {
            Vector3dc normal = iterator2.next();
            double rangeOverlapResponse = this.computeCollisionResponseAlongNormal(firstPolygon, secondPolygon, normal, temp1, temp2);
            if (Math.abs(rangeOverlapResponse) < 1.0E-6) {
                collisionResult.set_colliding(false);
                return;
            }
            if (forcedResponseNormal != null) {
                double modifiedRangeOverlapResponse;
                double collisionDepth;
                double dotProduct = forcedResponseNormal.dot(normal);
                if (Math.abs(dotProduct) < 1.0E-6 || !((collisionDepth = Math.abs(modifiedRangeOverlapResponse = rangeOverlapResponse / dotProduct)) < minCollisionDepth)) continue;
                minCollisionDepth = collisionDepth;
                collisionResult.get_collisionAxis().set(forcedResponseNormal);
                collisionResult.set_penetrationOffset(modifiedRangeOverlapResponse);
                continue;
            }
            double collisionDepth = Math.abs(rangeOverlapResponse);
            if (!(collisionDepth < minCollisionDepth)) continue;
            minCollisionDepth = collisionDepth;
            collisionResult.get_collisionAxis().set(normal);
            collisionResult.set_penetrationOffset(rangeOverlapResponse);
        }
        if (minCollisionDepth == Double.MAX_VALUE) {
            collisionResult.set_colliding(false);
        }
    }

    @Override
    @NotNull
    public Vector3dc computeResponseMinimizingChangesToVel(@NotNull ConvexPolygonc firstPolygon, @NotNull Vector3dc firstPolygonVel, @NotNull ConvexPolygonc secondPolygon, @NotNull Iterator<? extends Vector3dc> normals, @NotNull CollisionRange temp1, @NotNull CollisionRange temp2, double maxSlopeClimbAngle, @Nullable Vector3dc forcedResponseNormalFromCaller) {
        Intrinsics.checkNotNullParameter((Object)firstPolygon, (String)"firstPolygon");
        Intrinsics.checkNotNullParameter((Object)firstPolygonVel, (String)"firstPolygonVel");
        Intrinsics.checkNotNullParameter((Object)secondPolygon, (String)"secondPolygon");
        Intrinsics.checkNotNullParameter(normals, (String)"normals");
        Intrinsics.checkNotNullParameter((Object)temp1, (String)"temp1");
        Intrinsics.checkNotNullParameter((Object)temp2, (String)"temp2");
        Vector3dc newFirstPolygonVel = null;
        Iterator<? extends Vector3dc> iterator2 = normals;
        while (iterator2.hasNext()) {
            Vector3dc normal = iterator2.next();
            double collisionResponseAlongNormal = this.computeCollisionResponseAlongNormalWithVel(firstPolygon, firstPolygonVel, secondPolygon, normal, temp1, temp2);
            if (collisionResponseAlongNormal == 0.0) {
                return firstPolygonVel;
            }
            Vector3dc potentialNewVel = null;
            if (forcedResponseNormalFromCaller != null) {
                double dotProduct = normal.dot(forcedResponseNormalFromCaller);
                if (Math.abs(dotProduct) < 1.0E-6) continue;
                Vector3d newCollisionResponse = new Vector3d(collisionResponseAlongNormal * forcedResponseNormalFromCaller.x() / dotProduct, collisionResponseAlongNormal * forcedResponseNormalFromCaller.y() / dotProduct, collisionResponseAlongNormal * forcedResponseNormalFromCaller.z() / dotProduct);
                potentialNewVel = (Vector3dc)firstPolygonVel.add((Vector3dc)newCollisionResponse, new Vector3d());
            } else {
                if (Math.abs(normal.y()) >= Math.sin(Math.toRadians(maxSlopeClimbAngle))) {
                    double climbSlope;
                    Vector3d newCollisionResponse = new Vector3d(0.0, collisionResponseAlongNormal / normal.y(), 0.0);
                    Vector3dc vector3dc = potentialNewVel = (Vector3dc)firstPolygonVel.add((Vector3dc)newCollisionResponse, new Vector3d());
                    Intrinsics.checkNotNullExpressionValue((Object)vector3dc, (String)"potentialNewVel");
                    double potentialNewVelHorizontalComponent = VectorConversionsKt.horizontalLength(vector3dc);
                    if (potentialNewVelHorizontalComponent > 1.0E-6 && (climbSlope = Math.abs(((Vector3d)potentialNewVel).y()) / potentialNewVelHorizontalComponent) >= Math.tan(Math.toRadians(maxSlopeClimbAngle))) {
                        potentialNewVel = null;
                    }
                }
                if (potentialNewVel == null) {
                    Vector3d forcedResponseNormal = new Vector3d(normal.x(), 0.0, normal.z()).normalize();
                    if (!forcedResponseNormal.isFinite()) continue;
                    double dotProduct = normal.dot((Vector3dc)forcedResponseNormal);
                    Vector3d newCollisionResponse = new Vector3d(collisionResponseAlongNormal * forcedResponseNormal.x() / dotProduct, 0.0, collisionResponseAlongNormal * forcedResponseNormal.z() / dotProduct);
                    potentialNewVel = (Vector3dc)firstPolygonVel.add((Vector3dc)newCollisionResponse, new Vector3d());
                }
            }
            if (newFirstPolygonVel == null) {
                newFirstPolygonVel = potentialNewVel;
                continue;
            }
            Vector3dc vector3dc = potentialNewVel;
            Intrinsics.checkNotNull(vector3dc);
            Vector3d potentialNewVelDif = new Vector3d(vector3dc).sub(firstPolygonVel);
            Vector3d newFirstPolygonVelDif = new Vector3d(newFirstPolygonVel).sub(firstPolygonVel);
            if (!(potentialNewVelDif.lengthSquared() < newFirstPolygonVelDif.lengthSquared())) continue;
            newFirstPolygonVel = potentialNewVel;
        }
        Vector3dc vector3dc = newFirstPolygonVel;
        Intrinsics.checkNotNull(vector3dc);
        return vector3dc;
    }

    @Override
    @NotNull
    public Vector3dc computeResponseMinimizingChangesToVelHorOnly(@NotNull ConvexPolygonc firstPolygon, @NotNull Vector3dc firstPolygonVel, @NotNull ConvexPolygonc secondPolygon, @NotNull Iterator<? extends Vector3dc> normals, @NotNull CollisionRange temp1, @NotNull CollisionRange temp2) {
        Intrinsics.checkNotNullParameter((Object)firstPolygon, (String)"firstPolygon");
        Intrinsics.checkNotNullParameter((Object)firstPolygonVel, (String)"firstPolygonVel");
        Intrinsics.checkNotNullParameter((Object)secondPolygon, (String)"secondPolygon");
        Intrinsics.checkNotNullParameter(normals, (String)"normals");
        Intrinsics.checkNotNullParameter((Object)temp1, (String)"temp1");
        Intrinsics.checkNotNullParameter((Object)temp2, (String)"temp2");
        Vector3dc newFirstPolygonVel = null;
        Iterator<? extends Vector3dc> iterator2 = normals;
        while (iterator2.hasNext()) {
            Vector3dc normal = iterator2.next();
            double collisionResponseAlongNormal = this.computeCollisionResponseAlongNormalWithVel(firstPolygon, firstPolygonVel, secondPolygon, normal, temp1, temp2);
            if (collisionResponseAlongNormal == 0.0) {
                return firstPolygonVel;
            }
            Vector3dc potentialNewVel = null;
            Vector3d forcedResponseNormal = new Vector3d(normal.x(), 0.0, normal.z()).normalize();
            if (!forcedResponseNormal.isFinite()) continue;
            double dotProduct = normal.dot((Vector3dc)forcedResponseNormal);
            Vector3d newCollisionResponse = new Vector3d(collisionResponseAlongNormal * forcedResponseNormal.x() / dotProduct, 0.0, collisionResponseAlongNormal * forcedResponseNormal.z() / dotProduct);
            Vector3d vector3d = firstPolygonVel.add((Vector3dc)newCollisionResponse, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"firstPolygonVel.add(newC\u2026sionResponse, Vector3d())");
            potentialNewVel = (Vector3dc)vector3d;
            if (newFirstPolygonVel == null) {
                newFirstPolygonVel = potentialNewVel;
                continue;
            }
            Vector3d potentialNewVelDif = new Vector3d(potentialNewVel).sub(firstPolygonVel);
            Vector3d newFirstPolygonVelDif = new Vector3d(newFirstPolygonVel).sub(firstPolygonVel);
            if (!(potentialNewVelDif.lengthSquared() < newFirstPolygonVelDif.lengthSquared())) continue;
            newFirstPolygonVel = potentialNewVel;
        }
        Vector3dc vector3dc = newFirstPolygonVel;
        Intrinsics.checkNotNull(vector3dc);
        return vector3dc;
    }

    private final double angleCosHorizontalComponents(Vector3dc a, Vector3dc b) {
        return new Vector3d(a.x(), 0.0, a.z()).angleCos((Vector3dc)new Vector3d(b.x(), 0.0, b.z()));
    }

    @Override
    @NotNull
    public CollisionResultTimeToCollisionc timeToCollision(@NotNull ConvexPolygonc firstPolygon, @NotNull ConvexPolygonc secondPolygon, @NotNull Vector3dc firstPolygonVelocity, @NotNull Iterator<? extends Vector3dc> normals) {
        Intrinsics.checkNotNullParameter((Object)firstPolygon, (String)"firstPolygon");
        Intrinsics.checkNotNullParameter((Object)secondPolygon, (String)"secondPolygon");
        Intrinsics.checkNotNullParameter((Object)firstPolygonVelocity, (String)"firstPolygonVelocity");
        Intrinsics.checkNotNullParameter(normals, (String)"normals");
        CollisionRange temp1 = CollisionRange.Companion.create();
        CollisionRange temp2 = CollisionRange.Companion.create();
        CollisionResultTimeToCollision result = CollisionResultTimeToCollision.Companion.createEmptyCollisionResultTimeToCollision();
        double maxTimeToCollision = 0.0;
        result.set_initiallyColliding(true);
        Iterator<? extends Vector3dc> iterator2 = normals;
        while (iterator2.hasNext()) {
            Vector3dc normal = iterator2.next();
            double timeToImpactResponse = this.computeTimeToCollisionAlongNormal(firstPolygon, secondPolygon, firstPolygonVelocity, normal, temp1, temp2);
            if (timeToImpactResponse == 0.0) continue;
            result.set_initiallyColliding(false);
            if (!(timeToImpactResponse > maxTimeToCollision)) continue;
            maxTimeToCollision = timeToImpactResponse;
            result.get_collisionAxis().set(normal);
            result.set_timeToCollision(maxTimeToCollision);
            if (!(timeToImpactResponse == Double.POSITIVE_INFINITY)) continue;
            break;
        }
        return result;
    }

    public final double computeCollisionResponseAlongNormal(@NotNull ConvexPolygonc firstPolygon, @NotNull ConvexPolygonc secondPolygon, @NotNull Vector3dc normal, @NotNull CollisionRange temp1, @NotNull CollisionRange temp2) {
        Intrinsics.checkNotNullParameter((Object)firstPolygon, (String)"firstPolygon");
        Intrinsics.checkNotNullParameter((Object)secondPolygon, (String)"secondPolygon");
        Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
        Intrinsics.checkNotNullParameter((Object)temp1, (String)"temp1");
        Intrinsics.checkNotNullParameter((Object)temp2, (String)"temp2");
        CollisionRangec firstCollisionRange = ConvexPolygoncKt.getProjectionAlongAxis(firstPolygon, normal, temp1);
        CollisionRangec secondCollisionRange = ConvexPolygoncKt.getProjectionAlongAxis(secondPolygon, normal, temp2);
        return CollisionRangec.Companion.computeCollisionResponse(firstCollisionRange, secondCollisionRange);
    }

    private final double computeCollisionResponseAlongNormalWithVel(ConvexPolygonc firstPolygon, Vector3dc firstPolygonVel, ConvexPolygonc secondPolygon, Vector3dc normal, CollisionRange temp1, CollisionRange temp2) {
        CollisionRangec firstCollisionRange = ConvexPolygoncKt.getProjectionAlongAxis(firstPolygon, normal, temp1);
        CollisionRangec secondCollisionRange = ConvexPolygoncKt.getProjectionAlongAxis(secondPolygon, normal, temp2);
        double firstVelAlongNormal = normal.dot(firstPolygonVel);
        return CollisionRangec.Companion.computeCollisionResponseGivenVelocity(firstCollisionRange, secondCollisionRange, firstVelAlongNormal);
    }

    public final double computeTimeToCollisionAlongNormal(@NotNull ConvexPolygonc firstPolygon, @NotNull ConvexPolygonc secondPolygon, @NotNull Vector3dc firstPolygonVelocity, @NotNull Vector3dc normal, @NotNull CollisionRange temp1, @NotNull CollisionRange temp2) {
        Intrinsics.checkNotNullParameter((Object)firstPolygon, (String)"firstPolygon");
        Intrinsics.checkNotNullParameter((Object)secondPolygon, (String)"secondPolygon");
        Intrinsics.checkNotNullParameter((Object)firstPolygonVelocity, (String)"firstPolygonVelocity");
        Intrinsics.checkNotNullParameter((Object)normal, (String)"normal");
        Intrinsics.checkNotNullParameter((Object)temp1, (String)"temp1");
        Intrinsics.checkNotNullParameter((Object)temp2, (String)"temp2");
        CollisionRangec firstCollisionRange = ConvexPolygoncKt.getProjectionAlongAxis(firstPolygon, normal, temp1);
        CollisionRangec secondCollisionRange = ConvexPolygoncKt.getProjectionAlongAxis(secondPolygon, normal, temp2);
        double firstRangeVelocityAlongNormal = firstPolygonVelocity.dot(normal);
        return CollisionRangec.Companion.computeCollisionTime(firstCollisionRange, secondCollisionRange, firstRangeVelocityAlongNormal);
    }
}

