/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.collision;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.valkyrienskies.core.impl.collision.CollisionRange;
import org.valkyrienskies.core.impl.collision.CollisionResultTimeToCollisionc;
import org.valkyrienskies.core.impl.collision.ConvexPolygonCollider;
import org.valkyrienskies.core.impl.collision.ConvexPolygonc;
import org.valkyrienskies.core.impl.collision.SATConvexPolygonCollider;
import org.valkyrienskies.core.impl.collision.TransformedCuboidPolygon;
import org.valkyrienskies.core.impl.util.AABBdUtilKt;
import org.valkyrienskies.core.impl.util.VectorConversionsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b<\u0010=JG\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r0\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJI\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r0\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J-\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017JU\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r0\u000b2\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00062\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJS\u0010\u001d\u001a\u0018\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJI\u0010\u001f\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r0\u000b2\u0006\u0010\u0013\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\"\u0010#J3\u0010'\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00042\n\b\u0002\u0010%\u001a\u0004\u0018\u00010$2\u0010\b\u0002\u0010&\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u00a2\u0006\u0004\b'\u0010(J#\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020)H\u0002\u00a2\u0006\u0004\b+\u0010,J'\u0010/\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b/\u00100J\u001f\u00103\u001a\u00020\u00022\u0006\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b3\u00104R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0014\u00108\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00109R\u0014\u0010;\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u00109\u00a8\u0006>"}, d2={"Lorg/valkyrienskies/core/impl/collision/EntityPolygonCollider;", "", "Lorg/joml/Vector3dc;", "movement", "Lorg/joml/primitives/AABBdc;", "entityBoundingBox", "", "entityStepHeight", "", "Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;", "collidingPolygons", "Lkotlin/Pair;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "adjustEntityMovementForPolygonCollisions", "(Lorg/joml/Vector3dc;Lorg/joml/primitives/AABBdc;DLjava/util/List;)Lkotlin/Pair;", "entityVelocity", "adjustMovementComponentWise", "(Lorg/joml/primitives/AABBdc;Lorg/joml/Vector3dc;DLjava/util/List;)Lkotlin/Pair;", "entityAABB", "maxSlopeClimbAngle", "", "canStep4", "(Lorg/joml/primitives/AABBdc;Ljava/util/List;D)Z", "entityVel", "forcedResponseNormalFromCaller", "collide", "(Lorg/joml/primitives/AABBdc;Ljava/util/List;Lorg/joml/Vector3dc;DLorg/joml/Vector3dc;)Lkotlin/Pair;", "stepHeight", "collideWithStep", "(Lorg/joml/primitives/AABBdc;Ljava/util/List;Lorg/joml/Vector3dc;DD)Lkotlin/Pair;", "collideWithoutStep", "(Lorg/joml/primitives/AABBdc;Ljava/util/List;Lorg/joml/Vector3dc;D)Lkotlin/Pair;", "aabb", "createFeetAABB", "(Lorg/joml/primitives/AABBdc;)Lorg/joml/primitives/AABBdc;", "Lorg/joml/Matrix4dc;", "transform", "shipFrom", "createPolygonFromAABB", "(Lorg/joml/primitives/AABBdc;Lorg/joml/Matrix4dc;Ljava/lang/Long;)Lorg/valkyrienskies/core/impl/collision/ConvexPolygonc;", "", "shipNormals", "generateAllNormals", "(Ljava/lang/Iterable;)Ljava/util/List;", "topPosRelative", "botPosRelative", "getFeetSlice", "(Lorg/joml/primitives/AABBdc;DD)Lorg/joml/primitives/AABBdc;", "newVel", "originalVel", "roundNewVelToOriginal", "(Lorg/joml/Vector3dc;Lorg/joml/Vector3dc;)Lorg/joml/Vector3dc;", "", "UNIT_NORMALS", "[Lorg/joml/Vector3dc;", "X_NORMAL", "Lorg/joml/Vector3dc;", "Y_NORMAL", "Z_NORMAL", "<init>", "()V", "impl"})
public final class EntityPolygonCollider {
    @NotNull
    public static final EntityPolygonCollider INSTANCE = new EntityPolygonCollider();
    @NotNull
    private static final Vector3dc X_NORMAL = (Vector3dc)new Vector3d(1.0, 0.0, 0.0);
    @NotNull
    private static final Vector3dc Y_NORMAL = (Vector3dc)new Vector3d(0.0, 1.0, 0.0);
    @NotNull
    private static final Vector3dc Z_NORMAL = (Vector3dc)new Vector3d(0.0, 0.0, 1.0);
    @NotNull
    private static final Vector3dc[] UNIT_NORMALS;

    private EntityPolygonCollider() {
    }

    @NotNull
    public final ConvexPolygonc createPolygonFromAABB(@NotNull AABBdc aabb, @Nullable Matrix4dc transform, @Nullable Long shipFrom) {
        Intrinsics.checkNotNullParameter((Object)aabb, (String)"aabb");
        return TransformedCuboidPolygon.Companion.createFromAABB(aabb, transform, shipFrom);
    }

    public static /* synthetic */ ConvexPolygonc createPolygonFromAABB$default(EntityPolygonCollider entityPolygonCollider, AABBdc aABBdc, Matrix4dc matrix4dc, Long l, int n, Object object) {
        if ((n & 2) != 0) {
            matrix4dc = null;
        }
        if ((n & 4) != 0) {
            l = null;
        }
        return entityPolygonCollider.createPolygonFromAABB(aABBdc, matrix4dc, l);
    }

    @NotNull
    public final Pair<Vector3dc, Long> adjustEntityMovementForPolygonCollisions(@NotNull Vector3dc movement, @NotNull AABBdc entityBoundingBox, double entityStepHeight, @NotNull List<? extends ConvexPolygonc> collidingPolygons) {
        Intrinsics.checkNotNullParameter((Object)movement, (String)"movement");
        Intrinsics.checkNotNullParameter((Object)entityBoundingBox, (String)"entityBoundingBox");
        Intrinsics.checkNotNullParameter(collidingPolygons, (String)"collidingPolygons");
        return this.adjustMovementComponentWise(entityBoundingBox, movement, entityStepHeight, collidingPolygons);
    }

    private final Pair<Vector3dc, Long> adjustMovementComponentWise(AABBdc entityBoundingBox, Vector3dc entityVelocity, double entityStepHeight, List<? extends ConvexPolygonc> collidingPolygons) {
        boolean attemptStep;
        double maxSlopeClimbAngle = 45.0;
        boolean bl = attemptStep = VectorConversionsKt.horizontalLengthSq(entityVelocity) > 1.0E-8 && entityStepHeight > 0.0;
        if (attemptStep) {
            Pair yOnlyCollision = EntityPolygonCollider.collide$default(this, entityBoundingBox, collidingPolygons, (Vector3dc)new Vector3d(0.0, -0.2, 0.0), maxSlopeClimbAngle, null, 16, null);
            AABBd aABBd = entityBoundingBox.translate((Vector3dc)yOnlyCollision.getFirst(), new AABBd());
            Intrinsics.checkNotNullExpressionValue((Object)aABBd, (String)"entityBoundingBox.transl\u2026Collision.first, AABBd())");
            boolean canStepOriginally = this.canStep4((AABBdc)aABBd, collidingPolygons, maxSlopeClimbAngle);
            if (canStepOriginally) {
                Pair<Vector3dc, Long> pair;
                Pair<Vector3dc, Long> pair2 = this.collideWithStep(entityBoundingBox, collidingPolygons, entityVelocity, maxSlopeClimbAngle, entityStepHeight);
                if (pair2 == null) {
                    return this.collideWithoutStep(entityBoundingBox, collidingPolygons, entityVelocity, maxSlopeClimbAngle);
                }
                Pair<Vector3dc, Long> collisionWithStep = pair2;
                if (VectorConversionsKt.differenceHorLengthSq((Vector3dc)collisionWithStep.getFirst(), entityVelocity) < 1.0E-8) {
                    pair = collisionWithStep;
                } else {
                    Pair<Vector3dc, Long> collisionWithoutStep = this.collideWithoutStep(entityBoundingBox, collidingPolygons, entityVelocity, maxSlopeClimbAngle);
                    pair = VectorConversionsKt.differenceHorLengthSq((Vector3dc)collisionWithStep.getFirst(), entityVelocity) <= VectorConversionsKt.differenceHorLengthSq((Vector3dc)collisionWithoutStep.getFirst(), entityVelocity) ? collisionWithStep : collisionWithoutStep;
                }
                return pair;
            }
        }
        return this.collideWithoutStep(entityBoundingBox, collidingPolygons, entityVelocity, maxSlopeClimbAngle);
    }

    private final Pair<Vector3dc, Long> collideWithStep(AABBdc entityAABB, List<? extends ConvexPolygonc> collidingPolygons, Vector3dc entityVel, double maxSlopeClimbAngle, double stepHeight) {
        if (!(stepHeight >= 0.0)) {
            boolean $i$a$-require-EntityPolygonCollider$collideWithStep$42 = false;
            String $i$a$-require-EntityPolygonCollider$collideWithStep$42 = "StepHeight was " + stepHeight + ", which is less than 0.0!";
            throw new IllegalArgumentException($i$a$-require-EntityPolygonCollider$collideWithStep$42.toString());
        }
        if (!(maxSlopeClimbAngle >= 0.0)) {
            boolean $i$a$-require-EntityPolygonCollider$collideWithStep$52 = false;
            String $i$a$-require-EntityPolygonCollider$collideWithStep$52 = "MaxSlopeClimbAngle was " + maxSlopeClimbAngle + ", which is less than 0.0!";
            throw new IllegalArgumentException($i$a$-require-EntityPolygonCollider$collideWithStep$52.toString());
        }
        if (!(maxSlopeClimbAngle < 90.0)) {
            boolean $i$a$-require-EntityPolygonCollider$collideWithStep$62 = false;
            String $i$a$-require-EntityPolygonCollider$collideWithStep$62 = "MaxSlopeClimbAngle was " + maxSlopeClimbAngle + ", which is greater than or equal to 90.0!";
            throw new IllegalArgumentException($i$a$-require-EntityPolygonCollider$collideWithStep$62.toString());
        }
        Vector3dc upCollisionResultVel = (Vector3dc)this.collide(entityAABB, collidingPolygons, (Vector3dc)new Vector3d(0.0, stepHeight, 0.0), maxSlopeClimbAngle, Y_NORMAL).getFirst();
        double $i$a$-require-EntityPolygonCollider$collideWithStep$62 = upCollisionResultVel.y();
        if (!(0.0 <= $i$a$-require-EntityPolygonCollider$collideWithStep$62 ? $i$a$-require-EntityPolygonCollider$collideWithStep$62 <= stepHeight : false)) {
            return null;
        }
        AABBd playerBBMovedUp = entityAABB.translate(upCollisionResultVel, new AABBd());
        Intrinsics.checkNotNullExpressionValue((Object)playerBBMovedUp, (String)"playerBBMovedUp");
        Vector3dc horizontalCollisionResultVel = (Vector3dc)EntityPolygonCollider.collide$default(this, (AABBdc)playerBBMovedUp, collidingPolygons, (Vector3dc)new Vector3d(entityVel.x(), 0.0, entityVel.z()), maxSlopeClimbAngle, null, 16, null).getFirst();
        double moveDown = upCollisionResultVel.y() - entityVel.y();
        AABBd playerBBMovedUpThenHorizontal = playerBBMovedUp.translate(horizontalCollisionResultVel, new AABBd());
        Intrinsics.checkNotNullExpressionValue((Object)playerBBMovedUpThenHorizontal, (String)"playerBBMovedUpThenHorizontal");
        Pair<Vector3dc, Long> downCollisionResult = this.collide((AABBdc)playerBBMovedUpThenHorizontal, collidingPolygons, (Vector3dc)new Vector3d(0.0, -moveDown, 0.0), maxSlopeClimbAngle, Y_NORMAL);
        Vector3dc downCollisionResultVel = (Vector3dc)downCollisionResult.getFirst();
        Long lastShipCollided = (Long)downCollisionResult.getSecond();
        Vector3d finalVelocity = new Vector3d(upCollisionResultVel).add(horizontalCollisionResultVel).add(downCollisionResultVel);
        AABBd playerBBAfterMove = entityAABB.translate((Vector3dc)finalVelocity, new AABBd());
        Intrinsics.checkNotNullExpressionValue((Object)playerBBAfterMove, (String)"playerBBAfterMove");
        boolean canStepAfter = this.canStep4((AABBdc)playerBBAfterMove, collidingPolygons, maxSlopeClimbAngle);
        if (!canStepAfter) {
            Pair downCollisionResult2 = EntityPolygonCollider.collide$default(this, (AABBdc)playerBBAfterMove, collidingPolygons, (Vector3dc)new Vector3d(0.0, -moveDown - downCollisionResultVel.y(), 0.0), maxSlopeClimbAngle, null, 16, null);
            Vector3d newFinalVelocity = new Vector3d((Vector3dc)finalVelocity).add((Vector3dc)downCollisionResult2.getFirst());
            double d = newFinalVelocity.y();
            if (!(0.0 <= d ? d <= stepHeight : false)) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)newFinalVelocity, (String)"newFinalVelocity");
            return new Pair((Object)this.roundNewVelToOriginal((Vector3dc)newFinalVelocity, entityVel), downCollisionResult2.getSecond());
        }
        double d = finalVelocity.y();
        if (!(0.0 <= d ? d <= stepHeight : false)) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)finalVelocity, (String)"finalVelocity");
        return new Pair((Object)this.roundNewVelToOriginal((Vector3dc)finalVelocity, entityVel), (Object)lastShipCollided);
    }

    private final Pair<Vector3dc, Long> collideWithoutStep(AABBdc entityAABB, List<? extends ConvexPolygonc> collidingPolygons, Vector3dc entityVel, double maxSlopeClimbAngle) {
        return EntityPolygonCollider.collide$default(this, entityAABB, collidingPolygons, entityVel, maxSlopeClimbAngle, null, 16, null);
    }

    private final Pair<Vector3dc, Long> collide(AABBdc entityAABB, List<? extends ConvexPolygonc> collidingPolygons, Vector3dc entityVel, double maxSlopeClimbAngle, Vector3dc forcedResponseNormalFromCaller) {
        AABBdc feetAABB = this.createFeetAABB(entityAABB);
        ConvexPolygonc entityPolygon = TransformedCuboidPolygon.Companion.createFromAABB$default(TransformedCuboidPolygon.Companion, entityAABB, null, null, 6, null);
        Iterable $this$sortedBy$iv = collidingPolygons;
        boolean $i$f$sortedBy = false;
        List polysSorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(feetAABB){
            final /* synthetic */ AABBdc $feetAABB$inlined;
            {
                this.$feetAABB$inlined = aABBdc;
            }

            public final int compare(T a, T b) {
                ConvexPolygonc it = (ConvexPolygonc)a;
                boolean bl = false;
                Vector3d centerPos = it.computeCenterPos(new Vector3d());
                it = (ConvexPolygonc)b;
                Comparable comparable = Double.valueOf(AABBdUtilKt.signedDistanceTo(this.$feetAABB$inlined, (Vector3dc)centerPos));
                bl = false;
                centerPos = it.computeCenterPos(new Vector3d());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(AABBdUtilKt.signedDistanceTo(this.$feetAABB$inlined, (Vector3dc)centerPos)));
            }
        });
        Vector3d newEntityVelocity = null;
        newEntityVelocity = new Vector3d(entityVel);
        Long lastCollidedShipId = null;
        Iterable $this$forEach$iv = polysSorted;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean canStep;
            ConvexPolygonc shipPoly = (ConvexPolygonc)element$iv;
            boolean bl = false;
            if (!AABBdUtilKt.intersectsAABB((AABBdc)AABBdUtilKt.extend(new AABBd(entityPolygon.getAabb()), (Vector3dc)newEntityVelocity), shipPoly.getAabb())) continue;
            List<Vector3dc> allNormals = INSTANCE.generateAllNormals(shipPoly.getNormals());
            CollisionResultTimeToCollisionc timeOfImpactResponse = SATConvexPolygonCollider.INSTANCE.timeToCollision(entityPolygon, shipPoly, (Vector3dc)newEntityVelocity, allNormals.iterator());
            double d = timeOfImpactResponse.getInitiallyColliding() ? 0.0 : timeOfImpactResponse.getTimeToCollision();
            double timeToCollision = d;
            if (!(timeToCollision < 1.0)) continue;
            Vector3d vector3d = ((Vector3dc)newEntityVelocity).mul(timeToCollision, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"newEntityVelocity.mul(timeToCollision, Vector3d())");
            Vector3dc velAlreadyHappened = (Vector3dc)vector3d;
            Vector3d vector3d2 = ((Vector3dc)newEntityVelocity).mul(1.0 - timeToCollision, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"newEntityVelocity.mul(1.\u2026eToCollision, Vector3d())");
            Vector3dc velNotYetHappened = (Vector3dc)vector3d2;
            lastCollidedShipId = shipPoly.getShipFrom();
            AABBd entityAABBTranslatedByVelAlreadyHappened = entityAABB.translate(velAlreadyHappened, new AABBd());
            Intrinsics.checkNotNullExpressionValue((Object)entityAABBTranslatedByVelAlreadyHappened, (String)"entityAABBTranslatedByVelAlreadyHappened");
            TransformedCuboidPolygon entityPolygonTranslatedByVelAlreadyHappened = TransformedCuboidPolygon.Companion.createFromAABB$default(TransformedCuboidPolygon.Companion, (AABBdc)entityAABBTranslatedByVelAlreadyHappened, null, null, 6, null);
            if (forcedResponseNormalFromCaller == null && (canStep = INSTANCE.canStep4((AABBdc)entityAABBTranslatedByVelAlreadyHappened, polysSorted, maxSlopeClimbAngle))) {
                boolean nextStep;
                Vector3dc velNotYetHappenedAfterCollision = SATConvexPolygonCollider.INSTANCE.computeResponseMinimizingChangesToVel(entityPolygonTranslatedByVelAlreadyHappened, velNotYetHappened, shipPoly, allNormals.iterator(), CollisionRange.Companion.create(), CollisionRange.Companion.create(), maxSlopeClimbAngle, Y_NORMAL);
                double entityHeight = 1.7;
                double relMaxChange = 0.2;
                boolean bl2 = nextStep = velNotYetHappened.y() < 0.0 && velNotYetHappenedAfterCollision.y() > velNotYetHappened.y() && velNotYetHappenedAfterCollision.y() < relMaxChange * entityHeight || velNotYetHappened.y() > 0.0 && velNotYetHappenedAfterCollision.y() < velNotYetHappened.y() && velNotYetHappenedAfterCollision.y() > relMaxChange * entityHeight;
                if (nextStep) {
                    Intrinsics.checkNotNullExpressionValue((Object)velAlreadyHappened.add(velNotYetHappenedAfterCollision, new Vector3d()), (String)"velAlreadyHappened.add(v\u2026terCollision, Vector3d())");
                    continue;
                }
            }
            Vector3dc velNotYetHappenedAfterCollision = SATConvexPolygonCollider.INSTANCE.computeResponseMinimizingChangesToVel(entityPolygonTranslatedByVelAlreadyHappened, velNotYetHappened, shipPoly, allNormals.iterator(), CollisionRange.Companion.create(), CollisionRange.Companion.create(), maxSlopeClimbAngle, forcedResponseNormalFromCaller);
            Vector3d newVelocity = velAlreadyHappened.add(velNotYetHappenedAfterCollision, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)newVelocity, (String)"newVelocity");
            newEntityVelocity = newVelocity;
        }
        return new Pair((Object)this.roundNewVelToOriginal((Vector3dc)newEntityVelocity, entityVel), lastCollidedShipId);
    }

    static /* synthetic */ Pair collide$default(EntityPolygonCollider entityPolygonCollider, AABBdc aABBdc, List list, Vector3dc vector3dc, double d, Vector3dc vector3dc2, int n, Object object) {
        if ((n & 0x10) != 0) {
            vector3dc2 = null;
        }
        return entityPolygonCollider.collide(aABBdc, list, vector3dc, d, vector3dc2);
    }

    private final Vector3dc roundNewVelToOriginal(Vector3dc newVel, Vector3dc originalVel) {
        Vector3d newEntityVelocity = new Vector3d(newVel);
        double velEpsilon = 1.0E-8;
        if (Math.abs(newEntityVelocity.x() - originalVel.x()) < velEpsilon) {
            newEntityVelocity.x = originalVel.x();
        }
        if (Math.abs(newEntityVelocity.y() - originalVel.y()) < velEpsilon) {
            newEntityVelocity.y = originalVel.y();
        }
        if (Math.abs(newEntityVelocity.z() - originalVel.z()) < velEpsilon) {
            newEntityVelocity.z = originalVel.z();
        }
        return (Vector3dc)newEntityVelocity;
    }

    private final AABBdc getFeetSlice(AABBdc entityAABB, double topPosRelative, double botPosRelative) {
        double height = entityAABB.maxY() - entityAABB.minY();
        double footYPos = entityAABB.minY();
        double topPos = footYPos + topPosRelative * height;
        double botPos = footYPos + botPosRelative * height;
        return (AABBdc)new AABBd(entityAABB.minX(), botPos, entityAABB.minZ(), entityAABB.maxX(), topPos, entityAABB.maxZ());
    }

    private final boolean canStep4(AABBdc entityAABB, List<? extends ConvexPolygonc> collidingPolygons, double maxSlopeClimbAngle) {
        double relativeHeight = 0.001;
        double yDepth = (entityAABB.maxY() - entityAABB.minY()) * relativeHeight;
        AABBdc footBox = this.getFeetSlice(entityAABB, 0.0, relativeHeight);
        TransformedCuboidPolygon footBoxPoly = TransformedCuboidPolygon.Companion.createFromAABB$default(TransformedCuboidPolygon.Companion, footBox, null, null, 6, null);
        Iterable $this$sortedBy$iv = collidingPolygons;
        boolean $i$f$sortedBy = false;
        List polysSorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(footBox){
            final /* synthetic */ AABBdc $footBox$inlined;
            {
                this.$footBox$inlined = aABBdc;
            }

            public final int compare(T a, T b) {
                ConvexPolygonc it = (ConvexPolygonc)a;
                boolean bl = false;
                Vector3d centerPos = it.computeCenterPos(new Vector3d());
                it = (ConvexPolygonc)b;
                Comparable comparable = Double.valueOf(AABBdUtilKt.signedDistanceTo(this.$footBox$inlined, (Vector3dc)centerPos));
                bl = false;
                centerPos = it.computeCenterPos(new Vector3d());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(AABBdUtilKt.signedDistanceTo(this.$footBox$inlined, (Vector3dc)centerPos)));
            }
        });
        Vector3d footBoxResponse = null;
        footBoxResponse = new Vector3d();
        Iterable $this$forEach$iv = polysSorted;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConvexPolygonc shipPoly = (ConvexPolygonc)element$iv;
            boolean bl = false;
            if (!AABBdUtilKt.intersectsAABB(footBoxPoly.getAabb(), shipPoly.getAabb())) continue;
            List<Vector3dc> allNormals = INSTANCE.generateAllNormals(shipPoly.getNormals());
            footBoxResponse = SATConvexPolygonCollider.INSTANCE.computeResponseMinimizingChangesToVelHorOnly(footBoxPoly, (Vector3dc)footBoxResponse, shipPoly, allNormals.iterator(), CollisionRange.Companion.create(), CollisionRange.Companion.create());
        }
        double maxHorLength = yDepth * Math.tan(Math.toRadians(90.0 - maxSlopeClimbAngle));
        AABBdc topSlice = this.getFeetSlice(entityAABB, 0.0, -relativeHeight);
        AABBd aABBd = new AABBd(topSlice.minX() + maxHorLength, topSlice.minY(), topSlice.minZ() + maxHorLength, topSlice.maxX() - maxHorLength, topSlice.maxY(), topSlice.maxZ() - maxHorLength).translate((Vector3dc)footBoxResponse);
        Intrinsics.checkNotNullExpressionValue((Object)aABBd, (String)"AABBd(\n            topSl\u2026ranslate(footBoxResponse)");
        topSlice = (AABBdc)aABBd;
        TransformedCuboidPolygon topSlicePoly = TransformedCuboidPolygon.Companion.createFromAABB$default(TransformedCuboidPolygon.Companion, topSlice, null, null, 6, null);
        Iterable $this$forEach$iv2 = polysSorted;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            List<Vector3dc> allNormals;
            Vector3dc topResponse;
            ConvexPolygonc shipPoly = (ConvexPolygonc)element$iv;
            boolean bl = false;
            if (!AABBdUtilKt.intersectsAABB(topSlicePoly.getAabb(), shipPoly.getAabb()) || !((topResponse = ConvexPolygonCollider.computeResponseMinimizingChangesToVel$default(SATConvexPolygonCollider.INSTANCE, topSlicePoly, (Vector3dc)new Vector3d(), shipPoly, (allNormals = INSTANCE.generateAllNormals(shipPoly.getNormals())).iterator(), CollisionRange.Companion.create(), CollisionRange.Companion.create(), maxSlopeClimbAngle, null, 128, null)).lengthSquared() > 1.0E-8)) continue;
            return true;
        }
        return false;
    }

    private final AABBdc createFeetAABB(AABBdc aabb) {
        return (AABBdc)new AABBd(aabb.minX(), aabb.minY(), aabb.minZ(), aabb.maxX(), aabb.minY() + 0.1 * (aabb.maxY() - aabb.minY()), aabb.maxZ());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Vector3dc> generateAllNormals(Iterable<? extends Vector3dc> shipNormals) {
        void var4_5;
        ArrayList<Vector3dc> normals = new ArrayList<Vector3dc>();
        Vector3dc[] vector3dcArray = UNIT_NORMALS;
        boolean bl = false;
        int n = vector3dcArray.length;
        while (var4_5 < n) {
            Vector3dc normal = vector3dcArray[var4_5];
            normals.add(normal);
            ++var4_5;
        }
        for (Vector3dc vector3dc : shipNormals) {
            normals.add(vector3dc);
            for (Vector3dc unitNormal : UNIT_NORMALS) {
                Vector3d vector3d = vector3dc.cross(unitNormal, new Vector3d()).normalize();
                Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"normal.cross(unitNormal, Vector3d()).normalize()");
                Vector3dc crossProduct = (Vector3dc)vector3d;
                if (!(crossProduct.lengthSquared() > 1.0E-6)) continue;
                normals.add(crossProduct);
            }
        }
        return normals;
    }

    static {
        Vector3dc[] vector3dcArray = new Vector3dc[]{X_NORMAL, Y_NORMAL, Z_NORMAL};
        UNIT_NORMALS = vector3dcArray;
    }
}

